/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.shader;

import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Scene;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.shader.CubeMap;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ImageData;
import de.jreality.shader.Texture2D;
import de.jreality.util.Input;
import de.jreality.util.TargaFile;
import java.awt.Color;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class TextureUtility {
    private static String[] texture2dNames = new String[]{"texture2d", "texture2d[1]", "texture2d[2]", "texture2d[3]"};
    public static final String[] STANDARD_CUBEMAP_PARTS = new String[]{"bk", "ft", "dn", "up", "lf", "rt"};
    private static int[] order = new int[]{5, 4, 2, 3, 1, 0};

    protected TextureUtility() {
    }

    private static Texture2D createTextureImpl(Appearance app, String key, ImageData img, boolean readDefaults) {
        Texture2D ret = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, key, app, readDefaults);
        ret.setImage(img);
        return ret;
    }

    public static Texture2D createTexture(Appearance app, String shader, ImageData img, boolean readDefaults) {
        return TextureUtility.createTexture(app, shader, 0, img, readDefaults);
    }

    public static Texture2D createTexture(Appearance app, String shader, int i, ImageData img, boolean readDefaults) {
        String key = shader == null || shader.equals("") ? texture2dNames[i] : shader + "." + texture2dNames[i];
        return TextureUtility.createTextureImpl(app, key, img, readDefaults);
    }

    public static Texture2D createTexture(Appearance app, String shader, ImageData img) {
        return TextureUtility.createTexture(app, shader, 0, img, true);
    }

    public static Texture2D createTexture(Appearance app, String shader, int i, ImageData img) {
        return TextureUtility.createTexture(app, shader, i, img, true);
    }

    public static Texture2D createTexture(Appearance app, String shader, Input in, boolean readDefaults) throws IOException {
        return TextureUtility.createTexture(app, shader, ImageData.load(in), readDefaults);
    }

    public static Texture2D createTexture(Appearance app, String shader, Input in) throws IOException {
        return TextureUtility.createTexture(app, shader, in, true);
    }

    public static Texture2D createTexture(Appearance app, String shader, String resourceName, boolean readDefaults) throws IOException {
        return TextureUtility.createTexture(app, shader, Input.getInput(resourceName), readDefaults);
    }

    public static Texture2D createTexture(Appearance app, String shader, String resourceName) throws IOException {
        return TextureUtility.createTexture(app, shader, resourceName, true);
    }

    public static CubeMap createReflectionMap(Appearance app, String shader, ImageData ... imgs) {
        String key;
        String string = key = shader == null || shader.equals("") ? "reflectionMap" : shader + ".reflectionMap";
        if (imgs != null) {
            if (imgs.length != 6) {
                throw new IllegalArgumentException("need 6 images for reflection map");
            }
            return TextureUtility.createCubeMap(app, key, imgs);
        }
        app.setAttribute(key, Appearance.INHERITED);
        return null;
    }

    public static CubeMap createReflectionMap(Appearance app, String shader, Input[] data) throws IOException {
        ImageData[] imgs = new ImageData[data.length];
        for (int i = 0; i < imgs.length; ++i) {
            imgs[i] = ImageData.load(data[i]);
        }
        return TextureUtility.createReflectionMap(app, shader, imgs);
    }

    public static CubeMap createReflectionMap(Appearance app, String shader, String resourcePrefix, String[] sides, String resourceEnding) throws IOException {
        Input[] data = new Input[sides.length];
        for (int i = 0; i < sides.length; ++i) {
            data[i] = Input.getInput(resourcePrefix + sides[i] + resourceEnding);
        }
        return TextureUtility.createReflectionMap(app, shader, data);
    }

    public static CubeMap readReflectionMap(EffectiveAppearance app, String prefix) {
        return (CubeMap)AttributeEntityUtility.createAttributeEntity(CubeMap.class, prefix, app);
    }

    public static ImageData[] getCubeMapImages(CubeMap rm) {
        ImageData[] sides = new ImageData[]{rm.getBack(), rm.getFront(), rm.getBottom(), rm.getTop(), rm.getLeft(), rm.getRight()};
        return sides;
    }

    public static CubeMap createCubeMap(final Appearance app, final String prefix, final ImageData[] imgs) {
        if (imgs.length != 6) {
            throw new IllegalArgumentException("need 6 images for reflection map");
        }
        final CubeMap[] cm = new CubeMap[1];
        Scene.executeWriter(app, new Runnable(){

            public void run() {
                CubeMap ret = (CubeMap)AttributeEntityUtility.createAttributeEntity(CubeMap.class, prefix, app, true);
                ret.setBack(imgs[0]);
                ret.setFront(imgs[1]);
                ret.setBottom(imgs[2]);
                ret.setTop(imgs[3]);
                ret.setLeft(imgs[4]);
                ret.setRight(imgs[5]);
                cm[0] = ret;
            }
        });
        return cm[0];
    }

    public static CubeMap createSkyBox(Appearance app, ImageData[] imgs) {
        if (imgs != null) {
            if (imgs.length != 6) {
                throw new IllegalArgumentException("need 6 images for reflection map");
            }
            return TextureUtility.createCubeMap(app, "skyBox", imgs);
        }
        app.setAttribute("skyBox", Appearance.INHERITED);
        return null;
    }

    public static CubeMap createSkyBox(Appearance app, Input[] data) throws IOException {
        ImageData[] imgs = new ImageData[data.length];
        for (int i = 0; i < imgs.length; ++i) {
            imgs[i] = ImageData.load(data[i]);
        }
        return TextureUtility.createSkyBox(app, imgs);
    }

    public static CubeMap createCubeMap(Appearance app, String prefix, String resourcePrefix, String[] sides, String resourceEnding) throws IOException {
        return TextureUtility.createCubeMap(app, prefix, TextureUtility.createCubeMapData(resourcePrefix, sides, resourceEnding));
    }

    public static ImageData[] createCubeMapData(String resourcePrefix, String[] sides, String resourceEnding) throws IOException {
        Input[] data = new Input[sides.length];
        ImageData[] imgs = new ImageData[data.length];
        for (int i = 0; i < sides.length; ++i) {
            data[i] = Input.getInput(resourcePrefix + sides[i] + resourceEnding);
            imgs[i] = ImageData.load(data[i]);
        }
        return imgs;
    }

    public static ImageData[] createCubeMapData(Input zipFile) throws IOException {
        ZipInputStream zis = new ZipInputStream(zipFile.getInputStream());
        ImageData[] id = new ImageData[6];
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int index;
            if (!ze.isDirectory() && (index = TextureUtility.findIndex(ze.getName())) != -1) {
                id[index] = ze.getName().toLowerCase().endsWith(".tga") ? new ImageData(TargaFile.getBufferedImage(zis)) : ImageData.load(Input.getInput("zip entry", zis));
            }
            ze = zis.getNextEntry();
        }
        return id;
    }

    private static int findIndex(String name) {
        if (name.contains("posx") || name.contains("positive_x")) {
            return 0;
        }
        if (name.contains("negx") || name.contains("negative_x")) {
            return 1;
        }
        if (name.contains("posy") || name.contains("positive_y")) {
            return 2;
        }
        if (name.contains("negy") || name.contains("negative_y")) {
            return 3;
        }
        if (name.contains("posz") || name.contains("positive_z")) {
            return 4;
        }
        if (name.contains("negz") || name.contains("negative_z")) {
            return 5;
        }
        if (name.contains("lf.")) {
            return order[0];
        }
        if (name.contains("rt.")) {
            return order[1];
        }
        if (name.contains("up.")) {
            return order[2];
        }
        if (name.contains("dn.")) {
            return order[3];
        }
        if (name.contains("bk.")) {
            return order[4];
        }
        if (name.contains("ft.")) {
            return order[5];
        }
        return -1;
    }

    public static ImageData createPointSprite(int textureSize, double[] lightDirection, Color diffuseColor, Color specularColor, double specularExponent) {
        double z;
        if (lightDirection == null) {
            lightDirection = new double[]{1.0, -1.0, 2.0};
        }
        double[][] sphereVertices = new double[textureSize * textureSize][3];
        int I = 0;
        int II = 0;
        for (int i = 0; i < textureSize; ++i) {
            double y = 2.0 * ((double)i + 0.5) / (double)textureSize - 1.0;
            for (int j = 0; j < textureSize; ++j) {
                double x = 2.0 * ((double)j + 0.5) / (double)textureSize - 1.0;
                double dsq = x * x + y * y;
                if (dsq <= 1.0) {
                    z = Math.sqrt(1.0 - dsq);
                    sphereVertices[I][0] = x;
                    sphereVertices[I][1] = y;
                    sphereVertices[I][2] = z;
                } else {
                    sphereVertices[I][2] = -1.0;
                    sphereVertices[I][1] = -1.0;
                    sphereVertices[I][0] = -1.0;
                }
                ++I;
            }
        }
        float[] diffuseColorAsFloat = diffuseColor.getColorComponents(null);
        float[] specularColorAsFloat = specularColor.getColorComponents(null);
        double[] reflected = new double[3];
        byte[] sphereTex = new byte[textureSize * textureSize * 4];
        for (int i = 0; i < textureSize; ++i) {
            for (int j = 0; j < textureSize; ++j) {
                if (sphereVertices[I][0] != -1.0) {
                    double diffuse = Rn.innerProduct(lightDirection, sphereVertices[I]);
                    if (diffuse < 0.0) {
                        diffuse = 0.0;
                    }
                    if (diffuse > 1.0) {
                        diffuse = 1.0;
                    }
                    z = sphereVertices[I][2];
                    reflected[0] = 2.0 * sphereVertices[I][0] * z;
                    reflected[1] = 2.0 * sphereVertices[I][1] * z;
                    reflected[2] = 2.0 * z * z - 1.0;
                    double specular = Rn.innerProduct(lightDirection, reflected);
                    if (specular < 0.0) {
                        specular = 0.0;
                    }
                    if (specular > 1.0) {
                        specular = 1.0;
                    }
                    specular = Math.pow(specular, specularExponent);
                    for (int k = 0; k < 3; ++k) {
                        double f = diffuse * (double)diffuseColorAsFloat[k] + specular * (double)specularColorAsFloat[k];
                        if (f < 0.0) {
                            f = 0.0;
                        }
                        if (f > 1.0) {
                            f = 1.0;
                        }
                        sphereTex[II + k] = (byte)(255.0 * f);
                    }
                    sphereTex[II + 3] = sphereVertices[I][2] < 0.1 ? (int)((int)(2550.0 * sphereVertices[I][2])) : -128;
                } else {
                    sphereTex[II + 3] = 0;
                    sphereTex[II + 2] = 0;
                    sphereTex[II + 1] = 0;
                    sphereTex[II] = 0;
                }
                II += 4;
                ++I;
            }
        }
        return new ImageData(sphereTex, textureSize, textureSize);
    }

    public static void removeReflectionMap(Appearance app, String shader) {
        String key;
        String string = key = shader == null || shader.equals("") ? "reflectionMap" : shader + ".reflectionMap";
        if (AttributeEntityUtility.hasAttributeEntity(CubeMap.class, key, app)) {
            CubeMap cm = (CubeMap)AttributeEntityUtility.createAttributeEntity(CubeMap.class, key, app, false);
            app.setAttribute(key, Appearance.INHERITED);
            cm.setBack(null);
            cm.setFront(null);
            cm.setBottom(null);
            cm.setTop(null);
            cm.setLeft(null);
            cm.setRight(null);
            cm.setBlendColor(null);
        }
    }

    public static void removeTexture(Appearance app, String shader) {
        String key;
        String string = key = shader == null || shader.equals("") ? "texture2d" : shader + ".texture2d";
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, key, app)) {
            Texture2D tex = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, key, app, false);
            app.setAttribute(key, Appearance.INHERITED);
            tex.setImage(null);
            tex.setTextureMatrix(null);
        }
    }

    public static void main(String[] args) throws IOException {
        TextureUtility.createCubeMapData(Input.getInput("/home/weissman/Desktop/test_cubemap.zip"));
    }

    public static boolean hasReflectionMap(EffectiveAppearance ea, String shader) {
        String key = shader == null || shader.equals("") ? "reflectionMap" : shader + ".reflectionMap";
        return AttributeEntityUtility.hasAttributeEntity(CubeMap.class, key, ea);
    }

    public static boolean hasReflectionMap(Appearance app, String shader) {
        String key = shader == null || shader.equals("") ? "reflectionMap" : shader + ".reflectionMap";
        return AttributeEntityUtility.hasAttributeEntity(CubeMap.class, key, app);
    }
}

