/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.shader;

import de.jreality.scene.Appearance;
import de.jreality.scene.event.AppearanceEvent;
import de.jreality.scene.event.AppearanceListener;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.GlslSource;
import de.jreality.util.Input;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.WeakHashMap;

public class GlslProgram {
    private static final Object EMPTY = new Object();
    private final GlslSource source;
    private final Appearance app;
    private final EffectiveAppearance eApp;
    private final WeakHashMap<String, Object> uniforms = new WeakHashMap();
    private final String pre;

    public static boolean hasGlslProgram(EffectiveAppearance eap, String prefix) {
        Object prog = eap.getAttribute(prefix + "::glsl-source", EMPTY, Object.class);
        return prog != EMPTY;
    }

    public static boolean hasGlslProgram(Appearance eap, String prefix) {
        Object prog = eap.getAttribute(prefix + "::glsl-source");
        return prog instanceof GlslSource;
    }

    public GlslProgram(Appearance app, String prefix, Input vertexProgram, Input fragmentProgram) throws IOException {
        this(app, prefix, new GlslSource(vertexProgram, fragmentProgram));
    }

    public GlslProgram(Appearance app, String prefix, GlslSource s) {
        this.source = s;
        this.app = app;
        this.eApp = EffectiveAppearance.create().create(app);
        this.pre = prefix + "::glsl-";
        app.setAttribute(this.pre + "source", this.source);
        this.addAppListener(app);
    }

    public GlslProgram(Appearance app, String prefix, String vertexProgram, String fragmentProgram) {
        this.source = new GlslSource(vertexProgram, fragmentProgram);
        this.app = app;
        this.eApp = EffectiveAppearance.create().create(app);
        this.pre = prefix + "::glsl-";
        app.setAttribute(this.pre + "source", this.source);
        this.addAppListener(app);
    }

    public GlslProgram(Appearance app, String prefix, String[] vertexProgram, String[] fragmentProgram) {
        this.source = new GlslSource(vertexProgram, fragmentProgram);
        this.app = app;
        this.eApp = EffectiveAppearance.create().create(app);
        this.pre = prefix + "::glsl-";
        app.setAttribute(this.pre + "source", this.source);
        this.addAppListener(app);
    }

    public GlslProgram(EffectiveAppearance eap, String prefix) {
        this.app = null;
        this.eApp = eap;
        this.pre = prefix + "::" + "glsl-";
        if (!GlslProgram.hasGlslProgram(eap, prefix)) {
            throw new IllegalStateException("no program!");
        }
        this.source = (GlslSource)eap.getAttribute(this.pre + "source", EMPTY, Object.class);
    }

    public GlslProgram(Appearance app, String prefix) {
        this.app = app;
        this.eApp = EffectiveAppearance.create().create(app);
        this.pre = prefix + "::" + "glsl-";
        if (!GlslProgram.hasGlslProgram(app, prefix)) {
            throw new IllegalStateException("no program!");
        }
        this.source = (GlslSource)app.getAttribute(this.pre + "source");
        this.addAppListener(app);
    }

    private void addAppListener(Appearance ap) {
        ap.addAppearanceListener(new AppearanceListener(){

            public void appearanceChanged(AppearanceEvent ev) {
                GlslProgram.this.uniforms.clear();
            }
        });
    }

    public GlslProgram(Appearance app, EffectiveAppearance eap, String prefix) {
        this.eApp = eap;
        this.app = app;
        this.pre = prefix + "::" + "glsl-";
        if (!GlslProgram.hasGlslProgram(eap, prefix)) {
            throw new IllegalStateException("no program!");
        }
        this.source = (GlslSource)eap.getAttribute(this.pre + "source", EMPTY, Object.class);
        this.addAppListener(app);
    }

    private void checkWrite() {
        if (this.app == null) {
            throw new IllegalStateException("not writable!");
        }
    }

    private void checkParam(String name, String type, boolean array, boolean matrix) {
        GlslSource.UniformParameter param = this.source.getUniformParameter(name);
        if (param == null) {
            throw new IllegalStateException("no such parameter: " + name);
        }
        if (type != null && !param.getType().equals(type)) {
            throw new IllegalArgumentException("wrong type");
        }
    }

    public void setUniform(String name, boolean value) {
        this.checkWrite();
        this.checkParam(name, "bool", false, false);
        this.assign(name, new int[]{value ? 1 : 0});
    }

    public void setUniform(String name, float value) {
        this.checkWrite();
        this.checkParam(name, "float", false, false);
        this.assign(name, new float[]{value});
    }

    public void setUniform(String name, int value) {
        this.checkWrite();
        this.checkParam(name, null, false, false);
        this.assign(name, new int[]{value});
    }

    public void setUniform(String name, float[] values) {
        this.checkWrite();
        this.checkParam(name, null, true, false);
        this.assign(name, values.clone());
    }

    public void setUniform(String name, int[] values) {
        this.checkWrite();
        this.checkParam(name, null, true, false);
        this.assign(name, values.clone());
    }

    private void assign(String name, Object values) {
        this.app.setAttribute(this.pre + name, values);
    }

    public void setUniform(String name, double value) {
        this.setUniform(name, (float)value);
    }

    public void setUniform(String name, double[] values) {
        float[] floats = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            floats[i] = (float)values[i];
        }
        this.checkWrite();
        this.checkParam(name, null, true, false);
        this.assign(name, floats);
    }

    public void setUniform(String name, FloatBuffer data) {
        float[] floats = new float[data.remaining()];
        data.get(floats);
        this.checkWrite();
        this.checkParam(name, null, true, false);
        this.assign(name, floats);
    }

    public void setUniformMatrix(String name, float[] matrix) {
        this.checkWrite();
        this.checkParam(name, null, true, true);
        this.assign(name, matrix);
    }

    public void setUniformMatrix(String name, double[] matrix) {
        float[] floats = new float[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            floats[i] = (float)matrix[i];
        }
        this.setUniformMatrix(name, floats);
    }

    public Object getUniform(String name) {
        GlslSource.UniformParameter param = this.source.getUniformParameter(name);
        if (param == null) {
            throw new IllegalArgumentException("no such uniform param");
        }
        Object val = this.uniforms.get(name);
        if (val == null) {
            val = this.eApp.getAttribute(this.pre + name, EMPTY, Object.class);
            if (val == EMPTY) {
                return null;
            }
            this.uniforms.put(name, val);
        }
        return val;
    }

    public GlslSource getSource() {
        return this.source;
    }

    public static class UniformValue {
        private final GlslSource.UniformParameter param;
        private final Object value;

        private UniformValue(GlslSource.UniformParameter param, Object value) {
            this.param = param;
            this.value = value;
        }

        public GlslSource.UniformParameter getParameter() {
            return this.param;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

