/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.proxy.tree;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.proxy.tree.ProxyConnector;
import de.jreality.scene.proxy.tree.ProxyTreeFactory;
import de.jreality.scene.proxy.tree.SceneTreeNode;
import java.util.WeakHashMap;

public class SceneProxyTreeBuilder {
    protected SceneGraphComponent root;
    protected SceneTreeNode treeRoot;
    protected WeakHashMap proxyToTreeNodes = new WeakHashMap();
    protected ProxyTreeFactory proxyTreeFactory = new ProxyTreeFactory();
    private ProxyConnector connector = new ProxyConnector();
    Traversal traversal = new Traversal();

    public SceneProxyTreeBuilder(SceneGraphComponent root) {
        this.root = root;
    }

    protected void postCreate(SceneTreeNode proxy) {
    }

    public SceneTreeNode createProxyTree() {
        if (this.proxyTreeFactory == null) {
            throw new IllegalStateException("tree proxy factory not set!");
        }
        if (this.treeRoot != null) {
            throw new IllegalStateException("proxy tree already created");
        }
        this.traversal.visit(this.root);
        return this.treeRoot;
    }

    public Object getProxy(SceneGraphPath path) {
        SceneTreeNode n = this.treeRoot.findNodeForPath(path.iterator());
        return n.getProxy();
    }

    public SceneTreeNode getTreeNodeForProxy(Object proxy) {
        if (proxy == null) {
            throw new IllegalStateException("proxy is null");
        }
        if (!this.proxyToTreeNodes.containsKey(proxy)) {
            throw new IllegalStateException("unknown proxy");
        }
        return (SceneTreeNode)this.proxyToTreeNodes.get(proxy);
    }

    public SceneTreeNode getTreeRoot() {
        return this.treeRoot;
    }

    public ProxyTreeFactory getProxyTreeFactory() {
        return this.proxyTreeFactory;
    }

    public void setProxyTreeFactory(ProxyTreeFactory proxyTreeFactory) {
        this.proxyTreeFactory = proxyTreeFactory;
    }

    public ProxyConnector getConnector() {
        return this.connector;
    }

    public void setProxyConnector(ProxyConnector connector) {
        this.connector = connector;
    }

    protected class Traversal
    extends SceneGraphVisitor {
        SceneTreeNode proxy;
        SceneTreeNode proxyParent;
        SceneGraphPath path;

        protected Traversal() {
        }

        public void visit(SceneGraphComponent c) {
            super.visit(c);
            if (SceneProxyTreeBuilder.this.treeRoot == null) {
                SceneProxyTreeBuilder.this.treeRoot = this.proxy;
            }
            SceneTreeNode oldParent = this.proxyParent;
            this.proxyParent = this.proxy;
            c.childrenAccept(this);
            this.proxy = this.proxyParent;
            this.proxyParent = oldParent;
        }

        public void visit(SceneGraphNode m) {
            this.proxy = SceneProxyTreeBuilder.this.proxyTreeFactory.createProxyTreeNode(m);
            this.proxy.setConnector(SceneProxyTreeBuilder.this.connector);
            if (this.proxyParent != null) {
                this.proxyParent.addChild(this.proxy);
            }
            SceneProxyTreeBuilder.this.proxyToTreeNodes.put(this.proxy.getProxy(), this.proxy);
            SceneProxyTreeBuilder.this.postCreate(this.proxy);
        }

        void setRoot(SceneTreeNode root) {
            this.proxyParent = root;
        }
    }
}

