/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.pick;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.Primitives;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.pick.AABB;
import de.jreality.scene.pick.BruteForcePicking;
import de.jreality.scene.pick.Hit;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AABBTree {
    private static final int DEFAULT_POLYS_PER_LEAF = 5;
    private final int maxPerLeaf;
    private AABBTree left;
    private AABBTree right;
    private AABB bounds;
    private TreePolygon[] tris;
    private int myStart;
    private int myEnd;
    public static AABBTree nullTree = new AABBTree(null, 0, 1, 0);
    private Comparator<TreePolygon> treeCompare = new Comparator<TreePolygon>(){

        @Override
        public int compare(TreePolygon a, TreePolygon b) {
            if (a.projection < b.projection) {
                return -1;
            }
            if (a.projection > b.projection) {
                return 1;
            }
            return 0;
        }
    };

    private AABBTree(TreePolygon[] polygons, int maxPolysPerLeaf, int start, int end) {
        this.maxPerLeaf = maxPolysPerLeaf;
        this.tris = polygons;
        this.createTree(start, end);
    }

    public static AABBTree construct(double[][] coords, int[][] faces) {
        return AABBTree.construct(coords, faces, 5);
    }

    public static AABBTree construct(double[][] coords, int[][] faces, int maxPolysPerLeaf) {
        double[][][] polygons = AABBTree.getMeshAsPolygons(coords, faces);
        return AABBTree.construct(maxPolysPerLeaf, polygons);
    }

    public static AABBTree construct(IndexedFaceSet faceSet) {
        return AABBTree.construct(faceSet, 5);
    }

    public static AABBTree construct(IndexedFaceSet faceSet, int maxPolysPerLeaf) {
        double[][][] polygons = AABBTree.getMeshAsPolygons(faceSet);
        return AABBTree.construct(maxPolysPerLeaf, polygons);
    }

    private static AABBTree construct(int maxPolysPerLeaf, double[][][] polygons) {
        TreePolygon[] tris = new TreePolygon[polygons.length];
        for (int i = 0; i < tris.length; ++i) {
            tris[i] = new TreePolygon(polygons[i], i);
        }
        return AABBTree.construct(maxPolysPerLeaf, tris);
    }

    private static AABBTree construct(int maxPolysPerLeaf, TreePolygon[] tris) {
        AABBTree ret = new AABBTree(tris, maxPolysPerLeaf, 0, tris.length - 1);
        for (int i = 0; i < tris.length; ++i) {
            tris[i].disposeCenter();
        }
        return ret;
    }

    private static double[][][] getMeshAsPolygons(IndexedFaceSet faceSet) {
        int numFaces = faceSet.getNumFaces();
        double[][][] ret = new double[numFaces][][];
        IntArrayArray faces = faceSet.getFaceAttributes(Attribute.INDICES).toIntArrayArray();
        DoubleArrayArray verts = faceSet.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
        for (int i = 0; i < numFaces; ++i) {
            IntArray face = faces.getValueAt(i);
            int faceLength = face.getLength();
            ret[i] = new double[faceLength][];
            for (int j = 0; j < faceLength; ++j) {
                DoubleArray vertex = verts.getValueAt(face.getValueAt(j));
                ret[i][j] = vertex.toDoubleArray(null);
            }
        }
        return ret;
    }

    private static double[][][] getMeshAsPolygons(double[][] coords, int[][] faces) {
        int numFaces = faces.length;
        double[][][] ret = new double[numFaces][][];
        for (int i = 0; i < numFaces; ++i) {
            int[] face = faces[i];
            int faceLength = face.length;
            ret[i] = new double[faceLength][];
            for (int j = 0; j < faceLength; ++j) {
                ret[i][j] = coords[face[j]];
            }
        }
        return ret;
    }

    private void createTree(int start, int end) {
        if (start > end) {
            return;
        }
        this.myStart = start;
        this.myEnd = end;
        this.bounds = new AABB();
        this.bounds.compute(this.tris, start, end);
        if (end - start < this.maxPerLeaf) {
            return;
        }
        this.splitTris(start, end);
        int half = (start + end) / 2;
        this.left = new AABBTree(this.tris, this.maxPerLeaf, start, half);
        if (half < end) {
            this.right = new AABBTree(this.tris, this.maxPerLeaf, half + 1, end);
        }
    }

    void intersect(IndexedFaceSet ifs, int metric, SceneGraphPath path, double[] from, double[] to, List<Hit> hits) {
        Matrix m = new Matrix();
        Matrix mInv = new Matrix();
        path.getMatrix(m.getArray());
        path.getInverseMatrix(mInv.getArray());
        this.intersect(ifs, metric, path, m, mInv, from, to, hits);
    }

    void intersect(IndexedFaceSet ifs, int metric, SceneGraphPath path, Matrix m, Matrix mInv, double[] from, double[] to, List<Hit> hits) {
        double[] dir;
        double[] fromLocal = mInv.multiplyVector(from);
        double[] toLocal = mInv.multiplyVector(to);
        double[] dArray = dir = toLocal.length == 3 || toLocal[3] == 0.0 ? toLocal : Rn.subtract(null, toLocal, fromLocal);
        if (!this.bounds.intersects(fromLocal, dir)) {
            return;
        }
        if (this.left != null) {
            this.left.intersect(ifs, metric, path, m, mInv, from, to, hits);
        }
        if (this.right != null) {
            this.right.intersect(ifs, metric, path, m, mInv, from, to, hits);
        } else if (this.left == null) {
            double[] p1 = new double[4];
            double[] p2 = new double[4];
            double[] p3 = new double[4];
            double[] pobj = new double[4];
            p3[3] = 1.0;
            p2[3] = 1.0;
            p1[3] = 1.0;
            for (int i = this.myStart; i <= this.myEnd; ++i) {
                TreePolygon tempt = this.tris[i];
                for (int j = 0; j < tempt.getNumTriangles(); ++j) {
                    tempt.getTriangle(j, p1, p2, p3);
                    if (!BruteForcePicking.intersects(pobj, fromLocal, toLocal, p1, p2, p3)) continue;
                    double[] pw = m.multiplyVector(pobj);
                    hits.add(new Hit(path.pushNew(ifs), pw, Pn.distanceBetween(from, pw, metric), P3.affineCoordinate(from, to, pw), 1, tempt.getIndex(), j));
                }
            }
        }
    }

    private void splitTris(int start, int end) {
        if (this.bounds.extent[0] > this.bounds.extent[1]) {
            if (this.bounds.extent[0] > this.bounds.extent[2]) {
                this.sort(start, end, 0);
            } else {
                this.sort(start, end, 2);
            }
        } else if (this.bounds.extent[1] > this.bounds.extent[2]) {
            this.sort(start, end, 1);
        } else {
            this.sort(start, end, 2);
        }
    }

    private void sort(int start, int end, int index) {
        double[] tmp = null;
        for (int i = start; i < end; ++i) {
            tmp = Rn.subtract(tmp, this.tris[i].centroid, this.bounds.center);
            this.tris[i].projection = tmp[index];
        }
        Arrays.sort(this.tris, start, end, this.treeCompare);
        Arrays.sort(this.tris, start, end, this.treeCompare);
    }

    public SceneGraphComponent display() {
        SceneGraphComponent cmp = new SceneGraphComponent();
        Appearance app = new Appearance();
        app.setAttribute("showPoints", false);
        app.setAttribute("showLines", true);
        app.setAttribute("showFaces", false);
        cmp.setAppearance(app);
        this.display(cmp, Color.BLUE, Color.RED, true, (this.bounds.extent[0] + this.bounds.extent[1] + this.bounds.extent[2]) * 0.003, 0.99);
        return cmp;
    }

    void display(SceneGraphComponent parent, Color leftColor, Color rightColor, boolean isLeft, double radius, double factor) {
        if (this.left != null) {
            this.left.display(parent, leftColor.brighter(), rightColor.brighter(), true, radius * factor, factor);
        }
        if (this.right != null) {
            this.right.display(parent, leftColor.darker(), rightColor.darker(), false, radius * factor, factor);
        } else if (this.left == null && this.right == null) {
            SceneGraphComponent myComp = new SceneGraphComponent();
            double[] t = this.bounds.center;
            double[] s = this.bounds.extent;
            MatrixBuilder.euclidean().translate(t).getMatrix().assignTo(myComp);
            IndexedFaceSet box = Primitives.box(2.0 * s[0], 2.0 * s[1], 2.0 * s[2], false);
            myComp.setGeometry(box);
            IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(box);
            IndexedFaceSetUtility.calculateAndSetNormals(box);
            Appearance a = new Appearance();
            a.setAttribute("lineShader.diffuseColor", isLeft ? leftColor : rightColor);
            a.setAttribute("lineShader.tubeRadius", radius);
            myComp.setAppearance(a);
            parent.addChild(myComp);
        }
    }

    static class TreePolygon {
        private double[][] verts;
        private double projection;
        private int index;
        double[] centroid;

        TreePolygon(double[][] verts, int index) {
            this.verts = verts;
            if (verts[0].length == 4) {
                this.verts = Pn.dehomogenize(new double[verts.length][3], verts);
            }
            this.index = index;
            int count = verts.length;
            this.centroid = Rn.copy(null, verts[0]);
            for (int i = 1; i < count; ++i) {
                Rn.add(this.centroid, this.centroid, verts[i]);
            }
            Rn.times(this.centroid, 1.0 / (double)count, this.centroid);
        }

        void disposeCenter() {
            this.centroid = null;
        }

        int getNumTriangles() {
            return this.verts.length - 2;
        }

        void getTriangle(int i, double[] p1, double[] p2, double[] p3) {
            System.arraycopy(this.verts[0], 0, p1, 0, 3);
            System.arraycopy(this.verts[i + 1], 0, p2, 0, 3);
            System.arraycopy(this.verts[i + 2], 0, p3, 0, 3);
        }

        double[][] getVertices() {
            return this.verts;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

