/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.DoubleArrayStorage;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.IntArrayStorage;
import de.jreality.scene.data.StringArray;
import de.jreality.scene.data.StringArrayArray;
import de.jreality.scene.data.StringArrayStorage;
import de.jreality.scene.data.WritableDataList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;

public abstract class StorageModel
implements Serializable {
    static Primitive[] PRIMITIVES = new Primitive[8];
    static ObjectType[] OBJECT_TYPES = new ObjectType[1];
    transient StorageModel[] inlined;
    transient StorageModel[] arrayof;
    public static final StorageModel INT_ARRAY = new IntArrayStorage();
    public static final StorageModel DOUBLE_ARRAY = new DoubleArrayStorage();
    public static final StorageModel INT_ARRAY_ARRAY = INT_ARRAY.array();
    public static final StorageModel DOUBLE_ARRAY_ARRAY = DOUBLE_ARRAY.array();
    public static final StorageModel DOUBLE2_INLINED = DOUBLE_ARRAY.inlined(2);
    public static final StorageModel DOUBLE3_INLINED = DOUBLE_ARRAY.inlined(3);
    public static final StorageModel DOUBLE3_ARRAY = DOUBLE_ARRAY.array(3);
    public static final StorageModel STRING_ARRAY = new StringArrayStorage();
    public static final StorageModel STRING_ARRAY_ARRAY = STRING_ARRAY.array();
    private transient String string;

    public static StorageModel primitive(Class cl) {
        int ix;
        if (!cl.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        switch (cl.getName().charAt(0)) {
            case 'b': {
                ix = cl == Boolean.TYPE ? 0 : 1;
                break;
            }
            case 's': {
                ix = 2;
                break;
            }
            case 'i': {
                ix = 3;
                break;
            }
            case 'l': {
                ix = 4;
                break;
            }
            case 'f': {
                ix = 5;
                break;
            }
            case 'd': {
                ix = 6;
                break;
            }
            default: {
                ix = 7;
            }
        }
        Primitive sm = PRIMITIVES[ix];
        return sm != null ? sm : new Primitive(cl);
    }

    public static StorageModel objectType(Class cl) {
        if (cl.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        int ix = -1;
        if (cl == String.class) {
            ix = 0;
        }
        if (ix == -1) {
            throw new IllegalArgumentException("unsupported type: " + cl.getName());
        }
        ObjectType sm = OBJECT_TYPES[ix];
        return sm != null ? sm : new ObjectType(cl);
    }

    public StorageModel inlined(int numPerEntry) {
        if (numPerEntry < 1) {
            throw new IllegalArgumentException();
        }
        if (this.inlined != null && this.inlined.length > numPerEntry && this.inlined[numPerEntry] != null) {
            return this.inlined[numPerEntry];
        }
        return new InlinedArray(this, numPerEntry);
    }

    public StorageModel array(int numPerEntry) {
        if (this.arrayof != null && this.arrayof.length > numPerEntry && this.arrayof[numPerEntry] != null) {
            return this.arrayof[numPerEntry];
        }
        return new ArrayOf(this, numPerEntry);
    }

    public StorageModel array() {
        StorageModel sm = this.arrayof != null ? this.arrayof[0] : null;
        return sm != null ? sm : new ArrayOf(this);
    }

    StorageModel(String str) {
        this.string = str;
    }

    abstract Object create(int var1);

    abstract Object getAsObject(Object var1, int var2);

    Object copy(DataList from, StorageModel toFmt, Object to) {
        Object data = from.data;
        int off = from.offset;
        int len = from.length;
        if (to == null) {
            to = toFmt.create(this.linearSize(toFmt, data, off, len));
        }
        this.copy(data, off, toFmt, to, 0, len);
        return to;
    }

    Object copy(DataList from, StorageModel toFmt, Object to, int len) {
        Object data = from.data;
        int off = from.offset;
        if (to == null) {
            to = toFmt.create(this.linearSize(toFmt, data, off, len));
        }
        this.copy(data, off, toFmt, to, 0, len);
        return to;
    }

    private int linearSize(StorageModel toFmt, Object data, int off, int len) {
        int size = len;
        int[] dim = this.getDimensions();
        int toN = toFmt.getNumberOfDimensions();
        int n = dim.length;
        StorageModel sm = this;
        if (toN < n) {
            boolean inlined;
            int d = 1;
            int nd = n - toN;
            for (int k = 0; k < nd; ++k) {
                size *= dim[d];
                ++d;
            }
            if (size >= 0) {
                return size;
            }
            sm = sm.getComponentModel();
            int toInline = dim[1];
            boolean bl = inlined = toInline > 0 && this instanceof InlinedArray;
            if (inlined) {
                off *= toInline;
                len *= toInline;
            }
            toInline = 0;
            for (int j = off; j < len; ++j) {
                Object o = inlined ? data : this.getAsObject(data, j);
                toInline += sm.linearSize(toFmt, o, 0, sm.getLength(o));
            }
            size = toInline;
        }
        return size;
    }

    void copy(Object from, int srcOff, StorageModel toFmt, Object to, int dstOff, int len) {
        if (toFmt == this) {
            System.arraycopy(from, srcOff, to, dstOff, len);
        } else {
            toFmt.copy(this, from, srcOff, to, dstOff, len);
        }
    }

    void copy(StorageModel fromFmt, Object from, int srcOff, Object to, int dstOff, int len) {
        throw new UnsupportedOperationException(fromFmt + " -> " + this);
    }

    public final DataList createReadOnly(Object v) {
        return this.createReadOnly(v, 0, this.getLength(v));
    }

    public DataList createReadOnly(Object v, int start, int length) {
        return new DataList(this, v, start, length);
    }

    public WritableDataList createWritableDataList(Object v) {
        this.getLength(v);
        return new WritableDataList(this, v);
    }

    void toStringImpl(Object data, int index, StringBuffer target) {
        target.append(this.getAsObject(data, index));
    }

    public String toString() {
        if (this.string == null) {
            int[] dim = this.getDimensions();
            int nd = dim.length;
            StorageModel sm = this;
            for (int i = 0; i < nd; ++i) {
                sm = sm.getComponentModel();
            }
            StringBuffer sb = new StringBuffer(nd * 4 + 8);
            sb.append(sm.string);
            for (int i = 0; i < nd; ++i) {
                sb.append('[');
                if (dim[i] != -1) {
                    sb.append(dim[i]);
                }
                sb.append(']');
            }
            this.string = sb.toString();
        }
        return this.string;
    }

    public abstract int getLength(Object var1);

    public int getNumberOfDimensions() {
        return 0;
    }

    public int[] getDimensions() {
        int[] dim = new int[this.getNumberOfDimensions()];
        dim[0] = -1;
        return this.getDimensions(dim, 1);
    }

    int[] getDimensions(int[] dim, int d) {
        throw new UnsupportedOperationException("dim of primitive");
    }

    public int[] getDimensions(DataList from) {
        if (from.getStorageModel() != this) {
            throw new IllegalArgumentException("list not of that type");
        }
        int[] dim = this.getDimensions();
        dim[0] = this.getLength(from.data);
        return dim;
    }

    public boolean isArray() {
        return false;
    }

    public StorageModel getComponentModel() {
        throw new UnsupportedOperationException("component model of primitive");
    }

    public IntArray getAsIntArray(Object data, int index) {
        try {
            return new IntArray((int[])this.getAsObject(data, index));
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
    }

    public DoubleArray getAsDoubleArray(Object data, int index) {
        try {
            return new DoubleArray((double[])this.getAsObject(data, index));
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
    }

    public StringArray getAsStringArray(Object data, int index) {
        try {
            return new StringArray((String[])this.getAsObject(data, index));
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
    }

    public IntArray toIntArray(Object data) {
        if (data instanceof IntArray) {
            return (IntArray)data;
        }
        try {
            return new IntArray((int[])data);
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
    }

    public IntArrayArray toIntArrayArray(Object data) {
        if (data instanceof IntArrayArray) {
            return (IntArrayArray)data;
        }
        try {
            return new IntArrayArray.Array((int[][])data);
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
    }

    public DoubleArray toDoubleArray(Object data) {
        if (data instanceof DoubleArray) {
            return (DoubleArray)data;
        }
        try {
            return new DoubleArray((double[])data);
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
    }

    public DoubleArrayArray toDoubleArrayArray(Object data) {
        if (data instanceof DoubleArrayArray) {
            return (DoubleArrayArray)data;
        }
        try {
            return new DoubleArrayArray.Array((double[][])data);
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
    }

    public StringArray toStringArray(Object data) {
        if (data instanceof StringArray) {
            return (StringArray)data;
        }
        try {
            return new StringArray((String[])data);
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
    }

    public StringArrayArray toStringArrayArray(Object data) {
        if (data instanceof StringArrayArray) {
            return (StringArrayArray)data;
        }
        try {
            return new StringArrayArray.Array((String[][])data);
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
    }

    public void checkFormat(Object newData) {
    }

    public abstract DataItem item(Object var1, int var2);

    void exportData(ObjectOutputStream stream, DataList list) throws IOException {
        stream.writeObject(list.data);
    }

    Object importData(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        return stream.readObject();
    }

    static class SAI
    extends InlinedArray {
        SAI(int num) {
            super(STRING_ARRAY, num);
        }

        public DataList createReadOnly(Object v, int start, int length) {
            String[] value = (String[])v;
            return new StringArrayArray.Inlined(value, this.numPerEntry, start, length);
        }
    }

    static class SAA
    extends ArrayOf {
        SAA() {
            super(STRING_ARRAY);
        }

        SAA(int num) {
            super(STRING_ARRAY, num);
        }

        public DataList createReadOnly(Object v, int start, int length) {
            String[][] value = (String[][])v;
            if (start != 0 || length != value.length) {
                throw new UnsupportedOperationException("[" + start + ", " + (start + length) + '[');
            }
            return new StringArrayArray.Array(value);
        }
    }

    static class DAI
    extends InlinedArray {
        DAI(int num) {
            super(DOUBLE_ARRAY, num);
        }

        public DataList createReadOnly(Object v, int start, int length) {
            double[] value = (double[])v;
            return new DoubleArrayArray.Inlined(value, this.numPerEntry, start, length);
        }
    }

    static class DAA
    extends ArrayOf {
        DAA() {
            super(DOUBLE_ARRAY);
        }

        DAA(int num) {
            super(DOUBLE_ARRAY, num);
        }

        public DataList createReadOnly(Object v, int start, int length) {
            double[][] value = (double[][])v;
            if (start != 0 || length > value.length) {
                throw new UnsupportedOperationException("[" + start + ", " + (start + length) + '[');
            }
            return this.numPerEntry == -1 ? new DoubleArrayArray.Array(value) : new DoubleArrayArray.Array(value, this.numPerEntry);
        }
    }

    static class IAI
    extends InlinedArray {
        IAI(int num) {
            super(INT_ARRAY, num);
        }

        public DataList createReadOnly(Object v, int start, int length) {
            int[] value = (int[])v;
            return new IntArrayArray.Inlined(value, this.numPerEntry, start, length);
        }
    }

    static class IAA
    extends ArrayOf {
        IAA() {
            super(INT_ARRAY);
        }

        IAA(int num) {
            super(INT_ARRAY, num);
        }

        public DataList createReadOnly(Object v, int start, int length) {
            int[][] value = (int[][])v;
            if (start != 0 || length != value.length) {
                throw new UnsupportedOperationException("[" + start + ", " + (start + length) + '[');
            }
            return new IntArrayArray.Array(value);
        }
    }

    static class ArrayOf
    extends StorageModel {
        final StorageModel component;
        final int numPerEntry;

        ArrayOf(StorageModel compModel, int num) {
            super(null);
            if (compModel == null) {
                throw new NullPointerException();
            }
            this.component = compModel;
            this.numPerEntry = num;
            if (compModel.arrayof != null) {
                if (compModel.arrayof.length < num) {
                    compModel.arrayof = new StorageModel[num + 32];
                    System.arraycopy(compModel.arrayof, 0, compModel.arrayof, 0, compModel.arrayof.length);
                } else if (compModel.arrayof[num] != null) {
                    throw new IllegalStateException("redefinition of" + this);
                }
            } else {
                compModel.arrayof = new StorageModel[num + 32];
            }
            compModel.arrayof[num] = this;
        }

        ArrayOf(StorageModel compModel) {
            super(null);
            if (compModel == null) {
                throw new NullPointerException();
            }
            this.component = compModel;
            this.numPerEntry = -1;
            if (compModel.arrayof != null) {
                if (compModel.arrayof[0] != null) {
                    throw new IllegalStateException("redefinition of" + this);
                }
            } else {
                compModel.arrayof = new StorageModel[32];
            }
            compModel.arrayof[0] = this;
        }

        public Object create(int size) {
            Object data = Array.newInstance(this.component.create(1).getClass(), size);
            if (this.numPerEntry > 0 && !(this.component instanceof Primitive)) {
                Object[] array = (Object[])data;
                for (int i = 0; i < size; ++i) {
                    array[i] = this.component.create(this.numPerEntry);
                }
            }
            return data;
        }

        Object getAsObject(Object data, int index) {
            return ((Object[])data)[index];
        }

        public int getLength(Object data) {
            return ((Object[])data).length;
        }

        public boolean isArray() {
            return true;
        }

        public StorageModel getComponentModel() {
            return this.component;
        }

        void copy(Object from, int srcOff, StorageModel toFmt, Object to, int dstOff, int len) {
            Object[] source = (Object[])from;
            if (toFmt.getNumberOfDimensions() < this.getNumberOfDimensions()) {
                if (this.numPerEntry != -1) {
                    dstOff *= this.numPerEntry;
                } else {
                    int toOff = 0;
                    for (int i = 0; i < dstOff; ++i) {
                        toOff += this.component.getLength(source[i]);
                    }
                    dstOff = toOff;
                }
                int j = dstOff;
                for (int i = srcOff; i < len; ++i) {
                    int dl = this.numPerEntry != -1 ? this.numPerEntry : this.component.getLength(source[i]);
                    this.component.copy(source[i], 0, toFmt, to, j, dl);
                    j += dl;
                }
            } else if (toFmt instanceof ArrayOf) {
                toFmt = ((ArrayOf)toFmt).component;
                Object[] target = (Object[])to;
                int src = srcOff;
                for (int dst = 0; dst < len; ++dst) {
                    int n = this.numPerEntry != -1 ? this.numPerEntry : this.component.getLength(source[src]);
                    Object t = target[dst + dstOff];
                    if (t == null) {
                        Object object = toFmt.create(n);
                        target[dst + dstOff] = object;
                        t = object;
                    }
                    this.component.copy(source[src], 0, toFmt, t, 0, n);
                    ++src;
                }
            } else {
                if (toFmt.getNumberOfDimensions() >= this.getNumberOfDimensions()) {
                    toFmt = ((InlinedArray)toFmt).component;
                }
                if (this.numPerEntry > 0) {
                    int src = 0;
                    int dst = dstOff * this.numPerEntry;
                    while (src < len) {
                        this.component.copy(source[src + srcOff], 0, toFmt, to, dst, this.numPerEntry);
                        ++src;
                        dst += this.numPerEntry;
                    }
                } else {
                    int dst = 0;
                    for (int i = 0; i < dstOff; ++i) {
                        dst += this.component.getLength(source[i]);
                    }
                    int src = srcOff;
                    for (int i = 0; i < len; ++i) {
                        int n = this.component.getLength(source[src]);
                        this.component.copy(source[src], 0, toFmt, to, dst, n);
                        dst += n;
                        ++src;
                    }
                }
            }
        }

        public int getNumberOfDimensions() {
            return this.component.getNumberOfDimensions() + 1;
        }

        int[] getDimensions(int[] dim, int d) {
            this.component.getDimensions((int[])dim, (int)(d + 1))[d] = this.numPerEntry;
            return dim;
        }

        void toStringImpl(Object data, int index, StringBuffer target) {
            target.append("{ ");
            data = this.getAsObject(data, index);
            if (data != null) {
                int num;
                int n = num = this.numPerEntry == -1 ? this.component.getLength(data) : this.numPerEntry;
                if (num > 0) {
                    this.component.toStringImpl(data, 0, target);
                }
                for (int ix = 1; ix < num; ++ix) {
                    target.append(", ");
                    this.component.toStringImpl(data, ix, target);
                }
            }
            target.append(" }");
        }

        public DataItem item(Object v, int index) {
            Object[] array = (Object[])v;
            return this.component.createReadOnly(array[index]);
        }

        Object readResolve() throws ObjectStreamException {
            return this.numPerEntry > 0 ? this.component.array(this.numPerEntry) : this.component.array();
        }
    }

    static class InlinedArray
    extends StorageModel {
        final StorageModel component;
        final int numPerEntry;

        InlinedArray(StorageModel compModel, int num) {
            super(null);
            if (compModel == null) {
                throw new NullPointerException();
            }
            this.component = compModel;
            this.numPerEntry = num;
            if (compModel.inlined != null) {
                if (compModel.inlined.length < num) {
                    int l = compModel.inlined.length;
                    compModel.inlined = new StorageModel[num + 32];
                    System.arraycopy(compModel.inlined, 0, compModel.inlined, 0, l);
                } else if (compModel.inlined[num] != null) {
                    throw new IllegalStateException("redefinition of" + this);
                }
            } else {
                compModel.inlined = new StorageModel[num + 32];
            }
            compModel.inlined[num] = this;
        }

        public Object create(int size) {
            return this.component.create(size * this.numPerEntry);
        }

        public int getNumberOfDimensions() {
            return this.component.getNumberOfDimensions() + 1;
        }

        int[] getDimensions(int[] dim, int d) {
            this.component.getDimensions((int[])dim, (int)(d + 1))[d] = this.numPerEntry;
            return dim;
        }

        void copy(Object from, int srcOff, StorageModel toFmt, Object to, int dstOff, int len) {
            if (toFmt.getNumberOfDimensions() < this.getNumberOfDimensions()) {
                this.component.copy(from, srcOff * this.numPerEntry, toFmt, to, dstOff * this.numPerEntry, len * this.numPerEntry);
            } else if (toFmt instanceof ArrayOf) {
                toFmt = ((ArrayOf)toFmt).component;
                Object[] target = (Object[])to;
                int src = srcOff * this.numPerEntry;
                for (int dst = 0; dst < len; ++dst) {
                    Object t = target[dst + dstOff];
                    if (t == null) {
                        Object object = toFmt.create(this.numPerEntry);
                        target[dst + dstOff] = object;
                        t = object;
                    }
                    this.component.copy(from, src, toFmt, t, 0, this.numPerEntry);
                    src += this.numPerEntry;
                }
            } else {
                if (toFmt.getNumberOfDimensions() >= this.getNumberOfDimensions()) {
                    toFmt = ((InlinedArray)toFmt).component;
                }
                this.component.copy(from, srcOff * this.numPerEntry, toFmt, to, dstOff * this.numPerEntry, len * this.numPerEntry);
            }
        }

        Object getAsObject(Object data, int index) {
            Object obj = this.component.create(this.numPerEntry);
            System.arraycopy(data, index * this.numPerEntry, obj, 0, this.numPerEntry);
            return obj;
        }

        public boolean isArray() {
            return true;
        }

        public StorageModel getComponentModel() {
            return this.component;
        }

        public int getLength(Object data) {
            return this.component.getLength(data) / this.numPerEntry;
        }

        public DataList createReadOnly(Object v, int start, int length) {
            if (this.component == INT_ARRAY) {
                int[] value = (int[])v;
                return new IntArrayArray.Inlined(value, this.numPerEntry, start, length);
            }
            return new DataList(this, v, start, length);
        }

        public DataItem item(Object v, int index) {
            return this.component.createReadOnly(v, index * this.numPerEntry, this.numPerEntry);
        }

        void toStringImpl(Object data, int index, StringBuffer target) {
            target.append("{ ");
            this.component.toStringImpl(data, index *= this.numPerEntry, target);
            for (int ix = 1; ix < this.numPerEntry; ++ix) {
                target.append(", ");
                this.component.toStringImpl(data, index + ix, target);
            }
            target.append(" }");
        }

        Object readResolve() throws ObjectStreamException {
            return this.component.inlined(this.numPerEntry);
        }

        void exportData(ObjectOutputStream out, DataList dataList) throws IOException {
            this.component.exportData(out, dataList);
        }

        Object importData(ObjectInputStream in) throws IOException, ClassNotFoundException {
            return this.component.importData(in);
        }
    }

    static final class ObjectType
    extends StorageModel {
        static final ObjectType STRING = new ObjectType(String.class);
        final Class objectType;

        public ObjectType(Class type) {
            super(type.getName());
            this.objectType = type;
        }

        Object create(int size) {
            throw new UnsupportedOperationException();
        }

        Object getAsObject(Object data, int index) {
            if (data != null && data.getClass().isArray()) {
                return Array.get(data, 0);
            }
            return data;
        }

        public int getLength(Object data) {
            return 1;
        }

        public DataItem item(Object data, int i) {
            return null;
        }

        private Object readResolve() throws ObjectStreamException {
            return ObjectType.objectType(this.objectType);
        }
    }

    static final class Primitive
    extends StorageModel {
        static final Primitive DOUBLE = new Primitive(Double.TYPE);
        static final Primitive INT = new Primitive(Integer.TYPE);
        final Class primitiveType;

        public Primitive(Class type) {
            super(type.getName());
            this.primitiveType = type;
        }

        Object create(int size) {
            throw new UnsupportedOperationException();
        }

        Object getAsObject(Object data, int index) {
            if (data != null && data.getClass().isArray()) {
                return Array.get(data, 0);
            }
            return data;
        }

        public int getLength(Object data) {
            return 1;
        }

        public DataItem item(Object data, int i) {
            return null;
        }

        private Object readResolve() throws ObjectStreamException {
            return Primitive.primitive(this.primitiveType);
        }
    }
}

