/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataItem;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.StorageModel;

public abstract class DoubleArrayArray
extends DataList {
    public abstract double getValueAt(int var1, int var2);

    public abstract int getLength();

    public abstract int getLengthAt(int var1);

    public abstract DoubleArray getValueAt(int var1);

    DoubleArrayArray(StorageModel sm, Object data) {
        super(sm, data);
    }

    DoubleArrayArray(StorageModel sm, Object data, int first, int num) {
        super(sm, data, first, num);
    }

    public final DoubleArrayArray toDoubleArrayArray() {
        return this;
    }

    public double[][] toDoubleArrayArray(double[][] target) {
        if (target == null) {
            target = new double[this.getLength()][];
        }
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            double[] slot = target[i];
            int slotlen = this.getLengthAt(i);
            if (slot == null) {
                target[i] = new double[slotlen];
                slot = target[i];
            }
            for (int j = 0; j < slotlen; ++j) {
                slot[j] = this.getValueAt(i, j);
            }
        }
        return target;
    }

    public static final class Inlined
    extends DoubleArrayArray {
        private transient DoubleArray daView;
        private final transient double[] data;
        private final transient int offset;
        private final transient int length;
        private final transient int entryLength;
        private final transient DoubleArray[] arrays;

        public Inlined(double[] initialData, int numPerEntry) {
            this(initialData, numPerEntry, 0, initialData.length / numPerEntry);
        }

        public Inlined(double[] initialData, int numPerEntry, int firstEntry, int numEntries) {
            super(StorageModel.DOUBLE_ARRAY.inlined(numPerEntry), initialData, firstEntry, numEntries);
            this.data = initialData;
            if (numPerEntry < 1) {
                throw new IllegalArgumentException("numPerEntry=" + numPerEntry);
            }
            this.entryLength = numPerEntry;
            this.offset = firstEntry;
            this.length = numEntries;
            this.arrays = new DoubleArray[this.length];
        }

        public DoubleArray toDoubleArray() {
            return this.daView != null ? this.daView : (this.daView = new DoubleArray(this.data, this.offset * this.entryLength, this.length * this.entryLength));
        }

        public final int getLength() {
            return this.length;
        }

        public int getLengthAt(int n) {
            return this.entryLength;
        }

        public double getValueAt(int n, int i) {
            return this.data[(n + this.offset) * this.entryLength + i];
        }

        public DoubleArray getValueAt(int n) {
            return this.subArray(n);
        }

        public DataItem item(int index) {
            return this.subArray(index);
        }

        private DoubleArray subArray(int ix) {
            DoubleArray sarr = this.arrays[ix];
            return sarr == null ? new DoubleArray(this.data, (ix + this.offset) * this.entryLength, this.entryLength) : sarr;
        }
    }

    public static final class Array
    extends DoubleArrayArray {
        private final transient double[][] data;
        private final transient DoubleArray[] arrays;

        public Array(double[][] data) {
            super(StorageModel.DOUBLE_ARRAY_ARRAY, data);
            this.data = data;
            this.arrays = new DoubleArray[data.length];
        }

        public Array(double[][] data, int numPerEntry) {
            super(StorageModel.DOUBLE_ARRAY.array(numPerEntry), data);
            this.data = data;
            this.arrays = new DoubleArray[data.length];
        }

        public double getValueAt(int n, int i) {
            return this.data[n][i];
        }

        public int getLength() {
            return this.data.length;
        }

        public int getLengthAt(int n) {
            return this.data[n].length;
        }

        public DoubleArray getValueAt(int n) {
            return this.subArray(n);
        }

        public DataItem item(int index) {
            return this.subArray(index);
        }

        private DoubleArray subArray(int index) {
            DoubleArray sarr = this.arrays[index];
            if (sarr != null && sarr.data == this.data[index]) {
                return sarr;
            }
            this.arrays[index] = new DoubleArray(this.data[index]);
            return this.arrays[index];
        }
    }
}

