/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene.data;

import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;

public class DoubleArray
extends DataList {
    final transient double[] data;
    final transient int offset;
    final transient int length;

    public DoubleArray(double[] data) {
        this(data, 0, data.length);
    }

    public DoubleArray(double[] data, int offset, int length) {
        super(StorageModel.DOUBLE_ARRAY, data, offset, length);
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public DoubleArray toDoubleArray() {
        return this;
    }

    public final double[] toDoubleArray(double[] target) {
        if (target == null) {
            target = new double[this.length];
        }
        int src = this.offset;
        int n = this.length;
        for (int dst = 0; dst < n; ++dst) {
            target[dst] = this.data[src];
            ++src;
        }
        return target;
    }

    public final double getValueAt(int n) {
        if (n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[n + this.offset];
    }

    public final int getLength() {
        return this.length;
    }
}

