/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.math.FactoredMatrix;
import de.jreality.scene.Transformation;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;

public class TransformationCustomizer
extends JPanel
implements Customizer,
TransformationListener {
    private Transformation transformation;
    private FactoredMatrix matrix;
    private static final int X = 0;
    private static final int Z = 2;
    private static final int ANGLE = 3;
    private static final int TRANSLATION = 0;
    private static final int ROTATION = 1;
    private static final int SCALE = 2;
    private double[] translation;
    private double[] rotation;
    private double[] scale;
    private double angle;
    private Entry[] tEntries = new Entry[3];
    private Entry[] rEntries = new Entry[4];
    private Entry[] sEntries = new Entry[3];
    private String[] labels = new String[]{"X", "Y", "Z", "angle"};
    private JTextField name;
    private JButton chain;
    private boolean chained;

    public TransformationCustomizer() {
        this((Transformation)null);
    }

    public TransformationCustomizer(Transformation t) {
        int i;
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints labelConstraint = new GridBagConstraints();
        labelConstraint.weightx = 1.0;
        labelConstraint.anchor = 13;
        labelConstraint.ipadx = 5;
        GridBagConstraints editorConstraint = new GridBagConstraints();
        editorConstraint.weightx = 1.0;
        editorConstraint.anchor = 17;
        JLabel label = new JLabel("Name", 2);
        gbl.setConstraints(label, labelConstraint);
        this.add(label);
        this.name = new JTextField(17);
        this.name.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransformationCustomizer.this.transformation.setName(TransformationCustomizer.this.name.getText());
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.ipadx = 10;
        c.anchor = 17;
        Box box = Box.createHorizontalBox();
        box.add(this.name);
        gbl.setConstraints(box, c);
        this.add(box);
        label = new JLabel("Translation", 2);
        gbl.setConstraints(label, labelConstraint);
        this.add(label);
        for (i = 0; i <= 2; ++i) {
            this.tEntries[i] = new Entry(this.labels[i], 0.0, 0);
            if (i == 2) {
                editorConstraint.gridwidth = 0;
            }
            gbl.setConstraints(this.tEntries[i], editorConstraint);
            this.add(this.tEntries[i]);
        }
        label = new JLabel("Rotation", 2);
        gbl.setConstraints(label, labelConstraint);
        editorConstraint.gridwidth = 1;
        this.add(label);
        for (i = 0; i <= 2; ++i) {
            this.rEntries[i] = new Entry(this.labels[i], 0.0, 1);
            gbl.setConstraints(this.rEntries[i], editorConstraint);
            this.add(this.rEntries[i]);
        }
        editorConstraint.gridwidth = 0;
        this.rEntries[3] = new Entry(this.labels[3], this.angle, 1);
        gbl.setConstraints(this.rEntries[3], editorConstraint);
        this.add(this.rEntries[3]);
        label = new JLabel("Scale", 2);
        gbl.setConstraints(label, labelConstraint);
        editorConstraint.gridwidth = 1;
        this.add(label);
        for (i = 0; i <= 2; ++i) {
            this.sEntries[i] = new Entry(this.labels[i], 0.0, 2);
            gbl.setConstraints(this.sEntries[i], editorConstraint);
            this.add(this.sEntries[i]);
        }
        this.chain = new JButton();
        this.chain.setToolTipText("Toggle scalar scale");
        this.chained = false;
        final ImageIcon openChain = new ImageIcon(TransformationCustomizer.class.getResource("openChain.gif"));
        final ImageIcon closedChain = new ImageIcon(TransformationCustomizer.class.getResource("closedChain.gif"));
        this.chain.setIcon(this.chained ? closedChain : openChain);
        this.chain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransformationCustomizer.this.chained = !TransformationCustomizer.this.chained;
                TransformationCustomizer.this.chain.setIcon(TransformationCustomizer.this.chained ? closedChain : openChain);
            }
        });
        editorConstraint.gridwidth = 0;
        editorConstraint.anchor = 10;
        gbl.setConstraints(this.chain, editorConstraint);
        this.add(this.chain);
        if (t != null) {
            this.setObject(t);
        }
    }

    public void setObject(Object t) {
        if (this.transformation != null) {
            this.transformation.removeTransformationListener(this);
        }
        this.transformation = (Transformation)t;
        this.transformation.addTransformationListener(this);
        this.update();
    }

    private void update() {
        this.name.setText(this.transformation.getName());
        this.matrix = new FactoredMatrix(this.transformation.getMatrix());
        this.translation = this.matrix.getTranslation();
        this.rotation = this.matrix.getRotationAxis();
        this.angle = this.matrix.getRotationAngle();
        this.scale = this.matrix.getStretch();
        for (int i = 0; i <= 2; ++i) {
            this.tEntries[i].setValue(this.translation[i]);
            this.rEntries[i].setValue(this.rotation[i]);
            this.sEntries[i].setValue(this.scale[i]);
        }
        this.rEntries[3].setValue(this.angle);
    }

    private void updateTransformation(int type) {
        switch (type) {
            case 0: {
                for (int i = 0; i <= 2; ++i) {
                    this.translation[i] = this.tEntries[i].getValue();
                }
                this.matrix.setTranslation(this.translation);
                break;
            }
            case 1: {
                for (int i = 0; i <= 2; ++i) {
                    this.rotation[i] = this.rEntries[i].getValue();
                }
                this.angle = this.rEntries[3].getValue();
                this.matrix.setRotation(this.angle, this.rotation);
                break;
            }
            case 2: {
                for (int i = 0; i <= 2; ++i) {
                    this.scale[i] = this.sEntries[i].getValue();
                }
                this.matrix.setStretch(this.scale);
            }
        }
        this.transformation.setMatrix(this.matrix.getArray());
    }

    public void transformationMatrixChanged(TransformationEvent ev) {
        this.update();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TransformationCustomizer");
        frame.getContentPane().add(new TransformationCustomizer(new Transformation("transformation")));
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class Entry
    extends JPanel
    implements ActionListener {
        private JLabel label;
        private JFormattedTextField textField;
        private NumberFormatter formatter = null;
        private NumberFormat numberFormat = null;
        private double value;
        private int type;

        public Entry(String label, double d, int type) {
            this.value = d;
            this.type = type;
            this.label = new JLabel(label + ":", 2);
            this.label.setFont(new Font("Helvetica", 0, 12));
            this.numberFormat = NumberFormat.getNumberInstance();
            this.formatter = new NumberFormatter(this.numberFormat);
            this.formatter.setValueClass(Double.class);
            this.textField = new JFormattedTextField(this.formatter);
            this.textField.setFont(new Font("Courier", 0, 12));
            this.textField.setValue(new Double(d));
            this.textField.setColumns(6);
            this.textField.addActionListener(this);
            Box box = Box.createHorizontalBox();
            box.add(this.label);
            box.add(Box.createHorizontalStrut(2));
            box.add(this.textField);
            this.add(box);
        }

        public void actionPerformed(ActionEvent ev) {
            this.updateValues();
            TransformationCustomizer.this.updateTransformation(this.type);
        }

        private void updateValues() {
            switch (this.type) {
                case 2: {
                    if (TransformationCustomizer.this.chained) {
                        this.updateValue();
                        for (int i = 0; i <= 2; ++i) {
                            TransformationCustomizer.this.sEntries[i].setValue(this.getValue());
                        }
                    } else {
                        for (int i = 0; i <= 2; ++i) {
                            TransformationCustomizer.this.sEntries[i].updateValue();
                        }
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i <= 2; ++i) {
                        TransformationCustomizer.this.rEntries[i].updateValue();
                    }
                    TransformationCustomizer.this.rEntries[3].updateValue();
                    break;
                }
                case 0: {
                    for (int i = 0; i <= 2; ++i) {
                        TransformationCustomizer.this.tEntries[i].updateValue();
                    }
                    break;
                }
            }
        }

        public void updateValue() {
            if (!this.textField.isEditValid()) {
                Toolkit.getDefaultToolkit().beep();
                this.textField.selectAll();
            } else {
                try {
                    this.textField.commitEdit();
                    Double dd = (Double)this.textField.getValue();
                    this.value = dd;
                }
                catch (ParseException exc) {
                    exc.printStackTrace();
                }
            }
        }

        public void setValue(double d) {
            this.textField.setValue(new Double(d));
            this.value = d;
        }

        public double getValue() {
            return this.value;
        }
    }
}

