/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

final class OldLock {
    private final Object mutex = new Object();
    private Thread writer;
    private Thread lastWriter;
    private int writeNestCount;
    private int lastWriterReadNestCount;
    private int readNestCount;

    OldLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLock() {
        if (Thread.currentThread() == this.writer) {
            ++this.readNestCount;
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            while (this.writeNestCount != 0) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (Thread.currentThread() == this.lastWriter) {
                ++this.lastWriterReadNestCount;
            }
            ++this.readNestCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLock() {
        Thread thread = Thread.currentThread();
        if (thread == this.writer) {
            ++this.writeNestCount;
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            while (this.writeNestCount != 0 || this.readNestCount != 0) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.writer = thread;
            ++this.writeNestCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void readUnlock() {
        block11: {
            if (this.writer != null && Thread.currentThread() != this.writer) {
                throw new IllegalMonitorStateException("not owner");
            }
            Object object = this.mutex;
            // MONITORENTER : object
            int cur = this.readNestCount;
            try {
                switch (this.readNestCount) {
                    case 0: {
                        throw new IllegalMonitorStateException("too many unlocks");
                    }
                    case 1: {
                        this.readNestCount = 0;
                        this.lastWriterReadNestCount = 0;
                        this.lastWriter = null;
                        this.mutex.notifyAll();
                        return;
                    }
                }
                --this.readNestCount;
                if (Thread.currentThread() == this.lastWriter) {
                    --this.lastWriterReadNestCount;
                }
                if (this.readNestCount != 1) return;
                if (this.lastWriterReadNestCount != 1) return;
                this.mutex.notifyAll();
                return;
            }
            finally {
                if ($assertionsDisabled || cur - 1 == this.readNestCount) break block11;
                throw new AssertionError();
            }
        }
        // MONITOREXIT : object
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUnlock() {
        if (Thread.currentThread() != this.writer) {
            throw new IllegalMonitorStateException("not the writeLock owner");
        }
        switch (this.writeNestCount) {
            case 0: {
                throw new IllegalMonitorStateException("too many unlocks");
            }
            case 1: {
                Object object = this.mutex;
                synchronized (object) {
                    this.writeNestCount = 0;
                    this.writer = null;
                    this.mutex.notifyAll();
                    return;
                }
            }
        }
        --this.writeNestCount;
    }

    boolean canSwitch() {
        assert (Thread.currentThread() == this.writer);
        assert (this.lastWriterReadNestCount == 0);
        return this.writeNestCount == 1 && this.readNestCount == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchToReadLock() {
        if (!this.canSwitch()) {
            throw new IllegalStateException("cannot switch - not owner or nested writes");
        }
        Object object = this.mutex;
        synchronized (object) {
            this.lastWriter = this.writer;
            --this.writeNestCount;
            this.writer = null;
            this.readLock();
            assert (this.writeNestCount == 0);
            assert (this.readNestCount == 1);
            assert (this.lastWriterReadNestCount == 1);
            this.mutex.notifyAll();
        }
    }
}

