/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.WritableDataList;
import de.jreality.scene.event.GeometryEvent;
import de.jreality.scene.event.GeometryEventMulticaster;
import de.jreality.scene.event.GeometryListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Geometry
extends SceneGraphNode {
    private static final Map<String, Object> EMPTY_GEOMETRY_ATTRIBUTE_MAP = Collections.emptyMap();
    public static final String CATEGORY_VERTEX = "VERTEX";
    public static final String CATEGORY_EDGE = "EDGE";
    public static final String CATEGORY_FACE = "FACE";
    protected Map<String, Object> geometryAttributes = Collections.emptyMap();
    private transient GeometryListener geometryListener;
    protected transient Set<String> changedGeometryAttributes = new HashSet<String>();
    protected transient Set<Attribute> changedVertexAttributes = new HashSet<Attribute>();
    protected transient Set<Attribute> changedEdgeAttributes = new HashSet<Attribute>();
    protected transient Set<Attribute> changedFaceAttributes = new HashSet<Attribute>();
    protected transient Map<String, DataListSet> geometryAttributeCategory = new HashMap<String, DataListSet>();

    public Geometry(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getGeometryAttributes() {
        this.startReader();
        try {
            Map<String, Object> map = this.geometryAttributes.isEmpty() ? this.geometryAttributes : Collections.unmodifiableMap(this.geometryAttributes);
            return map;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getGeometryAttributes(String name) {
        this.startReader();
        try {
            Object object = this.geometryAttributes.get(name);
            return object;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeometryAttributes(Map<String, Object> attrSet) {
        this.checkReadOnly();
        if (attrSet.isEmpty()) {
            return;
        }
        this.startWriter();
        try {
            if (this.geometryAttributes == EMPTY_GEOMETRY_ATTRIBUTE_MAP) {
                this.geometryAttributes = new HashMap<String, Object>(attrSet.size());
            }
            for (Map.Entry<String, Object> e : attrSet.entrySet()) {
                if (e.getValue() != null) {
                    this.geometryAttributes.put(e.getKey(), e.getValue());
                    continue;
                }
                this.geometryAttributes.remove(e.getKey());
            }
        }
        finally {
            this.finishWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGeometryAttributes(String attr, Object value) {
        this.checkReadOnly();
        this.startWriter();
        try {
            if (this.geometryAttributes == Collections.EMPTY_MAP) {
                this.geometryAttributes = new HashMap<String, Object>();
            }
            if (value != null) {
                this.geometryAttributes.put(attr, value);
            } else {
                this.geometryAttributes.remove(attr);
            }
            this.fireGeometryAttributesChanged(Collections.singleton(attr));
        }
        finally {
            this.finishWriter();
        }
    }

    final void setAttrImpl(DataListSet target, DataListSet data, boolean replace) {
        if (replace) {
            target.reset(data.getListLength());
        }
        for (Attribute a : data.storedAttributes()) {
            this.setAttrImpl(target, a, data.getList(a), false);
        }
    }

    final void setAttrImpl(DataListSet target, Attribute a, DataList d, boolean replace) {
        if (d == null) {
            if (replace) {
                throw new IllegalArgumentException("datalist==null for setting list length");
            }
            target.remove(a);
        } else {
            WritableDataList w;
            if (replace) {
                target.reset(d.size());
                w = null;
            } else {
                w = target.getWritableList(a);
            }
            if (w == null || a == Attribute.INDICES) {
                w = target.addWritable(a, d.getStorageModel());
            }
            d.copyTo(w);
        }
    }

    public void addGeometryListener(GeometryListener listener) {
        this.startReader();
        this.geometryListener = GeometryEventMulticaster.add(this.geometryListener, listener);
        this.finishReader();
    }

    public void removeGeometryListener(GeometryListener listener) {
        this.startReader();
        this.geometryListener = GeometryEventMulticaster.remove(this.geometryListener, listener);
        this.finishReader();
    }

    protected void fireGeometryDataChanged(String category, Set<Attribute> attributeKeys) {
        if (attributeKeys == null) {
            return;
        }
        if (category == CATEGORY_VERTEX) {
            this.changedVertexAttributes.addAll(attributeKeys);
        }
        if (category == CATEGORY_EDGE) {
            this.changedEdgeAttributes.addAll(attributeKeys);
        }
        if (category == CATEGORY_FACE) {
            this.changedFaceAttributes.addAll(attributeKeys);
        }
    }

    protected void fireGeometryAttributesChanged(Set<String> attributeKeys) {
        if (attributeKeys != null) {
            this.changedGeometryAttributes.addAll(attributeKeys);
        }
    }

    protected void fireGeometryChanged(Set<Attribute> vertexAttributeKeys, Set<Attribute> edgeAttributeKeys, Set<Attribute> faceAttributeKeys, Set<String> geomAttributeKeys) {
        if (vertexAttributeKeys != null) {
            this.changedVertexAttributes.addAll(vertexAttributeKeys);
        }
        if (edgeAttributeKeys != null) {
            this.changedEdgeAttributes.addAll(edgeAttributeKeys);
        }
        if (faceAttributeKeys != null) {
            this.changedFaceAttributes.addAll(faceAttributeKeys);
        }
        if (geomAttributeKeys != null) {
            this.changedGeometryAttributes.addAll(geomAttributeKeys);
        }
    }

    @Override
    protected void writingFinished() {
        this.fireGeometryChangedImpl(this.changedVertexAttributes, this.changedEdgeAttributes, this.changedFaceAttributes, this.changedGeometryAttributes);
        this.changedVertexAttributes.clear();
        this.changedEdgeAttributes.clear();
        this.changedFaceAttributes.clear();
        this.changedGeometryAttributes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumEntries(DataListSet geometryAttributes) {
        this.startReader();
        try {
            int n = geometryAttributes.getListLength();
            return n;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNumEntries(DataListSet geometryAttributes, int numEntries) {
        this.checkReadOnly();
        this.startWriter();
        try {
            geometryAttributes.reset(numEntries);
        }
        finally {
            this.finishWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataListSet getAttributes(DataListSet geometryAttributes) {
        this.startReader();
        try {
            DataListSet dataListSet = geometryAttributes.readOnly();
            return dataListSet;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataList getAttributes(DataListSet geometryAttributes, Attribute attr) {
        this.startReader();
        try {
            DataList dataList = geometryAttributes.getList(attr);
            return dataList;
        }
        finally {
            this.finishReader();
        }
    }

    protected void setAttributes(String category, DataListSet geometryAttributes, DataListSet dls) {
        this.checkReadOnly();
        this.startWriter();
        this.setAttrImpl(geometryAttributes, dls, false);
        this.fireGeometryDataChanged(category, dls.storedAttributes());
        this.finishWriter();
    }

    protected void setAttributes(String category, DataListSet geometryAttributes, Attribute attr, DataList dl) {
        this.checkReadOnly();
        this.startWriter();
        this.setAttrImpl(geometryAttributes, attr, dl, false);
        this.fireGeometryDataChanged(category, Collections.singleton(attr));
        this.finishWriter();
    }

    protected void setCountAndAttributes(String category, DataListSet geometryAttributes, Attribute attr, DataList dl) {
        this.checkReadOnly();
        this.startWriter();
        this.setAttrImpl(geometryAttributes, attr, dl, true);
        this.fireGeometryDataChanged(category, Collections.singleton(attr));
        this.finishWriter();
    }

    protected void setCountAndAttributes(String category, DataListSet geometryAttributes, DataListSet dls) {
        this.checkReadOnly();
        this.startWriter();
        this.setAttrImpl(geometryAttributes, dls, true);
        this.fireGeometryDataChanged(category, dls.storedAttributes());
        this.finishWriter();
    }

    public Set<String> getGeometryAttributeCathegories() {
        return this.geometryAttributeCategory.keySet();
    }

    public int getNumEntries(String attributeCategory) {
        return this.getNumEntries(this.geometryAttributeCategory.get(attributeCategory));
    }

    public void setNumEntries(String attributeCategory, int numEntries) {
        this.setNumEntries(this.geometryAttributeCategory.get(attributeCategory), numEntries);
    }

    public DataListSet getAttributes(String attributeCategory) {
        return this.getAttributes(this.geometryAttributeCategory.get(attributeCategory));
    }

    public DataList getAttributes(String attributeCategory, Attribute attr) {
        return this.getAttributes(this.geometryAttributeCategory.get(attributeCategory), attr);
    }

    public void setAttributes(String attributeCategory, DataListSet dls) {
        this.setAttributes(attributeCategory, this.geometryAttributeCategory.get(attributeCategory), dls);
    }

    public void setAttributes(String attributeCategory, Attribute attr, DataList dl) {
        this.setAttributes(attributeCategory, this.geometryAttributeCategory.get(attributeCategory), attr, dl);
    }

    public void setCountAndAttributes(String attributeCategory, Attribute attr, DataList dl) {
        this.setCountAndAttributes(attributeCategory, this.geometryAttributeCategory.get(attributeCategory), attr, dl);
    }

    public void setCountAndAttributes(String attributeCategory, DataListSet dls) {
        this.setCountAndAttributes(attributeCategory, this.geometryAttributeCategory.get(attributeCategory), dls);
    }

    protected void fireGeometryChangedImpl(Set<Attribute> vertexAttributeKeys, Set<Attribute> edgeAttributeKeys, Set<Attribute> faceAttributeKeys, Set<String> geomAttributeKeys) {
        GeometryListener l = this.geometryListener;
        if (l != null) {
            l.geometryChanged(new GeometryEvent(this, vertexAttributeKeys, edgeAttributeKeys, faceAttributeKeys, geomAttributeKeys));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(SceneGraphVisitor v) {
        this.startReader();
        try {
            v.visit(this);
        }
        finally {
            this.finishReader();
        }
    }

    static void superAccept(Geometry g, SceneGraphVisitor v) {
        g.superAccept(v);
    }

    private void superAccept(SceneGraphVisitor v) {
        super.accept(v);
    }
}

