/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.scene;

import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.event.CameraEvent;
import de.jreality.scene.event.CameraEventMulticaster;
import de.jreality.scene.event.CameraListener;
import de.jreality.util.LoggingSystem;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;

public class Camera
extends SceneGraphNode {
    double near = 0.5;
    double far = 50.0;
    double fieldOfView = Math.toRadians(60.0);
    double aspectRatio;
    double focus = 3.0;
    double fstop = -1.0;
    double focalLength = 0.1;
    Rectangle2D viewPort;
    private boolean isOnAxis = true;
    private boolean isPerspective = true;
    private boolean isStereo = false;
    double eyeSeparation = 0.07;
    double[] orientationMatrix;
    private CameraListener cameraListener;
    private static int UNNAMED_ID;

    public Camera(String name) {
        super(name);
    }

    public Camera() {
        this("camera " + UNNAMED_ID++);
    }

    public double getNear() {
        return this.near;
    }

    public void setNear(double d) {
        this.near = d;
        this.fireCameraChanged();
    }

    public double getFar() {
        return this.far;
    }

    public void setFar(double d) {
        if (this.far == d) {
            return;
        }
        this.far = d;
        this.fireCameraChanged();
    }

    public double getFieldOfView() {
        return 57.29577951308232 * this.fieldOfView;
    }

    public void setFieldOfView(double d) {
        double f = Math.PI / 180 * d;
        if (f == this.fieldOfView) {
            return;
        }
        this.fieldOfView = f;
        this.fireCameraChanged();
    }

    public double getFocus() {
        return this.focus;
    }

    public void setFocus(double d) {
        if (this.focus == d) {
            return;
        }
        this.focus = d;
        this.fireCameraChanged();
    }

    public Rectangle2D getViewPort() {
        return this.viewPort;
    }

    public void setViewPort(Rectangle2D rectangle2D) {
        if (this.isOnAxis) {
            throw new IllegalStateException("Can't set viewport for an on-axis camera");
        }
        this.viewPort = rectangle2D;
        this.fireCameraChanged();
    }

    public boolean isOnAxis() {
        return this.isOnAxis;
    }

    public void setOnAxis(boolean b) {
        if (this.isOnAxis == b) {
            return;
        }
        this.isOnAxis = b;
        this.fireCameraChanged();
    }

    public boolean isPerspective() {
        return this.isPerspective;
    }

    public void setPerspective(boolean b) {
        if (this.isPerspective == b) {
            return;
        }
        this.isPerspective = b;
        this.fireCameraChanged();
    }

    public double getEyeSeparation() {
        return this.eyeSeparation;
    }

    public void setEyeSeparation(double eyeSeparation) {
        if (this.eyeSeparation == eyeSeparation) {
            return;
        }
        this.eyeSeparation = eyeSeparation;
        this.fireCameraChanged();
    }

    public double[] getOrientationMatrix() {
        return this.orientationMatrix;
    }

    public void setOrientationMatrix(double[] orientationMatrix) {
        this.orientationMatrix = orientationMatrix;
        this.fireCameraChanged();
    }

    public boolean isStereo() {
        return this.isStereo;
    }

    public void setStereo(boolean isStereo) {
        if (this.isStereo == isStereo) {
            return;
        }
        this.isStereo = isStereo;
        if (!this.isPerspective) {
            LoggingSystem.getLogger(this).log(Level.WARNING, "Stereo camera must be perspective, setting it so.");
            this.isPerspective = true;
        }
        this.fireCameraChanged();
    }

    public void addCameraListener(CameraListener listener) {
        this.cameraListener = CameraEventMulticaster.add(this.cameraListener, listener);
    }

    public void removeCameraListener(CameraListener listener) {
        this.cameraListener = CameraEventMulticaster.remove(this.cameraListener, listener);
    }

    protected void fireCameraChanged() {
        CameraListener cl = this.cameraListener;
        if (cl != null) {
            cl.cameraChanged(new CameraEvent(this));
        }
    }

    public void accept(SceneGraphVisitor v) {
        v.visit(this);
    }

    static void superAccept(Camera c, SceneGraphVisitor v) {
        c.superAccept(v);
    }

    private void superAccept(SceneGraphVisitor v) {
        super.accept(v);
    }

    public double getFocalLength() {
        return this.focalLength;
    }

    public double getFStop() {
        return this.fstop;
    }

    public void setFStop(double fstop) {
        this.fstop = fstop;
    }

    public void setFocalLength(double focalLength) {
        this.focalLength = focalLength;
    }
}

