/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.renderman;

import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.renderman.RIBHelper;
import de.jreality.renderman.RIBVisitor;
import de.jreality.renderman.shader.ConstantTexture;
import de.jreality.scene.Appearance;
import de.jreality.shader.CubeMap;
import de.jreality.shader.ImageData;
import de.jreality.shader.TextureUtility;
import java.awt.Color;
import java.io.File;
import java.util.HashMap;

class RendermanSkyBox {
    double stretch = 40.0;
    private static double[][][] cubeVerts3 = new double[][][]{new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, -1.0}, {1.0, -1.0, -1.0}, {1.0, -1.0, 1.0}}, new double[][]{{-1.0, 1.0, -1.0}, {-1.0, 1.0, 1.0}, {-1.0, -1.0, 1.0}, {-1.0, -1.0, -1.0}}, new double[][]{{-1.0, 1.0, -1.0}, {1.0, 1.0, -1.0}, {1.0, 1.0, 1.0}, {-1.0, 1.0, 1.0}}, new double[][]{{-1.0, -1.0, 1.0}, {1.0, -1.0, 1.0}, {1.0, -1.0, -1.0}, {-1.0, -1.0, -1.0}}, new double[][]{{-1.0, 1.0, 1.0}, {1.0, 1.0, 1.0}, {1.0, -1.0, 1.0}, {-1.0, -1.0, 1.0}}, new double[][]{{1.0, 1.0, -1.0}, {-1.0, 1.0, -1.0}, {-1.0, -1.0, -1.0}, {1.0, -1.0, -1.0}}};
    private static double[][] texCoords = new double[][]{{0.0, 0.0}, {1.0, 0.0}, {1.0, 1.0}, {0.0, 1.0}};
    static Appearance a = new Appearance();
    static int[] nvertices = new int[]{4};
    static int[] vertices = new int[]{0, 1, 2, 3};

    RendermanSkyBox() {
    }

    static void render(RIBVisitor ribv, double[] w2c, CubeMap cm) {
        ImageData[] imgs = TextureUtility.getCubeMapImages(cm);
        ribv.ri.attributeBegin("SkyBox");
        if (ribv.getRendererType() == 2) {
            ribv.ri.verbatim("Attribute \"visibility\"  \"string transmission\" \"transparent\"");
        } else {
            ribv.ri.verbatim("Attribute \"visibility\"  \"int transmission\" [0]");
        }
        ribv.ri.color(Color.WHITE);
        ribv.ri.comment("Skybox ");
        ribv.ri.transformBegin();
        ribv.ri.concatTransform(RIBHelper.fTranspose(Rn.times(null, Rn.inverse(null, w2c), P3.extractOrientationMatrix(null, w2c, P3.originP3, 0))));
        ribv.ri.concatTransform(RIBHelper.fTranspose(P3.makeStretchMatrix(null, 500.0)));
        ConstantTexture ct = new ConstantTexture();
        float[] vvv = new float[12];
        float[] tc = new float[8];
        HashMap<String, float[]> map = new HashMap<String, float[]>();
        map.put("P", vvv);
        map.put("st", tc);
        int n = 0;
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 2; ++k) {
                tc[n++] = (float)texCoords[j][k];
            }
        }
        for (int i = 0; i < 6; ++i) {
            String name = ribv.writeTexture(imgs[i], 33071, 33071);
            ct.getAttributes().put("texturename", new File(name).getName());
            ribv.ri.shader(ct);
            int m = 0;
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 3; ++k) {
                    vvv[m++] = (float)cubeVerts3[i][j][k];
                }
            }
            ribv.ri.pointsPolygons(1, nvertices, vertices, map);
        }
        ribv.ri.transformEnd();
        ribv.ri.attributeEnd("SkyBox");
    }
}

