/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader.mathematica;

import java.awt.Color;

public class MHelper {
    public static Color cmykaToRgba(double c, double m, double y, double k, double a) {
        float r = (float)((1.0 - c) * (1.0 - k));
        float g = (float)((1.0 - m) * (1.0 - k));
        float b = (float)((1.0 - y) * (1.0 - k));
        float alph = (float)(1.0 - a);
        return new Color(r, g, b, alph);
    }

    public static Color greyLevelToRgba(double gr, double a) {
        return new Color((float)gr, (float)gr, (float)gr, (float)a);
    }

    public static Color hsbaToRgba(double h, double s, double b, double a) {
        Color col = Color.getHSBColor((float)h, (float)s, (float)b);
        if (a < 0.0) {
            return col;
        }
        return new Color((float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f, (float)a);
    }

    public static Color rgbaToRgba(double r, double g, double b, double a) {
        return new Color((float)r, (float)g, (float)b, (float)a);
    }

    public static Color rgbaToRgba(Color c, double a) {
        return new Color((float)((double)c.getRed() / 256.0), (float)((double)c.getGreen() / 256.0), (float)((double)c.getBlue() / 256.0), (float)a);
    }

    public static Color colorToRgba(double[] n) {
        if (n.length == 1) {
            return MHelper.greyLevelToRgba(n[0], 1.0);
        }
        if (n.length == 2) {
            return MHelper.greyLevelToRgba(n[0], n[1]);
        }
        if (n.length == 3) {
            return MHelper.rgbaToRgba(n[0], n[1], n[2], 1.0);
        }
        return MHelper.rgbaToRgba(n[0], n[1], n[2], n[3]);
    }

    static double[] getRgbaColor(Color c) {
        double[] col = new double[]{(double)c.getRed() / 256.0, (double)c.getGreen() / 256.0, (double)c.getBlue() / 256.0, (double)c.getAlpha() / 256.0};
        return col;
    }

    public static Color lighter(Color c, double frac) {
        double r = c.getRed() / 256;
        double g = c.getGreen() / 256;
        double b = c.getBlue() / 256;
        double a = c.getAlpha() / 256;
        r += (1.0 - r) * frac;
        g += (1.0 - g) * frac;
        b += (1.0 - b) * frac;
        return new Color((float)r, (float)g, (float)b, (float)a);
    }

    public static Color darker(Color c, double frac) {
        double r = (double)c.getRed() * (1.0 - frac) / 256.0;
        double g = (double)c.getGreen() * (1.0 - frac) / 256.0;
        double b = (double)c.getBlue() * (1.0 - frac) / 256.0;
        double a = (double)c.getAlpha() * (1.0 - frac) / 256.0;
        return new Color((float)r, (float)g, (float)b, (float)a);
    }

    public static Color opacity(Color c, double frac) {
        if (c == null) {
            return new Color(1.0f, 1.0f, 1.0f, (float)frac);
        }
        double r = (double)c.getRed() / 256.0;
        double g = (double)c.getGreen() / 256.0;
        double b = (double)c.getBlue() / 256.0;
        double a = frac;
        return new Color((float)r, (float)g, (float)b, (float)a);
    }

    public static Color spec(Color c, double frac) {
        return c;
    }
}

