/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.reader.AbstractReader;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import java.beans.Expression;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ReaderVRML
extends AbstractReader {
    public void setInput(Input input) throws IOException {
        try {
            Constructor<?> lexC = Class.forName("de.jreality.reader.vrml.VRMLV1Lexer").getConstructor(InputStream.class);
            Object lexer = lexC.newInstance(input.getInputStream());
            Constructor<?> parseC = Class.forName("de.jreality.reader.vrml.VRMLV1Parser").getConstructor(Class.forName("antlr.TokenStream"));
            Object parser = parseC.newInstance(lexer);
            Expression parse = new Expression(parser, "vrmlFile", null);
            this.root = (SceneGraphComponent)parse.getValue();
        }
        catch (ClassNotFoundException e) {
            LoggingSystem.getLogger(this).severe("VRML 1 parsing failed, call ANTLR first!");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            throw new Error(e);
        }
        catch (Exception e) {
            LoggingSystem.getLogger(this).severe("parsing " + input + " failed: " + e.getMessage());
        }
        if (this.root == null) {
            throw new IOException("could not load input: " + input);
        }
    }
}

