/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.reader;

import de.jreality.reader.SceneReader;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Secure;
import de.jreality.util.SimpleURLPolicy;
import java.beans.Statement;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.Policy;
import java.security.SecureClassLoader;
import java.util.LinkedList;
import java.util.logging.Level;

public class ReaderBSH
implements SceneReader {
    private static final SecureClassLoader bshLoader;
    private static final SimpleURLPolicy bshPolicy;
    private Object bsh;
    private SceneGraphComponent root;

    public ReaderBSH() throws Exception {
        System.setSecurityManager(new SecurityManager());
        this.root = new SceneGraphComponent();
        this.root.setName("BSHroot");
        this.bsh = bshLoader.loadClass("bsh.Interpreter").getConstructor(Reader.class, PrintStream.class, PrintStream.class, Boolean.TYPE).newInstance(null, System.out, System.err, Boolean.TRUE);
        ReaderBSH.exec(this.bsh, "eval", "import de.jreality.scene.*");
        ReaderBSH.exec(this.bsh, "eval", "import de.jreality.geometry.*");
        ReaderBSH.exec(this.bsh, "eval", "import de.jreality.scene.data.*");
        ReaderBSH.exec(this.bsh, "set", new Object[]{"root", this.root});
    }

    public void setInput(Input input) throws IOException {
        try {
            this.processReader(input.getReader(), null, null);
        }
        catch (Exception e) {
            LoggingSystem.getLogger(this).log(Level.SEVERE, "eval failed", e);
        }
    }

    public void appendInput(Input input) throws IOException {
        this.setInput(input);
    }

    public void processReader(Reader in, PrintStream out, PrintStream err) throws Exception {
        ReaderBSH.exec(this.bsh, "setOut", out);
        ReaderBSH.exec(this.bsh, "setErr", err);
        ReaderBSH.exec(this.bsh, "eval", in);
    }

    public SceneGraphComponent getComponent() {
        return this.root;
    }

    private static void exec(Object target, String methodName, Object arg) throws Exception {
        ReaderBSH.exec(target, methodName, new Object[]{arg});
    }

    private static void exec(Object target, String methodName, Object[] args) throws Exception {
        Statement s = new Statement(target, methodName, args);
        s.execute();
    }

    static {
        try {
            URL bshURL = new URL(Secure.getProperty("jreality.bsh.jar", "file:///net/MathVis/Oorange/oorange1.9/lib/bsh-1.3b2.jar"));
            bshLoader = new URLClassLoader(new URL[]{bshURL}, Thread.currentThread().getContextClassLoader());
            LinkedList<AllPermission> pc = new LinkedList<AllPermission>();
            pc.add(new AllPermission());
            bshPolicy = new SimpleURLPolicy(pc, bshURL);
            Policy.setPolicy(bshPolicy);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

