/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.math;

import de.jreality.math.Rn;
import de.jreality.util.LoggingSystem;

public class Pn {
    public static final int ELLIPTIC = 1;
    public static final int EUCLIDEAN = 0;
    public static final int HYPERBOLIC = -1;
    public static final int PROJECTIVE = 2;
    public static double[] zDirectionP3 = new double[]{0.0, 0.0, 1.0, 0.0};

    private Pn() {
    }

    public static double cosh(double x) {
        return 0.5 * (Math.exp(x) + Math.exp(-x));
    }

    public static double sinh(double x) {
        return 0.5 * (Math.exp(x) - Math.exp(-x));
    }

    public static double tanh(double x) {
        return Pn.sinh(x) / Pn.cosh(x);
    }

    public static double acosh(double x) {
        return Math.log((x > 0.0 ? x : -x) + Math.sqrt(x * x - 1.0));
    }

    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static double angleBetween(double[] u, double[] v, int metric) {
        double uu = Pn.innerProductPlanes(u, u, metric);
        double vv = Pn.innerProductPlanes(v, v, metric);
        double uv = Pn.innerProductPlanes(u, v, metric);
        if (uu == 0.0 || vv == 0.0) {
            return Double.MAX_VALUE;
        }
        double f = uv / Math.sqrt(Math.abs(uu * vv));
        if (f > 1.0) {
            f = 1.0;
        }
        if (f < -1.0) {
            f = -1.0;
        }
        double d = Math.acos(f);
        return d;
    }

    public static double[][] calculateBounds(double[][] bounds, double[][] vlist) {
        int i;
        int vl = vlist[0].length;
        int bl = bounds[0].length;
        double[] tmp = new double[vl - 1];
        if (vl - 1 > bl) {
            return null;
        }
        for (i = 0; i < vl - 1; ++i) {
            bounds[0][i] = Double.MAX_VALUE;
            bounds[1][i] = -1.7976931348623157E308;
        }
        for (i = vl - 1; i < bl; ++i) {
            bounds[1][i] = 0.0;
            bounds[0][i] = 0.0;
        }
        for (i = 0; i < vlist.length; ++i) {
            if (vlist[i][vl - 1] == 0.0) continue;
            Pn.dehomogenize(tmp, vlist[i]);
            Rn.max(bounds[1], bounds[1], tmp);
            Rn.min(bounds[0], bounds[0], tmp);
        }
        return bounds;
    }

    public static double[] centroid(double[] average, double[][] points, int metric) {
        if (average == null) {
            average = new double[points[0].length];
        }
        double[] tmp = new double[average.length];
        for (int i = 0; i < points.length; ++i) {
            Pn.normalize(tmp, points[i], metric);
            Rn.add(average, tmp, average);
        }
        Rn.times(average, 1.0 / (double)points.length, average);
        Pn.normalize(average, average, metric);
        return average;
    }

    public static double[] dehomogenize(double[] dst, double[] src) {
        int dl;
        int sl = src.length;
        if (dst == null) {
            dst = new double[src.length];
        }
        if ((dl = dst.length) != sl && dl + 1 != sl) {
            throw new IllegalArgumentException("Invalid dimensions");
        }
        double last = src[sl - 1];
        if (last == 1.0 || last == 0.0) {
            if (src != dst) {
                System.arraycopy(src, 0, dst, 0, dl);
            }
            return dst;
        }
        last = 1.0 / last;
        for (int i = 0; i < dl; ++i) {
            dst[i] = last * src[i];
        }
        if (dl == sl) {
            dst[dl - 1] = 1.0;
        }
        return dst;
    }

    public static double coordForDistance(double d, int metric) {
        switch (metric) {
            case -1: {
                return Math.tanh(d);
            }
            default: {
                return d;
            }
            case 1: 
        }
        return Math.tan(d);
    }

    public static double[][] dehomogenize(double[][] dst, double[][] src) {
        int dl;
        int sl = src.length;
        if (dst == null) {
            dst = new double[sl][src[0].length - 1];
        }
        if ((dl = dst.length) != sl) {
            throw new IllegalArgumentException("Invalid dimensions");
        }
        for (int i = 0; i < sl; ++i) {
            Pn.dehomogenize(dst[i], src[i]);
        }
        return dst;
    }

    public static double distanceBetween(double[] u, double[] v, int metric) {
        double d = 0.0;
        int n = u.length;
        switch (metric) {
            default: {
                double ul = u[n - 1];
                double vl = v[n - 1];
                double ulvl = ul * vl;
                for (int i = 0; i < n - 1; ++i) {
                    double tmp = ul * v[i] - vl * u[i];
                    d += tmp * tmp;
                }
                if ((d = Math.sqrt(d)) != 0.0 && d != 1.0) {
                    d /= Math.abs(ulvl);
                }
                if (ul != 0.0 && vl != 0.0) break;
                d = Double.MAX_VALUE;
                break;
            }
            case -1: {
                double uu = Pn.innerProduct(u, u, metric);
                double vv = Pn.innerProduct(v, v, metric);
                double uv = Pn.innerProduct(u, v, metric);
                if (uu == 0.0 || vv == 0.0) {
                    throw new IllegalArgumentException("Points cannot lie on the hyperbolic absolute");
                }
                double k = uv / Math.sqrt(Math.abs(uu * vv));
                if (uu < 0.0 && vv < 0.0) {
                    d = Pn.acosh(k);
                    break;
                }
                if (uu < 0.0 && vv > 0.0 || uu > 0.0 && vv < 0.0) {
                    d = Pn.asinh(k);
                    break;
                }
                if (!(uu > 0.0) || !(vv > 0.0)) break;
                d = Math.acos(k);
                break;
            }
            case 1: {
                double uu = Pn.innerProduct(u, u, metric);
                double vv = Pn.innerProduct(v, v, metric);
                double uv = Pn.innerProduct(u, v, metric);
                d = Math.acos(uv / Math.sqrt(Math.abs(uu * vv)));
            }
        }
        return d;
    }

    public static double[] dragTangentVector(double[] dst, double[] ddir, double[] src, double[] sdir, double length, int metric) {
        int n = src.length;
        if (n != sdir.length) {
            throw new IllegalArgumentException("Invalid dimensions");
        }
        if (ddir != null && ddir.length != n) {
            throw new IllegalArgumentException("Invalid dimensions");
        }
        if (dst == null) {
            dst = new double[n];
        }
        switch (metric) {
            case 0: {
                double[] tdir = Pn.setToLength(null, sdir, length, metric);
                tdir[n - 1] = 0.0;
                Rn.add(dst, src, tdir);
                if (ddir == null) break;
                Rn.copy(ddir, sdir);
                break;
            }
            case -1: {
                double c = Pn.cosh(length);
                double s = Pn.sinh(length);
                Rn.linearCombination(dst, c, src, s, sdir);
                if (ddir == null) break;
                Rn.linearCombination(ddir, s, src, c, sdir);
                break;
            }
            case 1: {
                double c = Math.cos(length);
                double s = Math.sin(length);
                Rn.linearCombination(dst, c, src, s, sdir);
                if (ddir == null) break;
                Rn.linearCombination(ddir, -s, src, c, sdir);
            }
        }
        return dst;
    }

    public static double[] dragTangentVector(double[] dstTangent, double[] sourcePoint, double[] sourceTangent, double[] dstPoint, int metric) {
        double d = Pn.distanceBetween(sourcePoint, dstPoint, metric);
        if (dstTangent == null) {
            dstTangent = new double[sourcePoint.length];
        }
        Pn.dragTangentVector(null, dstTangent, sourcePoint, sourceTangent, d, metric);
        return dstTangent;
    }

    public static double[] dragTowards(double[] result, double[] p0, double[] p1, double length, int metric) {
        double[] np0 = new double[p0.length];
        double[] np1 = new double[p1.length];
        if (metric == 0) {
            int last = p0.length - 1;
            Pn.normalize(np0, p0, metric);
            Pn.normalize(np1, p1, metric);
            if (np1[last] == 1.0 && np0[last] == 1.0) {
                Rn.subtract(np1, np1, np0);
            }
            double norm = Rn.euclideanNorm(np1);
            return Rn.add(result, Rn.times(np1, length / norm, np1), np0);
        }
        Pn.normalize(np0, p0, metric);
        Pn.projectToTangentSpace(np1, np0, p1, metric);
        Pn.normalize(np1, np1, metric);
        double[] res = Pn.dragTangentVector(result, null, np0, np1, length, metric);
        return res;
    }

    public static double[] homogenize(double[] dst, double[] src) {
        double[] to;
        int n = src.length;
        if (dst != null) {
            if (dst.length != n + 1) {
                throw new IllegalArgumentException("dst must be length (n+1)");
            }
            to = dst;
        } else {
            to = new double[n + 1];
        }
        System.arraycopy(src, 0, to, 0, n);
        to[n] = 1.0;
        return to;
    }

    public static double[][] homogenize(double[][] dst, double[][] src) {
        if (dst == null) {
            dst = new double[src.length][src[0].length + 1];
        }
        int n = Math.min(dst.length, src.length);
        for (int i = 0; i < n; ++i) {
            Pn.homogenize(dst[i], src[i]);
        }
        return dst;
    }

    public static double innerProduct(double[] dst, double[] src, int metric) {
        double sum = 0.0;
        if (src.length != dst.length) {
            throw new IllegalArgumentException("Incompatible lengths");
        }
        int n = dst.length;
        for (int i = 0; i < n - 1; ++i) {
            sum += dst[i] * src[i];
        }
        double ff = dst[n - 1] * src[n - 1];
        switch (metric) {
            case -1: {
                sum -= ff;
                break;
            }
            case 0: {
                if (ff == 1.0 || ff == 0.0) break;
                sum /= ff;
                break;
            }
            case 1: {
                sum += ff;
            }
        }
        return sum;
    }

    public static double innerProductPlanes(double[] dst, double[] src, int metric) {
        if (metric != 0) {
            return Pn.innerProduct(dst, src, metric);
        }
        int n = src.length;
        double sum = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            sum += dst[i] * src[i];
        }
        return sum;
    }

    public static double innerProductPoints(double[] dst, double[] src, int metric) {
        return Pn.innerProduct(dst, src, metric);
    }

    public static boolean isValidCoordinate(double[] transVec, int dim, int metric) {
        boolean ret = true;
        if (transVec.length < dim) {
            return false;
        }
        if (metric == 0 && transVec.length == dim + 1 && transVec[dim] == 0.0) {
            ret = false;
        } else if (metric == -1) {
            if (transVec.length == dim + 1 && !(Pn.innerProduct(transVec, transVec, metric) < 0.0)) {
                ret = false;
            } else if (transVec.length == dim && !(Rn.innerProduct(transVec, transVec) < 1.0)) {
                ret = false;
            }
        }
        if (!ret) {
            LoggingSystem.getLogger(Pn.class).warning("Invalid coordinate: " + Rn.toString(transVec) + " metric: " + metric);
        }
        return ret;
    }

    public static double[] linearInterpolation(double[] dst, double[] u, double[] v, double t, int metric) {
        double dot = 0.0;
        double s0 = 0.0;
        double s1 = 0.0;
        if (dst == null) {
            dst = new double[u.length];
        }
        double[] uu = new double[dst.length];
        double[] vv = new double[dst.length];
        int realmetric = metric;
        if (metric != 0) {
            Pn.normalize(uu, u, metric);
            Pn.normalize(vv, v, metric);
        } else {
            uu = u;
            vv = v;
        }
        switch (metric) {
            case 0: 
            case 2: {
                s0 = 1.0 - t;
                s1 = t;
                break;
            }
            case -1: {
                dot = Pn.innerProduct(uu, vv, metric);
                if (!(Math.abs(dot) <= 1.0)) break;
                realmetric = 1;
                break;
            }
            case 1: {
                dot = Pn.innerProduct(uu, vv, metric);
                if (dot > 1.0) {
                    dot = 1.0;
                }
                if (!(dot < -1.0)) break;
                dot = -1.0;
            }
        }
        if (realmetric == 1) {
            double angle = Math.acos(dot);
            double s2 = Math.sin(angle);
            if (s2 != 0.0) {
                s0 = Math.sin((1.0 - t) * angle) / s2;
                s1 = Math.sin(t * angle) / s2;
            } else {
                s0 = 1.0;
                s1 = 0.0;
            }
        } else if (realmetric == -1) {
            double angle = Pn.acosh(dot);
            double s2 = Pn.sinh(angle);
            if (s2 != 0.0) {
                s0 = Pn.sinh((1.0 - t) * angle) / s2;
                s1 = Pn.sinh(t * angle) / s2;
            } else {
                s0 = 1.0;
                s1 = 0.0;
            }
        }
        return Rn.linearCombination(dst, s0, uu, s1, vv);
    }

    public static double[] makeHarmonicHarmology(double[] dst, double[] center, double[] axis) {
        return Pn.makeGeneralizedProjection(dst, center, axis, -2.0);
    }

    public static double[] makeFlattenProjection(double[] dst, double[] center, double[] axis) {
        return Pn.makeGeneralizedProjection(dst, center, axis, -1.0);
    }

    public static double[] makeGeneralizedProjection(double[] dst, double[] center, double[] axis, double val) {
        if (center.length != axis.length) {
            throw new IllegalArgumentException("center and axis must have same length");
        }
        int n = center.length;
        if (dst == null) {
            dst = new double[n * n];
        }
        double f = 1.0 / Rn.innerProduct(center, axis);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dst[n * i + j] = (double)(i == j ? 1 : 0) + val * f * center[i] * axis[j];
            }
        }
        return dst;
    }

    public static double[] midPlane(double[] midp, double[] pl1, double[] pl2, int metric) {
        if (midp == null) {
            midp = new double[4];
        }
        double[] pt1 = Pn.normalizePlane(null, pl1, metric);
        double[] pt2 = Pn.normalizePlane(null, pl2, metric);
        Pn.linearInterpolation(midp, pt1, pt2, 0.5, metric);
        return midp;
    }

    public static double norm(double[] src, int metric) {
        return Math.sqrt(Math.abs(Pn.innerProduct(src, src, metric)));
    }

    public static double[] normalize(double[] dst, double[] dvec, double[] src, double[] svec, int metric) {
        if (dst == null) {
            dst = new double[src.length];
        }
        if (metric == 0) {
            Pn.dehomogenize(dst, src);
            Pn.dehomogenize(dvec, svec);
            dvec[dvec.length - 1] = 0.0;
            return dst;
        }
        Pn.normalize(dst, src, metric);
        dvec = Pn.projectToTangentSpace(dvec, dst, svec, metric);
        Pn.normalize(dvec, dvec, metric);
        return dst;
    }

    public static double[] normalize(double[] dst, double[] src, int metric) {
        if (dst == null) {
            dst = new double[src.length];
        }
        if (metric == 0) {
            return Pn.dehomogenize(dst, src);
        }
        return Pn.setToLength(dst, src, 1.0, metric);
    }

    public static double[][] normalize(double[][] dst, double[][] src, int metric) {
        if (dst == null) {
            dst = new double[src.length][src[0].length];
        }
        if (dst.length != src.length) {
            throw new IllegalArgumentException("Incompatible lengths");
        }
        int n = dst.length;
        for (int i = 0; i < n; ++i) {
            Pn.normalize(dst[i], src[i], metric);
        }
        return dst;
    }

    public static double[] normalizePlane(double[] dst, double[] src, int metric) {
        if (metric != 0) {
            return Pn.normalize(dst, src, metric);
        }
        int n = src.length;
        if (dst == null) {
            dst = new double[n];
        }
        double[] foo = new double[n - 1];
        System.arraycopy(src, 0, foo, 0, n - 1);
        double ll = Rn.euclideanNorm(foo);
        if (ll == 0.0) {
            return null;
        }
        Rn.times(dst, 1.0 / ll, src);
        return dst;
    }

    public static double[] normalizePoint(double[] dst, double[] src, int metric) {
        return Pn.normalize(dst, src, metric);
    }

    public static double normSquared(double[] src, int metric) {
        return Pn.innerProduct(src, src, metric);
    }

    public static double[] polarize(double[] polar, double[] p, int metric) {
        if (polar == null) {
            polar = (double[])p.clone();
        } else {
            System.arraycopy(p, 0, polar, 0, p.length);
        }
        switch (metric) {
            case 1: {
                break;
            }
            case 0: {
                polar[polar.length - 1] = 0.0;
                break;
            }
            case -1: {
                int n = polar.length - 1;
                polar[n] = polar[n] * -1.0;
            }
        }
        return polar;
    }

    public static double[][] polarize(double[][] polar, double[][] p, int metric) {
        if (polar == null) {
            polar = new double[p.length][];
        }
        if (((double[][])polar).length != p.length) {
            throw new IllegalArgumentException("dst has invalid length");
        }
        int n = p.length;
        for (int i = 0; i < n; ++i) {
            polar[i] = Pn.polarize(polar[i], p[i], metric);
        }
        return polar;
    }

    public static double[] polarizePlane(double[] dst, double[] plane, int metric) {
        return Pn.polarize(dst, plane, metric);
    }

    public static double[] polarizePoint(double[] dst, double[] point, int metric) {
        if (metric == 0) {
            if (dst == null) {
                dst = new double[point.length];
            }
            for (int i = 0; i < dst.length - 1; ++i) {
                dst[i] = 0.0;
            }
            dst[dst.length - 1] = -1.0;
            return dst;
        }
        return Pn.polarize(dst, point, metric);
    }

    public static double[] projectOnto(double[] result, double[] master, double[] victim, int metric) {
        if (master.length != victim.length) {
            throw new IllegalArgumentException("Arguments must be same dimension");
        }
        int n = master.length;
        if (result == null) {
            result = new double[n];
        }
        double factor = Pn.innerProductPlanes(master, victim, metric);
        double pp = Pn.innerProductPlanes(master, master, metric);
        if (pp != 0.0) {
            factor /= pp;
        }
        Rn.times(result, factor, master);
        return result;
    }

    public static double[] projectOntoComplement(double[] result, double[] master, double[] victim, int metric) {
        return Rn.subtract(result, victim, Pn.projectOnto(null, master, victim, metric));
    }

    public static double[] projectToTangentSpace(double[] result, double[] point, double[] tangentToBe, int metric) {
        int n = point.length;
        if (result == null) {
            result = new double[n];
        }
        if (metric == 0) {
            Pn.polarizePlane(result, tangentToBe, metric);
            return result;
        }
        double factor = Pn.innerProduct(point, tangentToBe, metric);
        double pp = Pn.innerProduct(point, point, metric);
        if (pp != 0.0) {
            factor /= pp;
        }
        Rn.subtract(result, tangentToBe, Rn.times(null, factor, point));
        return result;
    }

    public static double[] setToLength(double[] dst, double[] src, double length, int metric) {
        if (dst == null) {
            dst = new double[src.length];
        }
        if (dst.length != src.length) {
            throw new IllegalArgumentException("Incompatible lengths");
        }
        if (metric == 0) {
            Pn.dehomogenize(dst, src);
        } else {
            System.arraycopy(src, 0, dst, 0, dst.length);
        }
        double ll = Pn.norm(dst, metric);
        if (ll == 0.0) {
            return dst;
        }
        ll = length / ll;
        Rn.times(dst, ll, dst);
        if (metric == 0 && dst[dst.length - 1] != 0.0) {
            dst[dst.length - 1] = 1.0;
        }
        return dst;
    }

    public static double[][] setToLength(double[][] dst, double[][] src, double d, int metric) {
        int dl;
        int sl = src.length;
        if (dst == null) {
            dst = new double[sl][src[0].length - 1];
        }
        if ((dl = dst.length) != sl) {
            throw new IllegalArgumentException("Incompatible lengths");
        }
        for (int i = 0; i < sl; ++i) {
            Pn.setToLength(dst[i], src[i], d, metric);
        }
        return dst;
    }
}

