/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.math;

import de.jreality.math.Pn;
import de.jreality.math.Quaternion;
import de.jreality.math.Rn;
import de.jreality.util.LoggingSystem;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;

public class P3 {
    private static boolean debug = false;
    private static final double[] hzaxis = new double[]{0.0, 0.0, 1.0, 1.0};
    public static double[] p3involution = Rn.diagonalMatrix(null, new double[]{-1.0, -1.0, -1.0, -1.0});
    public static double[] Q_HYPERBOLIC;
    public static double[] Q_EUCLIDEAN;
    public static double[] Q_ELLIPTIC;
    public static double[][] Q_LIST;
    static final double[] xaxis;
    static final double[] yaxis;
    static final double[] zaxis;
    static double[] zeroVector;
    public static double[] originP3;

    private P3() {
    }

    public static double[] composeMatrixFromFactors(double[] m, double[] transV, Quaternion rotQ, Quaternion stretchRotQ, double[] stretchV, boolean isFlipped, int metric) {
        double[] transT = new double[16];
        double[] rotT = new double[16];
        double[] stretchRotT = new double[16];
        double[] stretchT = new double[16];
        double[] tmp = new double[3];
        if (transV == null || rotQ == null || stretchV == null) {
            throw new IllegalArgumentException("Null argument");
        }
        P3.makeTranslationMatrix(transT, transV, metric);
        Quaternion.quaternionToRotationMatrix(rotT, rotQ);
        Quaternion.quaternionToRotationMatrix(stretchRotT, stretchRotQ);
        if (isFlipped) {
            for (int i = 0; i < 3; ++i) {
                tmp[i] = -stretchV[i];
            }
        } else {
            System.arraycopy(stretchV, 0, tmp, 0, 3);
        }
        Rn.setDiagonalMatrix(stretchT, tmp);
        Rn.times(m, rotT, stretchT);
        Rn.times(m, transT, m);
        return m;
    }

    public static double[] extractOrientationMatrix(double[] dst, double[] src, double[] point, int metric) {
        if (dst == null) {
            dst = new double[16];
        }
        double[] image = Rn.matrixTimesVector(null, src, point);
        double[] translate = P3.makeTranslationMatrix(null, image, metric);
        Rn.times(dst, Rn.inverse(null, translate), src);
        return dst;
    }

    public static double[] factorMatrix(double[] m, double[] transV, Quaternion rotQ, Quaternion stretchRotQ, double[] stretchV, boolean[] isFlipped, int metric) {
        double[] itransT = new double[16];
        double[] transT = new double[16];
        double[] tmp = new double[16];
        double[] M3 = new double[9];
        double[] Q3 = new double[9];
        double[] S3 = new double[9];
        double det = Rn.determinant(m);
        isFlipped[0] = det < 0.0;
        Rn.matrixTimesVector(transV, m, originP3);
        if (metric == 0 && transV[3] == 0.0) {
            throw new IllegalArgumentException("bad translation vector");
        }
        P3.makeTranslationMatrix(transT, transV, metric);
        Rn.inverse(itransT, transT);
        Rn.times(tmp, itransT, m);
        Rn.extractSubmatrix(M3, tmp, 0, 2, 0, 2);
        if (isFlipped[0]) {
            Rn.times(M3, -1.0, M3);
        }
        Rn.polarDecompose(Q3, S3, M3);
        stretchV[0] = S3[0];
        stretchV[1] = S3[4];
        stretchV[2] = S3[8];
        Quaternion.rotationMatrixToQuaternion(rotQ, Q3);
        stretchRotQ.setValue(1.0, 0.0, 0.0, 0.0);
        return m;
    }

    public static double[] makeGlideReflectionMatrix(double[] m, double[] p1, double[] p2, double[] plane, int metric) {
        double[] m2;
        double[] reflection;
        double d;
        if (p1.length == 3) {
            p1 = Pn.homogenize(null, p1);
        }
        if (p2.length == 3) {
            p2 = Pn.homogenize(null, p2);
        }
        if (Math.abs(d = Rn.innerProduct(p1, plane)) > 1.0E-7) {
            throw new IllegalStateException("points must lie in plane");
        }
        d = Rn.innerProduct(p2, plane);
        if (Math.abs(d) > 1.0E-7) {
            throw new IllegalStateException("points must lie in plane");
        }
        double[] tlate = P3.makeTranslationMatrix(null, p1, p2, metric);
        double[] xx = Rn.times(null, m = Rn.times(m, tlate, reflection = P3.makeReflectionMatrix(null, plane, metric)), Rn.inverse(null, m2 = Rn.times(null, reflection, tlate)));
        if (!Rn.isIdentityMatrix(xx, 1.0E-7)) {
            throw new IllegalStateException("they don't commute!");
        }
        return m;
    }

    public static double[] makeLookatMatrix(double[] m, double[] from, double[] to, double roll, int metric) {
        double[] newto = new double[4];
        double[] tm1 = new double[16];
        double[] tm2 = new double[16];
        if (m == null) {
            m = new double[16];
        }
        P3.makeTranslationMatrix(tm1, from, metric);
        Rn.inverse(tm1, tm1);
        Rn.matrixTimesVector(newto, tm1, to);
        P3.makeRotationMatrix(tm2, newto, zaxis);
        Rn.times(m, tm2, tm1);
        if (roll != 0.0) {
            P3.makeRotationMatrix(tm1, zaxis, roll);
            Rn.times(m, tm1, m);
        }
        return m;
    }

    public static double[] makeOrthographicProjectionMatrix(double[] m, Rectangle2D viewport, double near, double far) {
        double l = viewport.getMinX();
        double r = viewport.getMaxX();
        double b = viewport.getMinY();
        double t = viewport.getMaxY();
        if (m == null) {
            m = new double[16];
        }
        Rn.setIdentityMatrix(m);
        m[0] = 2.0 / (r - l);
        m[5] = 2.0 / (t - b);
        m[10] = -2.0 / (far - near);
        m[3] = -(r + l) / (r - l);
        m[7] = -(t + b) / (t - b);
        m[11] = -(far + near) / (far - near);
        return m;
    }

    public static double[] makePerspectiveProjectionMatrix(double[] dst, Rectangle2D viewport, double near, double far) {
        if (dst == null) {
            dst = new double[16];
        }
        double an = Math.abs(near);
        double l = viewport.getMinX() * an;
        double r = viewport.getMaxX() * an;
        double b = viewport.getMinY() * an;
        double t = viewport.getMaxY() * an;
        Rn.setIdentityMatrix(dst);
        dst[0] = 2.0 * near / (r - l);
        dst[5] = 2.0 * near / (t - b);
        dst[10] = (far + near) / (near - far);
        dst[15] = 0.0;
        dst[2] = (r + l) / (r - l);
        dst[6] = (t + b) / (t - b);
        dst[11] = 2.0 * near * far / (near - far);
        dst[14] = -1.0;
        return dst;
    }

    public static double[] makeReflectionMatrix(double[] m, double[] plane, int metric) {
        if (plane.length != 4) {
            throw new IllegalArgumentException("makeReflectionMatrix: Invalid argument");
        }
        double[] reflectionMatrix = null;
        double[] fixedPlane = (double[])plane.clone();
        double[] polarPoint = null;
        reflectionMatrix = m == null ? new double[16] : m;
        Rn.setIdentityMatrix(reflectionMatrix);
        polarPoint = Pn.polarizePlane(null, fixedPlane, metric);
        Pn.setToLength(polarPoint, polarPoint, 1.0, metric);
        switch (metric) {
            case -1: 
            case 1: {
                Pn.normalize(fixedPlane, fixedPlane, metric);
                break;
            }
            case 0: {
                Pn.normalizePlane(fixedPlane, fixedPlane, metric);
            }
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                reflectionMatrix[i * 4 + j] = reflectionMatrix[i * 4 + j] - 2.0 * fixedPlane[j] * polarPoint[i];
            }
        }
        return reflectionMatrix;
    }

    public static double[] makeRotationMatrix(double[] m, double[] axis, double angle) {
        double[] u = new double[3];
        if (m == null) {
            m = new double[16];
        }
        if (axis.length < 3) {
            throw new IllegalArgumentException("Axis is wrong size");
        }
        System.arraycopy(axis, 0, u, 0, 3);
        Rn.normalize(u, u);
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double v = 1.0 - c;
        Rn.setIdentityMatrix(m);
        m[0] = u[0] * u[0] * v + c;
        m[4] = u[0] * u[1] * v + u[2] * s;
        m[8] = u[0] * u[2] * v - u[1] * s;
        m[1] = u[1] * u[0] * v - u[2] * s;
        m[5] = u[1] * u[1] * v + c;
        m[9] = u[1] * u[2] * v + u[0] * s;
        m[2] = u[2] * u[0] * v + u[1] * s;
        m[6] = u[2] * u[1] * v - u[0] * s;
        m[10] = u[2] * u[2] * v + c;
        return m;
    }

    public static double[] makeRotationMatrix(double[] m, double[] from, double[] to) {
        if (from.length < 3 || to.length < 3) {
            throw new IllegalArgumentException("Input vectors too short");
        }
        double[][] vecs = new double[3][3];
        System.arraycopy(from, 0, vecs[0], 0, 3);
        System.arraycopy(to, 0, vecs[1], 0, 3);
        Rn.normalize(vecs[0], vecs[0]);
        Rn.normalize(vecs[1], vecs[1]);
        double cosAngle = Rn.innerProduct(vecs[0], vecs[1]);
        double angle = Math.acos(cosAngle);
        if (Double.isNaN(angle)) {
            angle = cosAngle > 0.0 ? 0.0 : Math.PI;
        }
        Rn.crossProduct(vecs[2], vecs[0], vecs[1]);
        Rn.normalize(vecs[2], vecs[2]);
        return P3.makeRotationMatrix(m, vecs[2], angle);
    }

    public static double[] makeRotationMatrix(double[] m, double[] p1, double[] p2, double angle, int metric) {
        if (p1.length < 3 || p2.length < 3) {
            throw new IllegalArgumentException("Points too short");
        }
        if (m == null) {
            m = new double[16];
        }
        double[] tmat = P3.makeTranslationMatrix(null, p1, metric);
        double[] invtmat = Rn.inverse(null, tmat);
        double[] ip2 = new double[4];
        Rn.matrixTimesVector(ip2, invtmat, p2);
        double[] foo = P3.makeRotationMatrix(null, ip2, angle);
        Rn.conjugateByMatrix(m, foo, tmat);
        return m;
    }

    public static double[] makeRotationMatrixX(double[] mat, double angle) {
        double[] axis = new double[]{1.0, 0.0, 0.0};
        return P3.makeRotationMatrix(mat, axis, angle);
    }

    public static double[] makeRotationMatrixY(double[] mat, double angle) {
        double[] axis = new double[]{0.0, 1.0, 0.0};
        return P3.makeRotationMatrix(mat, axis, angle);
    }

    public static double[] makeRotationMatrixZ(double[] mat, double angle) {
        double[] axis = new double[]{0.0, 0.0, 1.0};
        return P3.makeRotationMatrix(mat, axis, angle);
    }

    public static double[] makeStretchMatrix(double[] dst, double stretch) {
        if (dst == null) {
            dst = new double[16];
        }
        int n = Rn.mysqrt(dst.length);
        double[] stretchV = new double[n];
        Rn.setToValue(stretchV, stretch, stretch, stretch, 1.0);
        return P3.makeStretchMatrix(dst, stretchV);
    }

    public static double[] makeStretchMatrix(double[] dst, double xscale, double yscale, double zscale) {
        if (dst == null) {
            dst = new double[16];
        }
        Rn.setIdentityMatrix(dst);
        dst[0] = xscale;
        dst[5] = yscale;
        dst[10] = zscale;
        return dst;
    }

    public static double[] makeStretchMatrix(double[] dst, double[] v) {
        if (dst == null) {
            dst = new double[16];
        }
        int n = Rn.mysqrt(dst.length);
        int ll = Math.min(n, v.length);
        Rn.setIdentityMatrix(dst);
        for (int i = 0; i < ll; ++i) {
            dst[i * n + i] = v[i];
        }
        return dst;
    }

    public static double[] makeScaleMatrix(double[] dst, double s) {
        return P3.makeStretchMatrix(dst, s);
    }

    public static double[] makeScaleMatrix(double[] dst, double[] s) {
        return P3.makeStretchMatrix(dst, s);
    }

    public static double[] makeScaleMatrix(double[] dst, double sx, double sy, double sz) {
        return P3.makeStretchMatrix(dst, sx, sy, sz);
    }

    public static double[] makeScrewMotionMatrix(double[] dst, double[] p1, double[] p2, double angle, int metric) {
        double[] tlate = P3.makeTranslationMatrix(null, p1, p2, metric);
        double[] rot = P3.makeRotationMatrix(null, p1, p2, angle, metric);
        return Rn.times(dst, tlate, rot);
    }

    public static double[] makeTranslationMatrix(double[] dst, double[] from, double[] to, int metric) {
        if (dst == null) {
            dst = new double[16];
        }
        double[] TP = P3.makeTranslationMatrix(null, from, metric);
        double[] iTP = Rn.inverse(null, TP);
        double[] toPrime = Rn.matrixTimesVector(null, iTP, to);
        P3.makeTranslationMatrix(dst, toPrime, metric);
        Rn.conjugateByMatrix(dst, dst, TP);
        return dst;
    }

    public static double[] makeTranslationMatrix(double[] mat, double[] to, int metric) {
        double[] oldm;
        int i;
        if (mat == null) {
            mat = new double[16];
        }
        double[] toL1 = null;
        if (to.length == 3) {
            toL1 = Pn.homogenize(null, to);
        } else if (to.length == 4) {
            toL1 = (double[])to.clone();
        }
        if (metric == 0 && toL1[3] == 0.0) {
            throw new IllegalArgumentException("Infinite euclidean translation vector");
        }
        double[] toL = Pn.normalize(null, toL1, metric);
        if (Double.isNaN(toL[0])) {
            Rn.setIdentityMatrix(mat);
            return mat;
        }
        double f = 1.0 / (1.0 + toL[3]);
        if (toL[3] < 0.0) {
            f = 1.0 / (1.0 - toL[3]);
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                mat[i * 4 + j] = (i == j ? 1.0 : 0.0) - (double)metric * f * toL[i] * toL[j];
            }
        }
        for (i = 0; i < 4; ++i) {
            mat[4 * i + 3] = toL[i];
        }
        for (i = 0; i < 3; ++i) {
            mat[12 + i] = (double)(-metric) * mat[4 * i + 3];
        }
        if (debug && !Rn.equals(mat, oldm = P3.makeTranslationMatrixOld(null, to, metric), 1.0E-7)) {
            Logger log = LoggingSystem.getLogger(P3.class);
            log.log(Level.WARNING, "Incompatible results:");
            log.log(Level.WARNING, "metric is " + metric);
            log.log(Level.WARNING, "To vector is " + Rn.toString(toL));
            log.log(Level.WARNING, "New: \n" + Rn.matrixToString(mat));
            log.log(Level.WARNING, "Old: \n" + Rn.matrixToString(oldm));
        }
        return mat;
    }

    public static boolean isValidTranslationVector(double[] vec, int metric) {
        if (vec.length < 4) {
            return true;
        }
        return (metric != 0 || vec[3] != 0.0) && !Double.isNaN(vec[0]);
    }

    private static double[] makeTranslationMatrixOld(double[] mat, double[] p, int metric) {
        double[] tmp = new double[4];
        double[] foo = new double[3];
        double[] m = mat == null ? new double[16] : mat;
        double[] rot = new double[16];
        double[] mtmp = new double[16];
        double[] point = null;
        if (p.length == 3) {
            point = new double[4];
            System.arraycopy(p, 0, point, 0, 3);
            point[3] = 1.0;
        } else {
            point = p;
        }
        switch (metric) {
            case 0: {
                Rn.setIdentityMatrix(m);
                if (point.length == 4) {
                    Pn.dehomogenize(point, point);
                    if (point[3] == 0.0) {
                        point[3] = 1.0;
                    }
                }
                for (int i = 0; i < 3; ++i) {
                    m[i * 4 + 3] = point[i];
                }
                break;
            }
            case -1: {
                if (Pn.innerProduct(point, point, -1) > 0.0) {
                    double k = (point[3] * point[3] - 1.0E-4) / Rn.innerProduct(point, point, 3);
                    k = Math.sqrt(k);
                    int i = 0;
                    while (i < 3) {
                        int n = i++;
                        point[n] = point[n] * k;
                    }
                }
            }
            case 1: {
                Rn.setIdentityMatrix(mtmp);
                Pn.normalize(tmp, point, metric);
                System.arraycopy(tmp, 0, foo, 0, 3);
                double d = Rn.innerProduct(foo, foo);
                mtmp[11] = Math.sqrt(d);
                mtmp[14] = metric == 1 ? -mtmp[11] : mtmp[11];
                mtmp[10] = mtmp[15] = tmp[3];
                P3.makeRotationMatrix(rot, hzaxis, tmp);
                Rn.conjugateByMatrix(m, mtmp, rot);
                break;
            }
        }
        return m;
    }

    public static double orientation(double[] to, double[] up, double[] upNoRoll) {
        double[] mat = new double[16];
        System.arraycopy(to, 0, mat, 0, 4);
        System.arraycopy(up, 0, mat, 4, 4);
        System.arraycopy(upNoRoll, 0, mat, 8, 4);
        mat[15] = 1.0;
        return Rn.determinant(mat);
    }

    public static double[] orthonormalizeMatrix(double[] dst, double[] m, double tolerance, int metric) {
        int j;
        int i;
        if (dst == null) {
            dst = new double[16];
        }
        if (metric == 0) {
            if (dst == m) {
                return dst;
            }
            System.arraycopy(m, 0, dst, 0, 16);
            return dst;
        }
        double lastentry = m[15];
        double[] diagnosis = P3.getTransformedAbsolute(m, metric);
        boolean mydebug = false;
        if (mydebug) {
            LoggingSystem.getLogger(P3.class).log(Level.FINER, "m =");
            LoggingSystem.getLogger(P3.class).log(Level.FINER, Rn.matrixToString(m));
            LoggingSystem.getLogger(P3.class).log(Level.FINER, "Diagnosis is");
            LoggingSystem.getLogger(P3.class).log(Level.FINER, Rn.matrixToString(diagnosis));
        }
        double[][] basis = new double[4][4];
        double[] Q = Q_LIST[metric + 1];
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                basis[i][j] = m[j * 4 + i];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = i + 1; j < 4; ++j) {
                if (Q[5 * j] == 0.0 || !(Math.abs(diagnosis[4 * i + j]) > tolerance)) continue;
                Pn.projectOntoComplement(basis[j], basis[i], basis[j], metric);
            }
        }
        for (i = 0; i < 4; ++i) {
            if (Q[5 * i] != 0.0) {
                Pn.normalizePlane(basis[i], basis[i], metric);
            }
            for (j = 0; j < 4; ++j) {
                dst[j * 4 + i] = basis[i][j];
            }
        }
        if (metric == 0) {
            for (i = 0; i < 4; ++i) {
                dst[12 + i] = 0.0;
                dst[4 * i + 3] = m[4 * i + 3];
            }
        }
        diagnosis = Rn.subtract(null, Q, Rn.times(null, Rn.transpose(null, dst), Rn.times(null, Q_LIST[metric + 1], dst)));
        if (mydebug) {
            LoggingSystem.getLogger(P3.class).log(Level.FINER, "dst =");
            LoggingSystem.getLogger(P3.class).log(Level.FINER, Rn.matrixToString(dst));
            LoggingSystem.getLogger(P3.class).log(Level.FINER, "Revised is");
            LoggingSystem.getLogger(P3.class).log(Level.FINER, Rn.matrixToString(diagnosis));
        }
        if (dst[15] * lastentry < 0.0) {
            Rn.times(dst, -1.0, dst);
        }
        return dst;
    }

    public static double[] getTransformedAbsolute(double[] m, int metric) {
        double[] diagnosis = Rn.subtract(null, Q_LIST[metric + 1], Rn.times(null, Rn.transpose(null, m), Rn.times(null, Q_LIST[metric + 1], m)));
        return diagnosis;
    }

    public static boolean isometryIsUnstable(double[] matrix, int metric) {
        if (metric != -1) {
            return false;
        }
        double max = Rn.maxNorm(matrix);
        return max > 200.0;
    }

    public static double[] perpendicularBisector(double[] dst, double[] p1, double[] p2, int metric) {
        if (p1.length != 4 || p2.length != 4) {
            throw new IllegalArgumentException("Input points must be homogeneous vectors");
        }
        if (dst == null) {
            dst = new double[4];
        }
        double[] midpoint = new double[4];
        if (metric == 0) {
            Rn.add(midpoint, p1, p2);
            Rn.times(midpoint, 0.5, midpoint);
            Pn.dehomogenize(midpoint, midpoint);
            Rn.subtract(dst, p2, p1);
            dst[3] = -Rn.innerProduct(dst, midpoint, 3);
            return dst;
        }
        Pn.linearInterpolation(midpoint, p1, p2, 0.5, metric);
        double[] polarM = Pn.polarize(null, midpoint, metric);
        double[] pb = P3.lineIntersectPlane(null, p1, p2, polarM);
        Pn.polarize(dst, pb, metric);
        if (Rn.innerProduct(dst, p1) > 0.0) {
            Rn.times(dst, -1.0, dst);
        }
        return dst;
    }

    public static double[] planeFromPoints(double[] planeIn, double[] p1, double[] p2, double[] p3) {
        if (p1.length < 3 || p2.length < 3 || p3.length < 3) {
            throw new IllegalArgumentException("Input points must be homogeneous vectors");
        }
        double[] plane = planeIn == null ? new double[4] : planeIn;
        if (p1.length == 3 || p2.length == 3 || p3.length == 3) {
            plane[0] = p1[1] * (p2[2] - p3[2]) - p1[2] * (p2[1] - p3[1]) + (p2[1] * p3[2] - p2[2] * p3[1]);
            plane[1] = p1[0] * (p2[2] - p3[2]) - p1[2] * (p2[0] - p3[0]) + (p2[0] * p3[2] - p2[2] * p3[0]);
            plane[2] = p1[0] * (p2[1] - p3[1]) - p1[1] * (p2[0] - p3[0]) + (p2[0] * p3[1] - p2[1] * p3[0]);
            plane[3] = p1[0] * (p2[1] * p3[2] - p2[2] * p3[1]) - p1[1] * (p2[0] * p3[2] - p2[2] * p3[0]) + p1[2] * (p2[0] * p3[1] - p2[1] * p3[0]);
        } else {
            plane[0] = p1[1] * (p2[2] * p3[3] - p2[3] * p3[2]) - p1[2] * (p2[1] * p3[3] - p2[3] * p3[1]) + p1[3] * (p2[1] * p3[2] - p2[2] * p3[1]);
            plane[1] = p1[0] * (p2[2] * p3[3] - p2[3] * p3[2]) - p1[2] * (p2[0] * p3[3] - p2[3] * p3[0]) + p1[3] * (p2[0] * p3[2] - p2[2] * p3[0]);
            plane[2] = p1[0] * (p2[1] * p3[3] - p2[3] * p3[1]) - p1[1] * (p2[0] * p3[3] - p2[3] * p3[0]) + p1[3] * (p2[0] * p3[1] - p2[1] * p3[0]);
            plane[3] = p1[0] * (p2[1] * p3[2] - p2[2] * p3[1]) - p1[1] * (p2[0] * p3[2] - p2[2] * p3[0]) + p1[2] * (p2[0] * p3[1] - p2[1] * p3[0]);
        }
        plane[0] = plane[0] * -1.0;
        plane[2] = plane[2] * -1.0;
        return plane;
    }

    public static double[] lineIntersectPlane(double[] dst, double[] p1, double[] p2, double[] plane) {
        if (plane.length != 4) {
            throw new IllegalArgumentException("lineIntersectPlane: plane has invalid dimension");
        }
        if (dst == null || dst.length != 4) {
            dst = new double[4];
        }
        double[] point1 = p1.length == 3 ? Pn.homogenize(null, p1) : p1;
        double[] point2 = p2.length == 3 ? Pn.homogenize(null, p2) : p2;
        double k1 = Rn.innerProduct(point1, plane);
        double k2 = Rn.innerProduct(point2, plane);
        if (k1 == 0.0 && k2 == 0.0) {
            System.arraycopy(p1, 0, dst, 0, Math.min(p1.length, dst.length));
        } else {
            double[] tmp = new double[4];
            Rn.linearCombination(tmp, k2, point1, -k1, point2);
            Pn.dehomogenize(dst, tmp);
        }
        return dst;
    }

    public static double[] pointFromPlanes(double[] point, double[] p1, double[] p2, double[] p3) {
        return P3.planeFromPoints(point, p1, p2, p3);
    }

    public static double[] lineJoinPoint(double[] plane, double[] p1, double[] p2, double[] point) {
        return P3.lineIntersectPlane(plane, p1, p2, point);
    }

    public static boolean areCollinear(double[] p0, double[] p1, double[] p2, double tol) {
        double[] plane = P3.planeFromPoints(null, p0, p1, p2);
        return Rn.equals(plane, zeroVector, tol);
    }

    public static double[] barycentricCoordinates(double[] weights, double[] p0, double[] p1, double[] p) {
        int index0;
        double[] plane = P3.planeFromPoints(null, p0, p1, p);
        if (!Rn.equals(zeroVector, plane, 1.0E-7)) {
            plane = Rn.subtract(null, p0, p1);
            plane[3] = -Rn.innerProduct(plane, p, 3);
            p = P3.lineIntersectPlane(null, p0, p1, plane);
        }
        if (weights == null) {
            weights = new double[2];
        }
        double det = 0.0;
        int index1 = 0;
        int n = Math.min(p0.length, p1.length);
        for (index0 = 0; index0 < n - 1; ++index0) {
            for (index1 = index0 + 1; index1 < n && !(Math.abs(det = p0[index0] * p1[index1] - p0[index1] * p1[index0]) > 1.0E-7); ++index1) {
            }
            if (index1 != n) break;
        }
        if (index0 == n - 1 && index1 == n) {
            return weights;
        }
        double a = p0[index0];
        double b = p1[index0];
        double c = p0[index1];
        double d = p1[index1];
        weights[0] = (d * p[index0] - b * p[index1]) / det;
        weights[1] = (-c * p[index0] + a * p[index1]) / det;
        double[] p2 = Rn.linearCombination(null, weights[0], p0, weights[1], p1);
        return weights;
    }

    public static double affineCoordinate(double[] p1, double[] p2, double[] pw) {
        double[] weights = P3.barycentricCoordinates(null, p1, p2, pw);
        if (weights[1] == 0.0) {
            return 0.0;
        }
        double affCoord = Double.MAX_VALUE;
        if (weights[0] != 0.0) {
            affCoord = weights[1] / weights[0];
        } else if (weights[1] < 0.0) {
            affCoord = -1.7976931348623157E308;
        }
        return affCoord;
    }

    static {
        xaxis = new double[]{1.0, 0.0, 0.0};
        yaxis = new double[]{0.0, 1.0, 0.0};
        zaxis = new double[]{0.0, 0.0, -1.0};
        Q_HYPERBOLIC = Rn.identityMatrix(4);
        P3.Q_HYPERBOLIC[15] = -1.0;
        Q_EUCLIDEAN = Rn.identityMatrix(4);
        P3.Q_EUCLIDEAN[15] = 0.0;
        Q_ELLIPTIC = Rn.identityMatrix(4);
        Q_LIST = new double[3][];
        P3.Q_LIST[0] = Q_HYPERBOLIC;
        P3.Q_LIST[1] = Q_EUCLIDEAN;
        P3.Q_LIST[2] = Q_ELLIPTIC;
        zeroVector = new double[]{0.0, 0.0, 0.0, 0.0};
        originP3 = new double[]{0.0, 0.0, 0.0, 1.0};
    }
}

