/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.math;

import de.jreality.math.Matrix;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;

public final class MatrixBuilder {
    private final Matrix matrix;
    private final int metric;
    private final double[] tmp = new double[16];

    public static MatrixBuilder euclidean(Transformation m) {
        Matrix mat = m != null ? new Matrix(m) : new Matrix();
        return new MatrixBuilder(mat, 0);
    }

    public static MatrixBuilder euclidean(Matrix m) {
        return new MatrixBuilder(m, 0);
    }

    public static MatrixBuilder euclidean() {
        return MatrixBuilder.euclidean(new Matrix());
    }

    public static MatrixBuilder euclidean(SceneGraphComponent cmp) {
        if (cmp.getTransformation() == null) {
            return MatrixBuilder.euclidean();
        }
        return MatrixBuilder.euclidean(cmp.getTransformation());
    }

    public static MatrixBuilder hyperbolic(Transformation m) {
        Matrix mat = m != null ? new Matrix(m) : new Matrix();
        return new MatrixBuilder(mat, -1);
    }

    public static MatrixBuilder hyperbolic(Matrix m) {
        return new MatrixBuilder(m, -1);
    }

    public static MatrixBuilder hyperbolic() {
        return MatrixBuilder.hyperbolic(new Matrix());
    }

    public static MatrixBuilder hyperbolic(SceneGraphComponent cmp) {
        if (cmp.getTransformation() == null) {
            return MatrixBuilder.hyperbolic();
        }
        return MatrixBuilder.hyperbolic(cmp.getTransformation());
    }

    public static MatrixBuilder elliptic(Transformation m) {
        Matrix mat = m != null ? new Matrix(m) : new Matrix();
        return new MatrixBuilder(mat, 1);
    }

    public static MatrixBuilder elliptic(Matrix m) {
        return new MatrixBuilder(m, 1);
    }

    public static MatrixBuilder elliptic() {
        return MatrixBuilder.elliptic(new Matrix());
    }

    public static MatrixBuilder elliptic(SceneGraphComponent cmp) {
        if (cmp.getTransformation() == null) {
            return MatrixBuilder.elliptic();
        }
        return MatrixBuilder.elliptic(cmp.getTransformation());
    }

    public static MatrixBuilder projective(Transformation m) {
        Matrix mat = m != null ? new Matrix(m) : new Matrix();
        return new MatrixBuilder(mat, 2);
    }

    public static MatrixBuilder projective(Matrix m) {
        return new MatrixBuilder(m, 2);
    }

    public static MatrixBuilder projective() {
        return MatrixBuilder.projective(new Matrix());
    }

    public static MatrixBuilder init(Matrix m, int metric) {
        return new MatrixBuilder(m == null ? new Matrix() : m, metric);
    }

    protected MatrixBuilder(Matrix m, int metric) {
        this.matrix = m;
        this.metric = metric;
    }

    public MatrixBuilder rotate(double angle, double axisX, double axisY, double axisZ) {
        return this.rotate(angle, new double[]{axisX, axisY, axisZ});
    }

    public MatrixBuilder rotate(double angle, double[] axis) {
        P3.makeRotationMatrix(this.tmp, axis, angle);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder rotate(double[] p1, double[] p2, double angle) {
        P3.makeRotationMatrix(this.tmp, p1, p2, angle, this.metric);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder rotateX(double angle) {
        P3.makeRotationMatrixX(this.tmp, angle);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder rotateY(double angle) {
        P3.makeRotationMatrixY(this.tmp, angle);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder rotateZ(double angle) {
        P3.makeRotationMatrixZ(this.tmp, angle);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder rotateFromTo(double[] v1, double[] v2) {
        P3.makeRotationMatrix(this.tmp, v1, v2);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder scale(double scale) {
        this.matrix.multiplyOnRight(P3.makeStretchMatrix(this.tmp, scale));
        return this;
    }

    public MatrixBuilder scale(double[] scale) {
        P3.makeStretchMatrix(this.tmp, scale);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder scale(double scaleX, double scaleY, double scaleZ) {
        P3.makeStretchMatrix(this.tmp, new double[]{scaleX, scaleY, scaleZ, 1.0});
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder translate(double[] vector) {
        P3.makeTranslationMatrix(this.tmp, vector, this.metric);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder translate(double[] from, double[] to) {
        P3.makeTranslationMatrix(this.tmp, from, to, this.metric);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder translate(double dx, double dy, double dz) {
        return this.translate(new double[]{dx, dy, dz});
    }

    public MatrixBuilder translateFromTo(double[] p1, double[] p2) {
        P3.makeTranslationMatrix(this.tmp, p1, p2, this.metric);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder reflect(double[] v1, double[] v2, double[] v3) {
        return this.reflect(P3.planeFromPoints(null, v1, v2, v3));
    }

    public MatrixBuilder reflect(double[] plane) {
        P3.makeReflectionMatrix(this.tmp, plane, this.metric);
        this.matrix.multiplyOnRight(this.tmp);
        return this;
    }

    public MatrixBuilder conjugateBy(double[] c) {
        Rn.conjugateByMatrix(this.matrix.getArray(), this.matrix.getArray(), c);
        return this;
    }

    public MatrixBuilder times(Matrix matrix) {
        return this.times(matrix.getArray());
    }

    public MatrixBuilder times(double[] array) {
        this.matrix.multiplyOnRight(array);
        return this;
    }

    public MatrixBuilder reset() {
        this.matrix.assignIdentity();
        return this;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void assignTo(SceneGraphComponent comp) {
        this.matrix.assignTo(comp);
    }

    public void assignTo(Transformation trafo) {
        this.matrix.assignTo(trafo);
    }

    public void assignTo(double[] array) {
        this.matrix.assignTo(array);
    }

    public void assignTo(Matrix m) {
        this.matrix.assignTo(m);
    }

    public double[] getArray() {
        return this.matrix.getArray();
    }
}

