/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.math;

import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.DoubleArray;
import java.io.Serializable;

public class Matrix
implements Serializable {
    public static final double TOLERANCE = 1.0E-7;
    protected double[] matrix;
    protected transient boolean matrixChanged = true;

    public Matrix() {
        this(Rn.setIdentityMatrix(new double[16]));
    }

    public Matrix(Matrix T) {
        this.matrix = new double[16];
        System.arraycopy(T.matrix, 0, this.matrix, 0, 16);
    }

    public Matrix(double[] m) {
        if (m == null) {
            m = Rn.setIdentityMatrix(new double[16]);
        }
        if (m.length != 16) {
            throw new IllegalArgumentException("invalid dimension for 4x4 matrix");
        }
        this.matrix = m;
    }

    public Matrix(double x00, double x01, double x02, double x03, double x10, double x11, double x12, double x13, double x20, double x21, double x22, double x23, double x30, double x31, double x32, double x33) {
        this(new double[]{x00, x01, x02, x03, x10, x11, x12, x13, x20, x21, x22, x23, x30, x31, x32, x33});
    }

    public Matrix(DoubleArray data) {
        this(data.toDoubleArray(null));
    }

    public Matrix(Transformation data) {
        this(data == null ? null : data.getMatrix());
    }

    public static Matrix times(Matrix A, Matrix B) {
        return new Matrix(Rn.times(null, A.matrix, B.matrix));
    }

    public static Matrix sum(Matrix A, Matrix B) {
        return new Matrix(Rn.add(null, A.matrix, B.matrix));
    }

    public static Matrix conjugate(Matrix A, Matrix B) {
        return new Matrix(Rn.conjugateByMatrix(null, A.matrix, B.matrix));
    }

    public void assignFrom(double[] initValue) {
        this.matrixChanged = true;
        System.arraycopy(initValue, 0, this.matrix, 0, 16);
    }

    public void assignFrom(Matrix initValue) {
        this.matrixChanged = true;
        System.arraycopy(initValue.matrix, 0, this.matrix, 0, 16);
    }

    public void assignFrom(DoubleArray data) {
        this.matrixChanged = true;
        if (data.getLength() != 16) {
            throw new IllegalArgumentException("invalid dimension for 4x4 matrix");
        }
        data.toDoubleArray(this.matrix);
    }

    public void assignFrom(Transformation trafo) {
        this.matrixChanged = true;
        trafo.getMatrix(this.matrix);
    }

    public void assignFrom(double x00, double x01, double x02, double x03, double x10, double x11, double x12, double x13, double x20, double x21, double x22, double x23, double x30, double x31, double x32, double x33) {
        this.assignFrom(new double[]{x00, x01, x02, x03, x10, x11, x12, x13, x20, x21, x22, x23, x30, x31, x32, x33});
    }

    public void assignTo(double[] array) {
        System.arraycopy(this.matrix, 0, array, 0, 16);
    }

    public void assignTo(Matrix m) {
        m.assignFrom(this.matrix);
    }

    public void assignTo(Transformation trafo) {
        trafo.setMatrix(this.matrix);
    }

    public void assignTo(SceneGraphComponent comp) {
        Transformation t = comp.getTransformation();
        if (t == null) {
            comp.setTransformation(new Transformation());
        }
        this.assignTo(comp.getTransformation());
    }

    public void assignIdentity() {
        this.matrixChanged = true;
        Rn.setIdentityMatrix(this.matrix);
    }

    public double getDeterminant() {
        return Rn.determinant(this.matrix);
    }

    public double getTrace() {
        return Rn.trace(this.matrix);
    }

    public double getEntry(int row, int column) {
        return this.matrix[4 * row + column];
    }

    public void setEntry(int row, int column, double value) {
        if (this.matrix[4 * row + column] != value) {
            this.matrixChanged = true;
        }
        this.matrix[4 * row + column] = value;
    }

    public double[] getRow(int i) {
        return new double[]{this.matrix[4 * i], this.matrix[4 * i + 1], this.matrix[4 * i + 2], this.matrix[4 * i + 3]};
    }

    public void setRow(int i, double[] v) {
        this.matrixChanged = true;
        this.matrix[4 * i] = v[0];
        this.matrix[4 * i + 1] = v[1];
        this.matrix[4 * i + 2] = v[2];
        this.matrix[4 * i + 3] = v[3];
    }

    public double[] getColumn(int i) {
        return new double[]{this.matrix[i], this.matrix[i + 4], this.matrix[i + 8], this.matrix[i + 12]};
    }

    public void setColumn(int i, double[] v) {
        this.matrixChanged = true;
        this.matrix[i] = v[0];
        this.matrix[i + 4] = v[1];
        this.matrix[i + 8] = v[2];
        this.matrix[i + 12] = v.length > 3 ? v[3] : 0.0;
    }

    public double[] getArray() {
        return this.matrix;
    }

    public double[] writeToArray(double[] aMatrix) {
        if (aMatrix != null && aMatrix.length != 16) {
            throw new IllegalArgumentException("matrix must have length 16");
        }
        double[] copy = aMatrix == null ? new double[16] : aMatrix;
        System.arraycopy(this.matrix, 0, copy, 0, 16);
        return copy;
    }

    public void multiplyOnRight(double[] T) {
        this.matrixChanged = true;
        Rn.times(this.matrix, this.matrix, T);
    }

    public void multiplyOnRight(Matrix T) {
        this.multiplyOnRight(T.matrix);
    }

    public void multiplyOnLeft(double[] T) {
        this.matrixChanged = true;
        Rn.times(this.matrix, T, this.matrix);
    }

    public void multiplyOnLeft(Matrix T) {
        this.multiplyOnLeft(T.matrix);
    }

    public void conjugateBy(Matrix T) {
        this.matrixChanged = true;
        Rn.conjugateByMatrix(this.matrix, this.matrix, T.matrix);
    }

    public void add(Matrix T) {
        this.matrixChanged = true;
        Rn.add(this.matrix, this.matrix, T.matrix);
    }

    public void subtract(Matrix T) {
        this.matrixChanged = true;
        Rn.subtract(this.matrix, this.matrix, T.matrix);
    }

    public void times(double f) {
        this.matrixChanged = true;
        Rn.times(this.matrix, f, this.matrix);
    }

    public Matrix getInverse() {
        return new Matrix(Rn.inverse(null, this.matrix));
    }

    public void invert() {
        this.matrixChanged = true;
        Rn.inverse(this.matrix, this.matrix);
    }

    public Matrix getTranspose() {
        return new Matrix(Rn.transpose(null, this.matrix));
    }

    public void transpose() {
        this.matrixChanged = true;
        Rn.transpose(this.matrix, this.matrix);
    }

    public double[] multiplyVector(double[] v) {
        return Rn.matrixTimesVector(null, this.matrix, v);
    }

    public void transformVector(double[] v) {
        Rn.matrixTimesVector(v, this.matrix, v);
    }

    public boolean equals(Matrix T) {
        return Rn.equals(this.matrix, T.matrix);
    }

    public String toString() {
        return Rn.matrixToString(this.matrix);
    }

    public boolean containsNanOrInfinite() {
        for (double v : this.matrix) {
            if (!Double.isNaN(v) && !Double.isInfinite(v)) continue;
            return true;
        }
        return false;
    }
}

