/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl.shader;

import de.jreality.geometry.GeometryUtility;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.jogl.JOGLRenderingState;
import de.jreality.jogl.shader.AbstractPrimitiveShader;
import de.jreality.jogl.shader.DefaultVertexShader;
import de.jreality.jogl.shader.GlslLoader;
import de.jreality.jogl.shader.PolygonShader;
import de.jreality.jogl.shader.Texture2DLoaderJOGL;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Cylinder;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.Sphere;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.AttributeEntityUtility;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.event.GeometryEvent;
import de.jreality.scene.event.GeometryListener;
import de.jreality.shader.CubeMap;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.GlslProgram;
import de.jreality.shader.ShaderUtility;
import de.jreality.shader.Texture2D;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.WeakHashMap;
import javax.media.opengl.DebugGL;
import javax.media.opengl.GL;

public class GlslPolygonShader
extends AbstractPrimitiveShader
implements PolygonShader {
    private static final int PER_VERTEX = 0;
    private static final int PER_FACE = 1;
    private static final int PER_PART = 2;
    GlslProgram program;
    Texture2D texture2;
    Texture2D texture1;
    Texture2D texture0;
    CubeMap environmentMap;
    private DefaultVertexShader vertexShader = new DefaultVertexShader();
    private boolean smoothShading;
    private int frontBack = 1032;
    private boolean useVertexArrays = true;
    private boolean doNormals4 = false;
    boolean needsChecked = true;
    boolean geometryHasTextureCoordinates;
    boolean doTexture = false;
    private static WeakHashMap<IndexedFaceSet, Boolean> upToDateIFS = new WeakHashMap();

    public void setFromEffectiveAppearance(EffectiveAppearance eap, String name) {
        super.setFromEffectiveAppearance(eap, name);
        eap.getAttribute(ShaderUtility.nameSpace(name, "metric"), 0);
        this.smoothShading = eap.getAttribute(ShaderUtility.nameSpace(name, "smoothShading"), true);
        this.useVertexArrays = eap.getAttribute(ShaderUtility.nameSpace(name, "useVertexArrays"), true);
        if (GlslProgram.hasGlslProgram(eap, name)) {
            Appearance app = new Appearance();
            EffectiveAppearance eap2 = eap.create(app);
            this.program = new GlslProgram(app, eap2, name);
        } else {
            this.program = null;
        }
        this.texture0 = AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eap) ? (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d"), eap) : null;
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[1]"), eap)) {
            System.out.println("Has Texture1");
            this.texture1 = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[1]"), eap);
        } else {
            this.texture1 = null;
        }
        if (AttributeEntityUtility.hasAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[2]"), eap)) {
            System.out.println("Has Texture2");
            this.texture2 = (Texture2D)AttributeEntityUtility.createAttributeEntity(Texture2D.class, ShaderUtility.nameSpace(name, "texture2d[2]"), eap);
        } else {
            this.texture2 = null;
        }
        this.environmentMap = AttributeEntityUtility.hasAttributeEntity(CubeMap.class, ShaderUtility.nameSpace(name, "reflectionMap"), eap) ? (CubeMap)AttributeEntityUtility.createAttributeEntity(CubeMap.class, ShaderUtility.nameSpace(name, "reflectionMap"), eap) : null;
        this.vertexShader.setFromEffectiveAppearance(eap, name);
        this.needsChecked = true;
        this.geometryHasTextureCoordinates = false;
    }

    public void render(JOGLRenderingState jrs) {
        Geometry g;
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        if (this.smoothShading) {
            gl.glShadeModel(7425);
        } else {
            gl.glShadeModel(7424);
        }
        jrs.smoothShading = this.smoothShading;
        this.vertexShader.render(jrs);
        this.doTexture = false;
        if (this.texture0 != null) {
            Geometry curgeom = jr.renderingState.currentGeometry;
            if (this.needsChecked && curgeom != null && curgeom instanceof IndexedFaceSet && ((IndexedFaceSet)curgeom).getVertexAttributes(Attribute.TEXTURE_COORDINATES) != null) {
                this.geometryHasTextureCoordinates = true;
                this.needsChecked = false;
            }
            if (this.geometryHasTextureCoordinates) {
                gl.glActiveTexture(33984);
                Texture2DLoaderJOGL.render(jr.globalGL, this.texture0);
                gl.glEnable(3553);
            }
        }
        if (this.program != null && this.program.getSource().getUniformParameter("doTexture") != null) {
            this.program.setUniform("doTexture", this.doTexture);
            System.err.println("Setting do texture = " + this.doTexture);
        }
        if (this.texture1 != null) {
            gl.glActiveTexture(33985);
            Texture2DLoaderJOGL.render(jr.globalGL, this.texture1);
            gl.glEnable(3553);
        }
        if (this.texture2 != null) {
            gl.glActiveTexture(33986);
            Texture2DLoaderJOGL.render(jr.globalGL, this.texture2);
            gl.glEnable(3553);
        }
        if (this.environmentMap != null) {
            gl.glActiveTexture(33987);
            Texture2DLoaderJOGL.render(jr, this.environmentMap);
            gl.glEnable(34067);
        }
        if (this.program != null) {
            if (this.program.getSource().getUniformParameter("lightingEnabled") != null) {
                this.program.setUniform("lightingEnabled", jrs.lighting);
                System.err.println("setting lighting to " + jrs.lighting);
            }
            if (this.program.getSource().getUniformParameter("transparency") != null) {
                this.program.setUniform("transparency", jrs.transparencyEnabled ? jrs.diffuseColor[3] : 0.0f);
            }
            this.doNormals4 = this.program.getSource().getAttribute("normals4") != null;
            GlslLoader.render(this.program, jr);
        }
        if ((g = jrs.currentGeometry) != null) {
            if (g instanceof Sphere || g instanceof Cylinder) {
                int i = 3;
                int dlist = g instanceof Sphere ? jr.renderingState.getSphereDisplayLists(i) : jr.renderingState.getCylinderDisplayLists(i);
                jr.globalGL.glCallList(dlist);
            } else if (g instanceof IndexedFaceSet) {
                if (this.useVertexArrays) {
                    GlslPolygonShader.drawFaces(jr, (IndexedFaceSet)g, this.smoothShading, jrs.diffuseColor[3], this.doNormals4);
                } else {
                    if (!GlslPolygonShader.upToDate((IndexedFaceSet)g, this.smoothShading) || this.dList == -1) {
                        if (this.dList != -1) {
                            jr.globalGL.glDeleteLists(this.dList, 1);
                        }
                        this.dList = jr.globalGL.glGenLists(1);
                        jr.globalGL.glNewList(this.dList, 4864);
                        JOGLRendererHelper.drawFaces(jr, (IndexedFaceSet)g);
                        jr.globalGL.glEndList();
                    }
                    jr.globalGL.glCallList(this.dList);
                }
            }
        }
    }

    public void postRender(JOGLRenderingState jrs) {
        JOGLRenderer jr = jrs.renderer;
        GL gl = jr.globalGL;
        if (this.program != null) {
            GlslLoader.postRender(this.program, jr);
        }
        if (this.texture0 != null) {
            gl.glActiveTexture(33984);
            gl.glDisable(3553);
        }
        if (this.texture1 != null) {
            gl.glActiveTexture(33985);
            gl.glDisable(3553);
        }
        if (this.texture2 != null) {
            gl.glActiveTexture(33986);
            gl.glDisable(3553);
        }
        if (this.environmentMap != null) {
            gl.glActiveTexture(33986);
            gl.glDisable(34067);
            gl.glDisable(3168);
            gl.glDisable(3169);
            gl.glDisable(3170);
        }
    }

    public void setFrontBack(int f) {
        this.frontBack = f;
    }

    public void setProgram(GlslProgram program) {
        this.program = program;
    }

    public static void drawFaces(JOGLRenderer jr, IndexedFaceSet sg, boolean smooth, double alpha, boolean doNormals4) {
        if (sg.getNumFaces() == 0) {
            return;
        }
        GL gl = jr.globalGL;
        int colorBind = -1;
        int colorLength = 3;
        DataList vertices = sg.getVertexAttributes(Attribute.COORDINATES);
        DataList vertexNormals = sg.getVertexAttributes(Attribute.NORMALS);
        DataList faceNormals = sg.getFaceAttributes(Attribute.NORMALS);
        DataList vertexColors = sg.getVertexAttributes(Attribute.COLORS);
        DataList faceColors = sg.getFaceAttributes(Attribute.COLORS);
        DataList texCoords = sg.getVertexAttributes(Attribute.TEXTURE_COORDINATES);
        DataList lightMapCoords = sg.getVertexAttributes(Attribute.attributeForName("lightmap coordinates"));
        vertices = sg.getVertexAttributes(Attribute.COORDINATES);
        int vertexLength = GeometryUtility.getVectorLength(vertices);
        if (vertexColors != null && smooth) {
            colorBind = 0;
            colorLength = GeometryUtility.getVectorLength(vertexColors);
        } else if (faceColors != null) {
            colorBind = 1;
            colorLength = GeometryUtility.getVectorLength(faceColors);
        } else {
            colorBind = 2;
        }
        if (colorBind != 2 && jr.renderingState.frontBack != 1032) {
            gl.glEnable(2903);
            gl.glColorMaterial(1032, 4609);
            jr.renderingState.frontBack = 1032;
        }
        int normalBind = vertexNormals != null && smooth ? 0 : (faceNormals != null ? 1 : 2);
        GlslPolygonShader.renderFaces(sg, alpha, gl, false, colorBind, normalBind, colorLength, vertices, vertexNormals, faceNormals, vertexColors, faceColors, texCoords, lightMapCoords, vertexLength, smooth, doNormals4);
    }

    public static DataList correctNormals(DataList n) {
        if (n != null && n.toDoubleArrayArray().item(0).size() == 4) {
            double[][] norms = n.toDoubleArrayArray(null);
            double[][] norms3 = new double[norms.length][3];
            for (int i = 0; i < norms.length; ++i) {
                Pn.dehomogenize(norms3[i], norms[i]);
                if (norms[i][3] < 0.0) {
                    Rn.times(norms3[i], -1.0, norms3[i]);
                }
                if (norms[i][3] != 0.0) continue;
                Rn.times(norms3[i], 1.0E7, norms3[i]);
            }
            return StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(norms3);
        }
        return n;
    }

    public static DataList correctNormals4(DataList n) {
        if (n != null && n.toDoubleArrayArray().item(0).size() == 3) {
            double[][] norms = n.toDoubleArrayArray(null);
            double[][] norms4 = new double[norms.length][4];
            for (int i = 0; i < norms.length; ++i) {
                System.arraycopy(norms[i], 0, norms4[i], 0, 3);
                norms4[i][3] = 1.0E-7;
            }
            return StorageModel.DOUBLE_ARRAY.array(4).createReadOnly(norms4);
        }
        return n;
    }

    private static void renderFaces(IndexedFaceSet sg, double alpha, GL gl, boolean pickMode, int colorBind, int normalBind, int colorLength, DataList vertices, DataList vertexNormals, DataList faceNormals, DataList vertexColors, DataList faceColors, DataList texCoords, DataList lightMapCoords, int vertexLength, boolean smooth, boolean doNormals4) {
        boolean renderInlined;
        boolean faceN = normalBind == 1;
        boolean faceC = colorBind == 1;
        boolean faceT = false;
        Attribute TANGENTS = Attribute.attributeForName("TANGENTS");
        DataList tanCoords = null;
        if (doNormals4) {
            tanCoords = faceN ? GlslPolygonShader.correctNormals4(faceNormals) : GlslPolygonShader.correctNormals4(vertexNormals);
            faceT = faceN;
            vertexNormals = null;
            faceNormals = null;
        } else if (faceN) {
            faceNormals = GlslPolygonShader.correctNormals(faceNormals);
        } else {
            vertexNormals = GlslPolygonShader.correctNormals(vertexNormals);
        }
        if (tanCoords == null) {
            tanCoords = sg.getVertexAttributes(TANGENTS);
        }
        boolean bl = renderInlined = !(normalBind != 0 && !faceN || colorBind != 0 && colorBind != 2 && !faceC);
        if (renderInlined) {
            gl = new DebugGL(gl);
            int triagCnt = 0;
            IntArrayArray faces = sg.getFaceAttributes(Attribute.INDICES).toIntArrayArray();
            int numFaces = faces.getLength();
            triagCnt = 2 * numFaces;
            boolean hasColors = vertexColors != null || faceColors != null;
            IntBuffer indexBuffer = null;
            boolean inlineI = false;
            if (inlineI) {
                indexBuffer = BufferCache.index(sg, triagCnt);
            }
            FloatBuffer vertexBuffer = null;
            vertexBuffer = BufferCache.vertex(sg, triagCnt, vertexLength);
            DoubleArrayArray tc = null;
            int texLength = 0;
            boolean inlineTex = texCoords != null;
            FloatBuffer texBuffer = null;
            if (inlineTex) {
                texBuffer = BufferCache.texCoord(sg, triagCnt);
                tc = texCoords.toDoubleArrayArray();
                texLength = tc.getLengthAt(0);
            }
            boolean inlineTan = tanCoords != null;
            FloatBuffer tanBuffer = null;
            if (inlineTan) {
                tanBuffer = BufferCache.tangent(sg, triagCnt, 4);
            }
            boolean inlineN = !doNormals4;
            FloatBuffer normalBuffer = null;
            if (inlineN) {
                normalBuffer = BufferCache.normal(sg, triagCnt);
            }
            boolean inlineC = hasColors;
            FloatBuffer colorBuffer = null;
            if (inlineC) {
                colorBuffer = BufferCache.color(sg, triagCnt, colorLength);
            }
            if (!GlslPolygonShader.upToDate(sg, smooth)) {
                double[] tmpV = new double[vertexLength];
                double[] tmpTex = null;
                if (inlineTex) {
                    tmpTex = new double[texLength];
                }
                double[] tmpTan = new double[4];
                double[] tmpN = new double[3];
                double[] tmpC = new double[colorLength];
                float[] floatArray = new float[3];
                float[] float2Array = new float[2];
                DoubleArrayArray verts = vertices.toDoubleArrayArray();
                tc = inlineTex ? tc : null;
                DoubleArrayArray t = inlineTan ? tanCoords.toDoubleArrayArray() : null;
                DoubleArrayArray norms = null;
                if (!doNormals4) {
                    DoubleArrayArray doubleArrayArray = norms = faceN ? faceNormals.toDoubleArrayArray() : vertexNormals.toDoubleArrayArray();
                }
                DoubleArrayArray cols = inlineC ? (faceC ? faceColors.toDoubleArrayArray() : vertexColors.toDoubleArrayArray()) : null;
                for (int i = 0; i < numFaces; ++i) {
                    IntArray face = faces.getValueAt(i);
                    for (int j = 0; j < face.getLength() - 2; ++j) {
                        int i1 = face.getValueAt(0);
                        int i2 = face.getValueAt(j + 1);
                        int i3 = face.getValueAt(j + 2);
                        if (inlineI) {
                            indexBuffer.put(i1);
                            indexBuffer.put(i2);
                            indexBuffer.put(i3);
                        }
                        DoubleArray da = verts.getValueAt(i1);
                        da.toDoubleArray(tmpV);
                        floatArray[0] = (float)tmpV[0];
                        floatArray[1] = (float)tmpV[1];
                        floatArray[2] = (float)tmpV[2];
                        try {
                            vertexBuffer.put(floatArray);
                        }
                        catch (Exception e) {
                            System.out.println(vertexBuffer);
                            System.out.println("triags=" + triagCnt);
                        }
                        da = verts.getValueAt(i2);
                        da.toDoubleArray(tmpV);
                        floatArray[0] = (float)tmpV[0];
                        floatArray[1] = (float)tmpV[1];
                        floatArray[2] = (float)tmpV[2];
                        vertexBuffer.put(floatArray);
                        da = verts.getValueAt(i3);
                        da.toDoubleArray(tmpV);
                        floatArray[0] = (float)tmpV[0];
                        floatArray[1] = (float)tmpV[1];
                        floatArray[2] = (float)tmpV[2];
                        vertexBuffer.put(floatArray);
                        if (inlineTex) {
                            da = tc.getValueAt(i1);
                            da.toDoubleArray(tmpTex);
                            float2Array[0] = (float)tmpTex[0];
                            float2Array[1] = (float)tmpTex[1];
                            texBuffer.put(float2Array);
                            da = tc.getValueAt(i2);
                            da.toDoubleArray(tmpTex);
                            float2Array[0] = (float)tmpTex[0];
                            float2Array[1] = (float)tmpTex[1];
                            texBuffer.put(float2Array);
                            da = tc.getValueAt(i3);
                            da.toDoubleArray(tmpTex);
                            float2Array[0] = (float)tmpTex[0];
                            float2Array[1] = (float)tmpTex[1];
                            texBuffer.put(float2Array);
                        }
                        if (inlineTan) {
                            da = t.getValueAt(faceT ? i : i1);
                            da.toDoubleArray(tmpTan);
                            floatArray[0] = (float)tmpTan[0];
                            floatArray[1] = (float)tmpTan[1];
                            floatArray[2] = (float)tmpTan[2];
                            tanBuffer.put(floatArray);
                            if (!faceT) {
                                da = t.getValueAt(i2);
                                da.toDoubleArray(tmpTan);
                                floatArray[0] = (float)tmpTan[0];
                                floatArray[1] = (float)tmpTan[1];
                                floatArray[2] = (float)tmpTan[2];
                            }
                            tanBuffer.put(floatArray);
                            if (!faceT) {
                                da = t.getValueAt(i3);
                                da.toDoubleArray(tmpTan);
                                floatArray[0] = (float)tmpTan[0];
                                floatArray[1] = (float)tmpTan[1];
                                floatArray[2] = (float)tmpTan[2];
                            }
                            tanBuffer.put(floatArray);
                        }
                        if (inlineN) {
                            da = norms.getValueAt(faceN ? i : i1);
                            da.toDoubleArray(tmpN);
                            floatArray[0] = (float)tmpN[0];
                            floatArray[1] = (float)tmpN[1];
                            floatArray[2] = (float)tmpN[2];
                            normalBuffer.put(floatArray);
                            if (!faceN) {
                                da = norms.getValueAt(i2);
                                da.toDoubleArray(tmpN);
                                floatArray[0] = (float)tmpN[0];
                                floatArray[1] = (float)tmpN[1];
                                floatArray[2] = (float)tmpN[2];
                            }
                            normalBuffer.put(floatArray);
                            if (!faceN) {
                                da = norms.getValueAt(i3);
                                da.toDoubleArray(tmpN);
                                floatArray[0] = (float)tmpN[0];
                                floatArray[1] = (float)tmpN[1];
                                floatArray[2] = (float)tmpN[2];
                            }
                            normalBuffer.put(floatArray);
                        }
                        if (!inlineC) continue;
                        da = cols.getValueAt(faceC ? i : i1);
                        da.toDoubleArray(tmpC);
                        floatArray[0] = (float)tmpC[0];
                        floatArray[1] = (float)tmpC[1];
                        floatArray[2] = (float)tmpC[2];
                        colorBuffer.put(floatArray);
                        if (!faceC) {
                            da = cols.getValueAt(i2);
                            da.toDoubleArray(tmpC);
                            floatArray[0] = (float)tmpC[0];
                            floatArray[1] = (float)tmpC[1];
                            floatArray[2] = (float)tmpC[2];
                        }
                        colorBuffer.put(floatArray);
                        if (!faceC) {
                            da = cols.getValueAt(i3);
                            da.toDoubleArray(tmpC);
                            floatArray[0] = (float)tmpC[0];
                            floatArray[1] = (float)tmpC[1];
                            floatArray[2] = (float)tmpC[2];
                        }
                        colorBuffer.put(floatArray);
                    }
                }
                tmpC = null;
                tmpN = null;
                tmpV = null;
                tmpTex = null;
                System.gc();
            }
            vertexBuffer.rewind();
            if (!doNormals4) {
                normalBuffer.rewind();
            }
            gl.glEnableClientState(32884);
            if (!doNormals4) {
                gl.glEnableClientState(32885);
            }
            gl.glVertexPointer(vertexLength, 5126, 0, (Buffer)vertexBuffer);
            if (!doNormals4) {
                gl.glNormalPointer(5126, 0, (Buffer)normalBuffer);
            }
            if (hasColors) {
                gl.glEnableClientState(32886);
                colorBuffer.rewind();
                gl.glColorPointer(colorLength, 5126, 0, (Buffer)colorBuffer);
            }
            if (texCoords != null) {
                gl.glClientActiveTexture(33984);
                gl.glEnableClientState(32888);
                texBuffer.rewind();
                gl.glTexCoordPointer(texLength, 5126, 0, (Buffer)texBuffer);
            }
            if (tanCoords != null) {
                tanBuffer.rewind();
                gl.glClientActiveTexture(33985);
                gl.glEnableClientState(32888);
                gl.glTexCoordPointer(4, 5126, 0, (Buffer)tanBuffer);
            }
            if (inlineI) {
                indexBuffer.rewind();
                gl.glDrawElements(4, indexBuffer.remaining(), 5125, (Buffer)indexBuffer);
            } else {
                gl.glDrawArrays(4, 0, triagCnt * 3);
            }
            gl.glDisableClientState(32884);
            if (!doNormals4) {
                gl.glDisableClientState(32885);
            }
            if (texCoords != null) {
                gl.glClientActiveTexture(33984);
                gl.glDisableClientState(32888);
            }
            if (hasColors) {
                gl.glDisableClientState(32886);
            }
            if (tanCoords != null) {
                gl.glClientActiveTexture(33985);
                gl.glDisableClientState(32888);
            }
        } else {
            System.out.println("GlslPolygonShader inlined: ??");
        }
    }

    private static boolean upToDate(final IndexedFaceSet sg, boolean smooth) {
        if (upToDateIFS.get(sg) == Boolean.valueOf(smooth)) {
            return true;
        }
        upToDateIFS.put(sg, smooth);
        sg.addGeometryListener(new GeometryListener(){

            public void geometryChanged(GeometryEvent ev) {
                if (!ev.getChangedVertexAttributes().isEmpty() || !ev.getChangedFaceAttributes().isEmpty()) {
                    upToDateIFS.remove(sg);
                    sg.removeGeometryListener(this);
                }
            }
        });
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BufferCache {
        static WeakHashMap<IndexedFaceSet, ByteBuffer> vertexBuffers = new WeakHashMap();
        static WeakHashMap<IndexedFaceSet, ByteBuffer> texCoordBuffers = new WeakHashMap();
        static WeakHashMap<IndexedFaceSet, ByteBuffer> tangentBuffers = new WeakHashMap();
        static WeakHashMap<IndexedFaceSet, ByteBuffer> normalBuffers = new WeakHashMap();
        static WeakHashMap<IndexedFaceSet, ByteBuffer> colorBuffers = new WeakHashMap();
        static WeakHashMap<IndexedFaceSet, ByteBuffer> indexBuffers = new WeakHashMap();

        private BufferCache() {
        }

        static FloatBuffer vertex(IndexedFaceSet ifs, int numTris, int vertexLen) {
            return BufferCache.get(ifs, vertexBuffers, numTris * 3 * vertexLen * 4).asFloatBuffer();
        }

        static FloatBuffer texCoord(IndexedFaceSet ifs, int numTris) {
            return BufferCache.get(ifs, texCoordBuffers, numTris * 3 * 2 * 4).asFloatBuffer();
        }

        static FloatBuffer tangent(IndexedFaceSet ifs, int numTris, int tangentLen) {
            return BufferCache.get(ifs, tangentBuffers, numTris * 3 * tangentLen * 4).asFloatBuffer();
        }

        static FloatBuffer normal(IndexedFaceSet ifs, int numTris) {
            return BufferCache.get(ifs, normalBuffers, numTris * 3 * 3 * 4).asFloatBuffer();
        }

        static FloatBuffer color(IndexedFaceSet ifs, int numTris, int colorLen) {
            return BufferCache.get(ifs, colorBuffers, numTris * 3 * colorLen * 4).asFloatBuffer();
        }

        static IntBuffer index(IndexedFaceSet ifs, int numTris) {
            return BufferCache.get(ifs, indexBuffers, numTris * 3 * 4).asIntBuffer();
        }

        private static ByteBuffer get(IndexedFaceSet ifs, WeakHashMap<IndexedFaceSet, ByteBuffer> cache, int capacity) {
            ByteBuffer bb = cache.get(ifs);
            if (bb == null || bb.capacity() < capacity) {
                if (bb != null) {
                    bb.clear();
                    System.gc();
                }
                bb = ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
                cache.put(ifs, bb);
            }
            bb.position(0).limit(capacity);
            return bb;
        }
    }
}

