/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.JOGLCylinderUtility;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLSphereHelper;
import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.pick.Graphics3D;
import javax.media.opengl.GL;

public class JOGLRenderingState {
    public static boolean useOldTransparency = false;
    public JOGLRenderer renderer;
    public Geometry currentGeometry = null;
    public boolean smoothShading = true;
    public boolean lighting = true;
    public boolean backFaceCullingEnabled = false;
    public boolean zbufferEnabled = true;
    public boolean flipped = false;
    public boolean transparencyEnabled = false;
    public boolean fogEnabled;
    public boolean localLightModel = false;
    public boolean separateSpecularColor = false;
    public boolean ignoreAlpha0 = true;
    public boolean renderGeometryOnly = false;
    public boolean insideDisplayList = false;
    public boolean componentDisplayLists = false;
    public boolean currentPickMode = false;
    public boolean useDisplayLists = true;
    public boolean clearColorBuffer = true;
    public boolean useVertexColors = false;
    public boolean normals4d = false;
    public boolean shadeGeometry = true;
    public boolean oneTexture2DPerImage = false;
    public int activeTexture;
    public int frontBack = 1032;
    public int numLights = 0;
    public int currentClippingPlane = 0;
    public int currentEye = 0;
    public int clearBufferBits = 16640;
    public int colorMask = 15;
    public int currentMetric = 0;
    public int texUnitCount = 0;
    public int polygonCount = 0;
    public int stereoType = 0;
    protected int[] sphereDisplayLists = null;
    protected int[] cylinderDisplayLists = null;
    public double pointSize = 1.0;
    public double lineWidth = 1.0;
    public double levelOfDetail;
    public double depthFudgeFactor;
    public double currentAlpha = 1.0;
    public double[] cameraToWorld = Rn.identityMatrix(4);
    public double[] worldToCamera = Rn.identityMatrix(4);
    public double[] cameraToNDC = Rn.identityMatrix(4);
    public float[][] subWindowTform = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}};
    public float[] diffuseColor = new float[4];
    public SceneGraphPath currentPath = new SceneGraphPath();
    public Graphics3D context;

    public JOGLRenderingState(JOGLRenderer jr) {
        this.renderer = jr;
    }

    public static boolean equals(float[] a, float[] b, float tol) {
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(a[i] - b[i]) > tol)) continue;
            return false;
        }
        return true;
    }

    public void initializeGLState() {
        GL gl = this.renderer.globalGL;
        gl.glDepthMask(true);
        gl.glDisable(3042);
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        gl.glEnable(2929);
        gl.glDepthFunc(515);
        gl.glEnable(3008);
        gl.glAlphaFunc(516, 0.0f);
        gl.glClearDepth(1.0);
        gl.glEnable(2977);
        gl.glEnable(32925);
        gl.glEnable(34371);
        gl.glLightModeli(2898, 1);
        float[] white = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        gl.glLightModelfv(2899, white, 0);
        float[] amb = new float[]{0.0f, 0.0f, 0.0f};
        float[] spec = new float[]{0.5f, 0.5f, 0.5f};
        gl.glMaterialfv(this.frontBack, 4608, amb, 0);
        gl.glMaterialfv(this.frontBack, 4609, new float[]{1.0f, 0.0f, 0.0f}, 0);
        gl.glMaterialfv(this.frontBack, 4610, spec, 0);
        gl.glMaterialf(this.frontBack, 5633, 60.0f);
        gl.glEnable(2903);
        gl.glColorMaterial(this.frontBack, 4609);
        if (this.smoothShading) {
            gl.glShadeModel(7425);
        } else {
            gl.glShadeModel(7424);
        }
        if (this.flipped) {
            gl.glFrontFace(2304);
        } else {
            gl.glFrontFace(2305);
        }
    }

    public int getCylinderDisplayLists(int i) {
        if (this.cylinderDisplayLists == null) {
            this.cylinderDisplayLists = JOGLCylinderUtility.getCylinderDLists(this.renderer);
        }
        return this.cylinderDisplayLists[i];
    }

    public int getSphereDisplayLists(int i) {
        if (this.sphereDisplayLists == null) {
            this.sphereDisplayLists = JOGLSphereHelper.getSphereDLists(this.renderer);
        }
        return this.sphereDisplayLists[i];
    }

    public boolean isClearColorBuffer() {
        return this.clearColorBuffer;
    }

    public void setClearColorBuffer(boolean clearColorBuffer) {
        this.clearColorBuffer = clearColorBuffer;
    }
}

