/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.geometry.GeometryUtility;
import de.jreality.jogl.JOGLPeerComponent;
import de.jreality.jogl.JOGLPeerNode;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.JOGLRendererHelper;
import de.jreality.jogl.shader.DefaultGeometryShader;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Cylinder;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.Sphere;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.event.GeometryEvent;
import de.jreality.scene.event.GeometryListener;
import java.util.logging.Level;

public class JOGLPeerGeometry
extends JOGLPeerNode
implements GeometryListener {
    public Geometry originalGeometry;
    IndexedFaceSet ifs;
    IndexedLineSet ils;
    PointSet ps;
    int refCount = 0;
    int metric = 0;
    boolean isSurface = false;
    boolean hasPointLabels = false;
    boolean hasEdgeLabels = false;
    boolean hasFaceLabels = false;
    boolean forceRender = false;
    boolean displayListsDirty = true;
    boolean localClippingPlane = false;

    public JOGLPeerGeometry(Geometry g, JOGLRenderer jr) {
        super(jr);
        this.originalGeometry = g;
        this.name = "JOGLPeer:" + g.getName();
        this.ifs = null;
        this.ils = null;
        this.ps = null;
        if (g instanceof IndexedFaceSet) {
            this.ifs = (IndexedFaceSet)g;
        }
        if (g instanceof IndexedLineSet) {
            this.ils = (IndexedLineSet)g;
        }
        if (g instanceof PointSet) {
            this.ps = (PointSet)g;
        }
        this.updateLabelState();
        this.originalGeometry.addGeometryListener(this);
        if (this.originalGeometry instanceof ClippingPlane && ((ClippingPlane)this.originalGeometry).isLocal()) {
            this.localClippingPlane = true;
        }
        if (this.ifs != null || g instanceof Sphere || g instanceof Cylinder) {
            this.isSurface = true;
        }
    }

    public void dispose() {
        --this.refCount;
        if (this.refCount < 0) {
            theLog.log(Level.WARNING, "Negative reference count!");
        }
        if (this.refCount == 0) {
            theLog.log(Level.FINER, "Geometry is no longer referenced");
            this.originalGeometry.removeGeometryListener(this);
            this.jr.geometryGB.geometries.remove(this.originalGeometry);
        }
    }

    public void render(JOGLPeerComponent jpc) {
        DefaultGeometryShader geometryShader = jpc.geometryShader;
        if (geometryShader == null) {
            return;
        }
        this.jr.renderingState.currentGeometry = this.originalGeometry;
        this.displayListsDirty = false;
        if (geometryShader.isVertexDraw() && this.ps != null) {
            geometryShader.pointShader.render(this.jr.renderingState);
            geometryShader.pointShader.postRender(this.jr.renderingState);
        }
        if (geometryShader.isEdgeDraw() && this.ils != null) {
            geometryShader.lineShader.render(this.jr.renderingState);
            geometryShader.lineShader.postRender(this.jr.renderingState);
        }
        if (geometryShader.isFaceDraw() && this.isSurface) {
            geometryShader.polygonShader.render(this.jr.renderingState);
            geometryShader.polygonShader.postRender(this.jr.renderingState);
        }
        if (geometryShader.isVertexDraw() && this.hasPointLabels) {
            JOGLRendererHelper.drawPointLabels(this.jr, this.ps, geometryShader.pointShader.getTextShader());
        }
        if (geometryShader.isEdgeDraw() && this.hasEdgeLabels) {
            JOGLRendererHelper.drawEdgeLabels(this.jr, this.ils, jpc.geometryShader.lineShader.getTextShader());
        }
        if (geometryShader.isFaceDraw() && this.hasFaceLabels) {
            JOGLRendererHelper.drawFaceLabels(this.jr, this.ifs, jpc.geometryShader.polygonShader.getTextShader());
        }
    }

    public void geometryChanged(GeometryEvent ev) {
        Object foo;
        this.displayListsDirty = true;
        if (ev.getChangedGeometryAttributes().size() > 0 && (foo = this.originalGeometry.getGeometryAttributes(GeometryUtility.METRIC)) != null) {
            Integer foo2 = (Integer)foo;
            this.metric = foo2;
        }
        this.updateLabelState();
    }

    private void updateLabelState() {
        if (this.ps != null) {
            boolean bl = this.hasPointLabels = this.ps.getVertexAttributes(Attribute.LABELS) != null;
        }
        if (this.ils != null) {
            boolean bl = this.hasEdgeLabels = this.ils.getEdgeAttributes(Attribute.LABELS) != null;
        }
        if (this.ifs != null) {
            this.hasFaceLabels = this.ifs.getFaceAttributes(Attribute.LABELS) != null;
        }
    }
}

