/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.ConstructPeerGraphVisitor;
import de.jreality.jogl.GoBetween;
import de.jreality.jogl.JOGLPeerComponent;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Secure;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.swing.JPopupMenu;

public class JOGLConfiguration {
    public static Logger theLog;
    static boolean debugGL;
    static boolean sharedContexts;
    static boolean isLinux;
    static boolean multiSample;
    public static boolean hasBlendFuncSeparate;
    public static boolean quadBufferedStereo;
    static JOGLConfiguration ss;
    static Class<? extends GoBetween> goBetweenClass;
    static Class<? extends JOGLPeerComponent> peerClass;

    private JOGLConfiguration() {
        theLog = LoggingSystem.getLogger(this);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        try {
            boolean copycat;
            System.setProperty("sun.awt.noerasebackground", "true");
            String foo = Secure.getProperty("jreality.jogl.debugGL");
            if (foo != null) {
                debugGL = !foo.equals("false");
            }
            if ((foo = Secure.getProperty("jreality.jogl.loggingLevel")) != null) {
                Level level = Level.INFO;
                if (foo.indexOf("finest") != -1) {
                    level = Level.FINEST;
                } else if (foo.indexOf("finer") != -1) {
                    level = Level.FINER;
                } else if (foo.indexOf("fine") != -1) {
                    level = Level.FINE;
                } else if (foo.indexOf("info") != -1) {
                    level = Level.INFO;
                }
                theLog.setLevel(level);
            }
            if ((foo = Secure.getProperty("os.name")) != null && foo.indexOf("Linux") != -1) {
                isLinux = true;
            }
            if ((foo = Secure.getProperty("jreality.jogl.sharedContexts")) != null && foo.indexOf("true") != -1) {
                sharedContexts = true;
            }
            if (sharedContexts) {
                theLog.log(Level.INFO, "Using shared contexts: " + sharedContexts);
            }
            if (quadBufferedStereo = "true".equals(Secure.getProperty("jreality.jogl.quadBufferedStereo"))) {
                Secure.setProperty("sun.java2d.noddraw", "true");
            }
            if ((foo = Secure.getProperty("jogl.hasBlendFuncSeparate")) != null && foo.indexOf("false") != -1) {
                hasBlendFuncSeparate = false;
            }
            if (copycat = "true".equals(Secure.getProperty("discreteGroup.copycat"))) {
                try {
                    peerClass = Class.forName("de.jreality.jogl.MatrixListJOGLPeerComponent");
                    ConstructPeerGraphVisitor.setPeerClass(peerClass);
                    System.err.println("Got peer class " + peerClass);
                    goBetweenClass = Class.forName("de.jreality.jogl.MatrixListGoBetween");
                    GoBetween.setGoBetweenClass(goBetweenClass);
                    System.err.println("Got go betwen class " + goBetweenClass);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SecurityException se) {
            theLog.log(Level.WARNING, "Security exception in setting configuration options", se);
        }
    }

    public static Logger getLogger() {
        return theLog;
    }

    public static void glBlendFunc(GL gl, boolean useSrcAlphaOnly) {
        if (hasBlendFuncSeparate) {
            if (useSrcAlphaOnly) {
                gl.glBlendFuncSeparate(770, 770, 1, 771);
            } else {
                gl.glBlendFuncSeparate(770, 771, 1, 771);
            }
        } else if (useSrcAlphaOnly) {
            gl.glBlendFunc(770, 770);
        } else {
            gl.glBlendFunc(770, 771);
        }
    }

    static {
        debugGL = false;
        sharedContexts = true;
        isLinux = false;
        multiSample = true;
        hasBlendFuncSeparate = true;
        quadBufferedStereo = false;
        ss = new JOGLConfiguration();
        goBetweenClass = null;
        peerClass = null;
    }
}

