/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.AbstractViewer;
import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.ViewerAwt;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.util.SceneGraphUtility;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import java.util.logging.Level;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLJPanel;
import javax.media.opengl.GLPbuffer;

public class GLJPanelViewer
extends ViewerAwt {
    GLJPanel panel;
    GLPbuffer sharedPBuffer;
    boolean opaque = false;
    transient boolean preRender = true;
    transient Graphics2D g2d;
    Vector<GLJPanelListener> panelListeners;

    public GLJPanelViewer() {
        this(null, null);
    }

    public GLJPanelViewer(SceneGraphPath camPath, SceneGraphComponent root) {
        this.setAuxiliaryRoot(SceneGraphUtility.createFullSceneGraphComponent("AuxiliaryRoot"));
        this.initializeFrom(root, camPath);
        this.panel.setOpaque(this.opaque);
    }

    public void paintBefore(Graphics g) {
        this.preRender = true;
        this.g2d = (Graphics2D)g;
        this.broadcastChange();
    }

    public void paintAfter(Graphics g) {
        this.preRender = false;
        this.g2d = (Graphics2D)g;
        this.broadcastChange();
    }

    protected void initializeFrom(SceneGraphComponent r, SceneGraphPath p) {
        this.setSceneRoot(r);
        this.setCameraPath(p);
        GLCapabilities caps = new GLCapabilities();
        caps.setAlphaBits(8);
        caps.setStereo(JOGLConfiguration.quadBufferedStereo);
        caps.setDoubleBuffered(true);
        AbstractViewer.MultisampleChooser chooser = new AbstractViewer.MultisampleChooser();
        GLContext sharedContext = (GLContext)firstOne.get();
        if (JOGLConfiguration.multiSample) {
            caps.setSampleBuffers(true);
            caps.setNumSamples(4);
            caps.setStereo(JOGLConfiguration.quadBufferedStereo);
        } else {
            chooser = new DefaultGLCapabilitiesChooser();
        }
        if (JOGLConfiguration.sharedContexts && sharedContext == null) {
            this.setupSharedContext(caps, (GLCapabilitiesChooser)chooser);
        }
        this.panel = new GLJPanel(caps, (GLCapabilitiesChooser)chooser, sharedContext){

            protected void paintComponent(Graphics arg0) {
                GLJPanelViewer.this.paintBefore(arg0);
                super.paintComponent(arg0);
                GLJPanelViewer.this.paintAfter(arg0);
            }
        };
        this.drawable = this.panel;
        JOGLConfiguration.getLogger().log(Level.INFO, "Caps is " + caps.toString());
        this.drawable.addGLEventListener((GLEventListener)this);
        if (JOGLConfiguration.quadBufferedStereo) {
            this.setStereoType(4);
        }
    }

    private void setupSharedContext(GLCapabilities caps, GLCapabilitiesChooser chooser) {
        if (this.sharedPBuffer == null) {
            this.sharedPBuffer = GLDrawableFactory.getFactory().createGLPbuffer(caps, chooser, 1, 1, null);
        }
        firstOne = new WeakReference<GLContext>(this.sharedPBuffer.getContext());
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
        this.panel.setOpaque(opaque);
    }

    public void addRenderListener(GLJPanelListener l) {
        if (this.panelListeners == null) {
            this.panelListeners = new Vector();
        }
        if (this.panelListeners.contains(l)) {
            return;
        }
        this.panelListeners.add(l);
    }

    public void removeRenderListener(GLJPanelListener l) {
        if (this.panelListeners == null) {
            return;
        }
        this.panelListeners.remove(l);
    }

    public void broadcastChange() {
        if (this.panelListeners == null) {
            return;
        }
        if (!this.panelListeners.isEmpty()) {
            EventObject e = new EventObject(this);
            for (int i = 0; i < this.panelListeners.size(); ++i) {
                GLJPanelListener l = this.panelListeners.get(i);
                if (this.preRender) {
                    l.preRender(this.g2d);
                    continue;
                }
                l.postRender(this.g2d);
            }
        }
    }

    public static interface GLJPanelListener
    extends EventListener {
        public void preRender(Graphics2D var1);

        public void postRender(Graphics2D var1);
    }
}

