/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.AbstractCalculation;
import de.jreality.jogl.GpgpuUtility;
import de.jreality.jogl.shader.GlslLoader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;

public class ClothCalculation
extends AbstractCalculation {
    private static int NUM_ROWS;
    private static int NUM_COLS;
    private FloatBuffer positions;
    private int dataTextureSize;
    private int[] texIDsPositions;
    private int[] texIDsVelocities;
    private boolean hasData;
    private boolean dataChanged;
    private int pingPong;
    private int pongPing = 1;
    private double[] gravity = new double[]{0.0, 0.0, -1.0};
    private double damping = 0.01;
    private double factor = 1.0;

    public ClothCalculation(int rows, int columns) {
        NUM_ROWS = rows;
        NUM_COLS = columns * columns;
        this.dataTextureSize = columns;
        this.positions = ByteBuffer.allocateDirect(NUM_COLS * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.valueBuffer = ByteBuffer.allocateDirect(NUM_COLS * NUM_ROWS * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.texIDsPositions = new int[NUM_ROWS * 2];
        this.texIDsVelocities = new int[NUM_ROWS * 2];
    }

    protected String initSource() {
        return "uniform bool point; \nuniform vec3 gravity; \nuniform float damping; \nuniform float factor; \n \nuniform samplerRect upper; \nuniform samplerRect prev; \nuniform samplerRect velocity; \n \nvoid main(void) { \n  vec2 pos = gl_TexCoord[0].st; \n  vec3 prevPos = textureRect(prev, pos).xyz; \n  vec3 upperPos = textureRect(upper, pos).xyz; \n  vec3 vel = textureRect(velocity, pos).xyz; \n \n vec3 dir = prevPos - upperPos + factor*(vel+gravity); \n dir = 0.1*normalize(dir);\n  if (point) {\n \n gl_FragColor =  vec4(upperPos +dir, 1.);\n \n  } else {\n \n gl_FragColor = vec4(damping*(vel- dot(vel,dir)*dir),1.); \n  }\n} \n";
    }

    protected void initViewport(GL gl, GLU glu) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0, (double)this.dataTextureSize, 0.0, (double)this.dataTextureSize);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glViewport(0, 0, this.dataTextureSize, this.dataTextureSize);
    }

    protected void renderQuad(GL gl) {
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glPolygonMode(1028, 6914);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(this.isTex2D() ? 1.0 : (double)this.dataTextureSize, 0.0);
        gl.glVertex2d((double)this.dataTextureSize, 0.0);
        gl.glTexCoord2d(this.isTex2D() ? 1.0 : (double)this.dataTextureSize, this.isTex2D() ? 1.0 : (double)this.dataTextureSize);
        gl.glVertex2d((double)this.dataTextureSize, (double)this.dataTextureSize);
        gl.glTexCoord2d(0.0, this.isTex2D() ? 1.0 : (double)this.dataTextureSize);
        gl.glVertex2d(0.0, (double)this.dataTextureSize);
        gl.glEnd();
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        GLU glu = new GLU();
        if (this.hasData && this.doIntegrate) {
            this.initPrograms(gl);
            this.initFBO(gl);
            this.initViewport(gl, glu);
            this.initDataTextures(gl);
            this.valueBuffer.clear();
            this.valueBuffer.put(this.positions);
            this.positions.clear();
            this.program.setUniform("gravity", this.gravity);
            this.program.setUniform("damping", this.damping);
            this.program.setUniform("factor", this.factor);
            gl.glEnable(this.TEX_TARGET);
            for (int i = 0; i < NUM_ROWS - 1; ++i) {
                gl.glFramebufferTexture2DEXT(36160, 36064, this.TEX_TARGET, this.texIDsPositions[this.pingPong * NUM_ROWS + i + 1], 0);
                gl.glFramebufferTexture2DEXT(36160, 36065, this.TEX_TARGET, this.texIDsVelocities[this.pingPong * NUM_ROWS + i + 1], 0);
                GpgpuUtility.checkBuf(gl);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                gl.glBindTexture(this.TEX_TARGET, this.texIDsPositions[this.pingPong * NUM_ROWS + i]);
                this.program.setUniform("upper", 0);
                gl.glActiveTexture(33985);
                gl.glBindTexture(this.TEX_TARGET, this.texIDsPositions[this.pongPing * NUM_ROWS + i + 1]);
                this.program.setUniform("prev", 1);
                gl.glActiveTexture(33986);
                gl.glBindTexture(this.TEX_TARGET, this.texIDsVelocities[this.pongPing * NUM_ROWS + i + 1]);
                this.program.setUniform("velocity", 2);
                this.program.setUniform("point", true);
                GlslLoader.render(this.program, gl);
                this.renderQuad(gl);
                gl.glFinish();
                this.valueBuffer.position((i + 1) * NUM_COLS * 4).limit((i + 2) * NUM_COLS * 4);
                gl.glReadBuffer(36064);
                gl.glReadPixels(0, 0, this.dataTextureSize, this.dataTextureSize, TEX_FORMAT, 5126, (Buffer)this.valueBuffer.slice());
                gl.glDrawBuffer(36065);
                this.program.setUniform("point", false);
                GlslLoader.render(this.program, gl);
                this.renderQuad(gl);
                gl.glDrawBuffer(0);
            }
            int tmp = this.pingPong;
            this.pingPong = this.pongPing;
            this.pongPing = tmp;
            GlslLoader.postRender(this.program, gl);
            gl.glBindFramebufferEXT(36160, 0);
            this.calculationFinished();
            gl.glDisable(this.TEX_TARGET);
        }
    }

    protected void initDataTextures(GL gl) {
        if (this.texIDsPositions[0] == 0) {
            gl.glGenTextures(this.texIDsPositions.length, this.texIDsPositions, 0);
            gl.glGenTextures(this.texIDsVelocities.length, this.texIDsVelocities, 0);
            for (int i = 0; i < this.texIDsPositions.length; ++i) {
                this.setupTexture(gl, this.texIDsPositions[i], this.dataTextureSize);
                this.setupTexture(gl, this.texIDsVelocities[i], this.dataTextureSize);
            }
        }
        if (this.dataChanged) {
            this.transferToTexture(gl, this.positions, this.texIDsPositions[0], this.dataTextureSize);
            this.transferToTexture(gl, this.positions, this.texIDsPositions[NUM_ROWS], this.dataTextureSize);
            this.dataChanged = false;
        }
    }

    public void setPositions(double[] data) {
        this.positions.clear();
        assert (data.length * 4 == this.positions.capacity() * 3);
        for (int i = 0; i < data.length; ++i) {
            this.positions.put((float)data[i]);
            if (i % 3 != 2) continue;
            this.positions.put(1.0f);
        }
        this.positions.clear();
        this.hasData = true;
        this.dataChanged = true;
    }

    public void setPositions(float[] data) {
        this.positions.clear();
        assert (data.length == this.positions.capacity());
        this.positions.put(data);
        this.positions.clear();
        this.hasData = true;
        this.dataChanged = true;
    }

    public void triggerCalculation() {
        if (this.hasData) {
            super.triggerCalculation();
        }
    }

    public double getDamping() {
        return this.damping;
    }

    public void setDamping(double damping) {
        this.damping = damping;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public double[] getGravity() {
        return this.gravity;
    }

    public void setGravity(double[] gravity) {
        this.gravity = gravity;
    }

    protected void calculationFinished() {
        this.measure();
    }

    public static void main(String[] args) {
        ClothCalculation cc = new ClothCalculation(40, 64);
        float[] f = GpgpuUtility.makeGradient(8);
        GpgpuUtility.dumpData(f);
        cc.setPositions(f);
        cc.setDisplayTexture(false);
        cc.triggerCalculation();
        GpgpuUtility.run(cc);
    }
}

