/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.GpgpuUtility;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.jogl.shader.GlslLoader;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.shader.GlslProgram;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import javax.swing.JOptionPane;

public abstract class AbstractCalculation
implements GLEventListener {
    private static final String RENDER_PROGRAM = "uniform samplerRect values;\nuniform float scale;\nvoid main(void) {\n  vec2 pos = gl_TexCoord[0].st;\n  vec4 col = textureRect(values, pos);  gl_FragColor = abs(col/col.w); //vec4(scale*rescale*a, 1.);\n}\n";
    private static final double[] ID = Rn.identityMatrix(4);
    protected boolean doIntegrate;
    private boolean tex2D;
    protected int TEX_TARGET;
    private int TEX_INTERNAL_FORMAT;
    protected static int TEX_FORMAT = 6408;
    private boolean atiHack;
    protected GlslProgram program;
    private GlslProgram renderer;
    private int[] fbos = new int[1];
    private int[] vbo = new int[1];
    private int[] valueTextures = new int[2];
    private int[] attachments = new int[]{36064, 36065};
    protected int readTex;
    private int writeTex = 1;
    protected FloatBuffer valueBuffer;
    private int valueTextureSize;
    protected int numValues;
    private boolean valuesChanged;
    private boolean valueTextureSizeChanged;
    private boolean hasValues;
    private boolean hasValidVBO;
    private boolean readData = true;
    private boolean displayTexture;
    private int[] canvasViewport = new int[2];
    private boolean measureCPS = true;
    int cnt;
    long st;

    public void init(GLAutoDrawable drawable) {
        if (!(drawable.getGL().isExtensionAvailable("GL_ARB_fragment_shader") && drawable.getGL().isExtensionAvailable("GL_ARB_vertex_shader") && drawable.getGL().isExtensionAvailable("GL_ARB_shader_objects") && drawable.getGL().isExtensionAvailable("GL_ARB_shading_language_100"))) {
            JOptionPane.showMessageDialog(null, "<html><center>Driver does not support OpenGL Shading Language!<br>Cannot execute program.</center></html>");
            System.exit(-1);
        }
        String vendor = drawable.getGL().glGetString(7936);
        this.tex2D = false;
        this.atiHack = false;
        this.TEX_TARGET = this.tex2D ? 3553 : 34037;
        this.TEX_INTERNAL_FORMAT = this.tex2D ? 34836 : 34955;
        this.renderer = new GlslProgram(new Appearance(), "foo", null, this.isTex2D() ? RENDER_PROGRAM.replaceAll("Rect", "2D") : RENDER_PROGRAM);
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        GLU glu = new GLU();
        if (this.doIntegrate && this.hasValues) {
            gl.glEnable(this.TEX_TARGET);
            gl.glMatrixMode(5890);
            gl.glLoadTransposeMatrixd(ID, 0);
            this.initPrograms(gl);
            this.initFBO(gl);
            if (!this.readData) {
                this.initVBO(gl);
            }
            this.initViewport(gl, glu, true);
            this.initTextures(gl);
            this.initDataTextures(gl);
            gl.glFramebufferTexture2DEXT(36160, this.attachments[this.readTex], this.TEX_TARGET, this.valueTextures[this.readTex], 0);
            gl.glFramebufferTexture2DEXT(36160, this.attachments[this.writeTex], this.TEX_TARGET, this.valueTextures[this.writeTex], 0);
            GpgpuUtility.checkBuf(gl);
            gl.glDrawBuffer(this.attachments[this.writeTex]);
            gl.glActiveTexture(33984);
            gl.glBindTexture(this.TEX_TARGET, this.valueTextures[this.readTex]);
            this.program.setUniform("values", 0);
            this.setUniformValues(gl, this.program);
            GlslLoader.render(this.program, gl);
            this.renderQuad(gl);
            gl.glFinish();
            if (this.readData) {
                this.valueBuffer.clear();
                this.transferFromTexture(gl, this.valueBuffer);
                if (this.atiHack) {
                    GpgpuUtility.atiHack(this.valueBuffer);
                }
            } else {
                this.transferFromTextureToVBO(gl);
            }
            int tmp = this.readTex;
            this.readTex = this.writeTex;
            this.writeTex = tmp;
            GlslLoader.postRender(this.program, gl);
            gl.glBindFramebufferEXT(36160, 0);
            this.doIntegrate = false;
            this.measure();
            this.calculationFinished();
            if (this.displayTexture) {
                this.initViewport(gl, glu, false);
                gl.glActiveTexture(33984);
                gl.glBindTexture(this.TEX_TARGET, this.valueTextures[this.writeTex]);
                this.renderer.setUniform("values", 0);
                this.renderer.setUniform("scale", 1.0);
                GlslLoader.render(this.renderer, gl);
                this.renderQuad(gl);
                GlslLoader.postRender(this.renderer, gl);
            }
            gl.glDisable(this.TEX_TARGET);
        }
    }

    protected void measure() {
        if (this.measureCPS) {
            if (this.st == 0L) {
                this.st = System.currentTimeMillis();
            }
            ++this.cnt;
            long ct = System.currentTimeMillis();
            if (ct - this.st > 5000L) {
                System.out.println("CPS=" + 1000.0 * (double)this.cnt / (double)(ct - this.st));
                this.cnt = 0;
                this.st = ct;
            }
        }
    }

    protected void initDataTextures(GL gl) {
    }

    protected String updateSource() {
        return null;
    }

    protected abstract String initSource();

    protected void setUniformValues(GL gl, GlslProgram prog) {
    }

    protected void calculationFinished() {
    }

    protected void renderQuad(GL gl) {
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glPolygonMode(1028, 6914);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(this.tex2D ? 1.0 : (double)this.valueTextureSize, 0.0);
        gl.glVertex2d((double)this.valueTextureSize, 0.0);
        gl.glTexCoord2d(this.tex2D ? 1.0 : (double)this.valueTextureSize, this.tex2D ? 1.0 : (double)this.valueTextureSize);
        gl.glVertex2d((double)this.valueTextureSize, (double)this.valueTextureSize);
        gl.glTexCoord2d(0.0, this.tex2D ? 1.0 : (double)this.valueTextureSize);
        gl.glVertex2d(0.0, (double)this.valueTextureSize);
        gl.glEnd();
    }

    private void initVBO(GL gl) {
        if (this.vbo[0] == 0) {
            gl.glGenBuffersARB(1, this.vbo, 0);
            System.out.println("created VBO=" + this.vbo[0]);
            gl.glBindBufferARB(35051, this.vbo[0]);
            gl.glBufferDataARB(35051, 0x1000000, (Buffer)null, 35048);
            gl.glBindBufferARB(35051, 0);
            this.hasValidVBO = true;
        }
    }

    protected void initPrograms(GL gl) {
        String src;
        String string = src = this.program == null ? this.initSource() : this.updateSource();
        if (src == null) {
            return;
        }
        if (this.program != null) {
            GlslLoader.dispose(gl, this.program);
        }
        if (this.isTex2D()) {
            src = src.replaceAll("Rect", "2D");
        }
        this.program = new GlslProgram(new Appearance(), "foo", null, src);
    }

    private void initTextures(GL gl) {
        if (this.valueTextureSizeChanged) {
            gl.glEnable(this.TEX_TARGET);
            if (this.valueTextures[0] != 0) {
                gl.glDeleteTextures(2, this.valueTextures, 0);
            }
            gl.glGenTextures(2, this.valueTextures, 0);
            this.setupTexture(gl, this.valueTextures[0], this.valueTextureSize);
            this.setupTexture(gl, this.valueTextures[1], this.valueTextureSize);
            this.valueTextureSizeChanged = false;
            System.out.println("[initTextures] new particles tex size: " + this.valueTextureSize);
        }
        if (this.valuesChanged) {
            gl.glEnable(this.TEX_TARGET);
            this.valueBuffer.clear();
            this.transferToTexture(gl, this.valueBuffer, this.valueTextures[this.readTex], this.valueTextureSize);
            System.out.println("[initTextures] new particle data");
            this.valuesChanged = false;
        }
    }

    protected void setupTexture(GL gl, int texID, int size) {
        gl.glBindTexture(this.TEX_TARGET, texID);
        gl.glTexParameteri(this.TEX_TARGET, 10241, 9728);
        gl.glTexParameteri(this.TEX_TARGET, 10240, 9728);
        gl.glTexParameteri(this.TEX_TARGET, 10242, 10496);
        gl.glTexParameteri(this.TEX_TARGET, 10243, 10496);
        gl.glTexImage2D(this.TEX_TARGET, 0, this.TEX_INTERNAL_FORMAT, size, size, 0, TEX_FORMAT, 5126, (Buffer)null);
    }

    private void transferFromTexture(GL gl, FloatBuffer data) {
        gl.glReadBuffer(this.attachments[this.writeTex]);
        gl.glReadPixels(0, 0, this.valueTextureSize, this.valueTextureSize, TEX_FORMAT, 5126, (Buffer)data);
    }

    protected void transferToTexture(GL gl, FloatBuffer buffer, int texID, int size) {
        gl.glPixelStorei(3314, size);
        gl.glTexParameteri(this.TEX_TARGET, 10241, 9728);
        gl.glTexParameteri(this.TEX_TARGET, 10240, 9728);
        gl.glTexParameteri(this.TEX_TARGET, 10242, 10496);
        gl.glTexParameteri(this.TEX_TARGET, 10243, 10496);
        gl.glTexParameteri(3553, 33169, 0);
        gl.glBindTexture(this.TEX_TARGET, texID);
        gl.glTexSubImage2D(this.TEX_TARGET, 0, 0, 0, size, size, TEX_FORMAT, 5126, (Buffer)buffer);
    }

    private void transferFromTextureToVBO(GL gl) {
        gl.glBindBufferARB(35051, this.vbo[0]);
        gl.glReadPixels(0, 0, this.valueTextureSize, this.valueTextureSize, TEX_FORMAT, 5126, 0L);
        gl.glBindBufferARB(35051, 0);
        this.hasValidVBO = true;
    }

    protected void initFBO(GL gl) {
        if (this.fbos[0] == 0) {
            gl.glGenFramebuffersEXT(1, this.fbos, 0);
            System.out.println("created FBO=" + this.fbos[0]);
        }
        gl.glBindFramebufferEXT(36160, this.fbos[0]);
    }

    protected void initViewport(GL gl, GLU glu, boolean gpgpu) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0, (double)this.valueTextureSize, 0.0, (double)this.valueTextureSize);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        if (gpgpu) {
            gl.glViewport(0, 0, this.valueTextureSize, this.valueTextureSize);
        } else {
            gl.glViewport(0, 0, this.canvasViewport[0], this.canvasViewport[1]);
        }
    }

    public FloatBuffer getCurrentValues() {
        if (!this.readData || this.valueBuffer == null) {
            return null;
        }
        this.valueBuffer.position(0).limit(this.numValues);
        return this.valueBuffer.asReadOnlyBuffer();
    }

    public void setValues(float[] values) {
        System.out.println("AbstractCalculation.setParticles()");
        if (values == null || values.length == 0) {
            return;
        }
        if (this.numValues != values.length) {
            int texSize = GpgpuUtility.texSize(values.length / 4);
            if (this.valueTextureSize != texSize) {
                System.out.println("[setParticles] new particles tex size=" + texSize);
                this.valueBuffer = ByteBuffer.allocateDirect(texSize * texSize * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
                this.valueTextureSize = texSize;
                this.valueTextureSizeChanged = true;
            }
            this.numValues = this.valueTextureSize * this.valueTextureSize * 4;
        }
        this.valueBuffer.position(0).limit();
        this.valueBuffer.put(values);
        this.valueBuffer.position(this.numValues).limit(this.valueBuffer.capacity());
        while (this.valueBuffer.hasRemaining()) {
            this.valueBuffer.put(0.0f);
        }
        this.valuesChanged = true;
        this.hasValues = true;
    }

    public boolean isReadData() {
        return this.readData;
    }

    public void setReadData(boolean readData) {
        this.readData = readData;
    }

    public int getValueTextureSize() {
        return this.valueTextureSize;
    }

    public void triggerCalculation() {
        this.doIntegrate = true;
    }

    protected boolean isTex2D() {
        return this.tex2D;
    }

    public void reshape(GLAutoDrawable arg0, int arg1, int arg2, int arg3, int arg4) {
        this.canvasViewport[0] = arg3;
        this.canvasViewport[1] = arg4;
    }

    public void displayChanged(GLAutoDrawable arg0, boolean arg1, boolean arg2) {
    }

    public boolean isDisplayTexture() {
        return this.displayTexture;
    }

    public void setDisplayTexture(boolean displayTexture) {
        this.displayTexture = displayTexture;
    }

    public boolean isMeasureCPS() {
        return this.measureCPS;
    }

    public void setMeasureCPS(boolean measureCPS) {
        this.measureCPS = measureCPS;
    }

    public void renderPoints(JOGLRenderer jr) {
        if (!this.hasValidVBO || this.readData) {
            return;
        }
        GL gl = jr.globalGL;
        gl.glBindBufferARB(34962, this.vbo[0]);
        gl.glVertexPointer(4, 5126, 0, 0L);
        gl.glBindBufferARB(34962, 0);
        gl.glEnableClientState(32884);
        gl.glDrawArrays(0, 0, this.valueTextureSize * this.valueTextureSize);
        gl.glDisableClientState(32884);
    }
}

