/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.Primitives;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.util.Rectangle3D;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;

public class SliceBoxFactory {
    SceneGraphPath clipper = null;
    double separation = 0.2;
    SceneGraphComponent clipPlane1SGC;
    SceneGraphComponent clipPlane2SGC;
    SceneGraphComponent clipIcon1;
    SceneGraphComponent clipIcon2;
    SceneGraphComponent worldSGC;
    SceneGraphComponent sliceBoxSGC;
    IndexedFaceSetFactory clipIconFactory = new IndexedFaceSetFactory();
    private final InputSlot pointerSlot = InputSlot.getDevice("PointerTransformation");
    private final InputSlot activeSlot = InputSlot.getDevice("PrimaryAction");
    private Rectangle3D worldBoundingBox;

    public SliceBoxFactory(SceneGraphComponent w) {
        this.worldSGC = w;
        this.clipIcon1 = SceneGraphUtility.createFullSceneGraphComponent("theClipIcon1");
        Transformation clipTform = this.clipIcon1.getTransformation();
        this.clipIcon1.getAppearance().setAttribute("lineShader.tubeRadius", 0.01);
        this.clipIcon1.getAppearance().setAttribute("lineShader.polygonShader.diffuseColor", Color.white);
        this.clipIcon2 = SceneGraphUtility.createFullSceneGraphComponent("theClipIcon2");
        MatrixBuilder.euclidean().translate(0.0, 0.0, -this.separation).assignTo(this.clipIcon2);
        this.clipIcon1.addChild(this.clipIcon2);
        this.clipPlane1SGC = SceneGraphUtility.createFullSceneGraphComponent("theClipPlane2");
        this.clipPlane1SGC.setTransformation(clipTform);
        ClippingPlane clippingPlane1 = new ClippingPlane();
        clippingPlane1.setLocal(true);
        this.clipPlane1SGC.setGeometry(clippingPlane1);
        this.clipPlane2SGC = SceneGraphUtility.createFullSceneGraphComponent("theClipPlane2");
        ClippingPlane clippingPlane2 = new ClippingPlane();
        clippingPlane2.setLocal(true);
        this.clipPlane2SGC.setGeometry(clippingPlane2);
        this.clipPlane1SGC.addChild(this.clipPlane2SGC);
        this.clipPlane2SGC.addChild(this.worldSGC);
        this.sliceBoxSGC = SceneGraphUtility.createFullSceneGraphComponent("slice box");
        this.worldBoundingBox = BoundingBoxUtility.calculateBoundingBox(this.worldSGC);
        double[] extents = this.worldBoundingBox.getExtent();
        double[][] black = new double[][]{{0.0, 0.0, 0.0, 0.0}};
        double[][] blacks = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}};
        this.clipIconFactory.setVertexCount(4);
        this.clipIconFactory.setFaceCount(1);
        this.clipIconFactory.setFaceIndices(new int[][]{{0, 1, 2, 3}});
        this.updateClipIcon(0);
        IndexedFaceSet square = this.clipIconFactory.getIndexedFaceSet();
        square.setFaceAttributes(Attribute.COLORS, StorageModel.DOUBLE_ARRAY.array(4).createReadOnly(black));
        this.clipIcon1.setGeometry(square);
        this.clipIcon2.setGeometry(square);
        IndexedFaceSet cube = Primitives.box(extents[0], extents[1], extents[2], false);
        MatrixBuilder.euclidean().translate(this.worldBoundingBox.getCenter()).assignTo(this.sliceBoxSGC);
        cube.setFaceAttributes(Attribute.COLORS, StorageModel.DOUBLE_ARRAY.array(4).createReadOnly(blacks));
        this.sliceBoxSGC.setGeometry(cube);
        this.sliceBoxSGC.addTool(new SimpleDragTool());
        this.sliceBoxSGC.addChild(this.clipPlane1SGC);
        this.sliceBoxSGC.addChild(this.clipIcon1);
        this.clipper = new SceneGraphPath(this.sliceBoxSGC, this.clipPlane1SGC, this.clipPlane2SGC);
        this.update();
    }

    private void updateClipIcon(int i) {
        int i0 = (i + 1) % 3;
        int i1 = (i + 2) % 3;
        double[] ex = this.worldBoundingBox.getExtent();
        double x = ex[i0] / 2.0;
        double y = ex[i1] / 2.0;
        double[][] vv = new double[][]{{-x, -y, 0.0}, {x, -y, 0.0}, {x, y, 0.0}, {-x, y, 0.0}};
        this.clipIconFactory.setVertexCoordinates(vv);
        this.clipIconFactory.setGenerateEdgesFromFaces(true);
        this.clipIconFactory.update();
    }

    public SceneGraphComponent getSliceBoxSGC() {
        return this.sliceBoxSGC;
    }

    public double getSeparation() {
        return this.separation;
    }

    public void setSeparation(double separation) {
        this.separation = separation;
    }

    public void update() {
        MatrixBuilder.euclidean().translate(0.0, 0.0, -this.separation).reflect(new double[]{0.0, 0.0, 1.0, 0.0}).assignTo(this.clipPlane2SGC);
        MatrixBuilder.euclidean().translate(0.0, 0.0, -this.separation).assignTo(this.clipIcon2);
    }

    public class SimpleDragTool
    extends AbstractTool {
        boolean dragging;
        boolean firstTime;
        double[] originalCoords;
        double[] originalMat;
        double originald;
        int whichFace;
        int oldIndex0;
        int oldDirection;
        int index0;
        int index1;
        int index2;
        boolean sameFace;

        public SimpleDragTool() {
            super(SliceBoxFactory.this.activeSlot);
            this.dragging = false;
            this.firstTime = false;
            this.originald = 0.0;
            this.oldIndex0 = -1;
            this.oldDirection = -1;
            this.sameFace = true;
            this.addCurrentSlot(SliceBoxFactory.this.pointerSlot, "triggers drag events");
        }

        public void setSeparation(double d) {
            SliceBoxFactory.this.separation = d;
            SliceBoxFactory.this.update();
        }

        public double getSeparation() {
            return SliceBoxFactory.this.separation;
        }

        public void activate(ToolContext tc) {
            super.activate(tc);
            PickResult currentPick = tc.getCurrentPick();
            if (currentPick != null && currentPick.getPickType() == 1) {
                this.dragging = true;
                this.whichFace = currentPick.getIndex();
                this.index0 = this.whichFace % 3;
                this.index1 = (this.index0 + 1) % 3;
                this.index2 = (this.index0 + 2) % 3;
                this.originalCoords = (double[])currentPick.getObjectCoordinates().clone();
                if (this.index0 == this.oldIndex0) {
                    this.originalMat = SliceBoxFactory.this.clipPlane1SGC.getTransformation().getMatrix();
                    this.sameFace = true;
                } else {
                    this.originalMat = Rn.identityMatrix(4);
                    this.originald = 0.0;
                    this.sameFace = false;
                }
                this.oldIndex0 = this.index0;
                System.err.println("activate " + Rn.toString(this.originalCoords));
                this.firstTime = true;
            }
        }

        public void deactivate(ToolContext tc) {
            super.deactivate(tc);
            this.dragging = false;
        }

        public void perform(ToolContext tc) {
            PickResult currentPick = tc.getCurrentPick();
            if (!this.dragging || this.originalCoords == null || currentPick == null) {
                return;
            }
            if (currentPick.getPickType() == 1) {
                double[] newCoords = currentPick.getObjectCoordinates();
                double[] dd = Rn.subtract(null, this.originalCoords, newCoords);
                int direction = this.oldDirection;
                if (this.firstTime) {
                    int n = direction = Math.abs(dd[this.index1]) > Math.abs(dd[this.index2]) ? this.index1 : this.index2;
                    if (!this.sameFace || direction != this.oldDirection) {
                        double[] to = new double[3];
                        to[direction] = -1.0;
                        double[] zaxis = new double[]{0.0, 0.0, 1.0};
                        MatrixBuilder.euclidean().rotateFromTo(zaxis, to).assignTo(this.originalMat);
                        this.originald = 0.0;
                        this.oldDirection = direction;
                    }
                    Matrix foo = new Matrix(this.originalMat);
                    this.originald = foo.getEntry(direction, 3);
                    this.firstTime = false;
                }
                double d = -dd[direction];
                double[] newCP = new double[4];
                newCP[direction] = -1.0;
                newCP[3] = d + this.originald;
                if (newCP[3] < -SliceBoxFactory.this.separation - SliceBoxFactory.this.worldBoundingBox.getExtent()[direction] / 2.0) {
                    newCP[3] = -SliceBoxFactory.this.separation - SliceBoxFactory.this.worldBoundingBox.getExtent()[direction] / 2.0;
                    d = newCP[3] - this.originald;
                } else if (newCP[3] > SliceBoxFactory.this.worldBoundingBox.getExtent()[direction] / 2.0) {
                    newCP[3] = SliceBoxFactory.this.worldBoundingBox.getExtent()[direction] / 2.0;
                    d = newCP[3] - this.originald;
                }
                Matrix foo = new Matrix();
                double[] tlate = new double[3];
                tlate[direction] = d;
                MatrixBuilder.euclidean().translate(tlate).assignTo(foo);
                SliceBoxFactory.this.clipPlane1SGC.getTransformation().setMatrix(Rn.times(null, foo.getArray(), this.originalMat));
                SliceBoxFactory.this.worldSGC.getTransformation().setMatrix(SliceBoxFactory.this.clipper.getInverseMatrix(null));
            }
        }
    }
}

