/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StringArray;
import de.jreality.scene.data.StringArrayArray;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveDuplicateInfo {
    private int[] referenceTable;
    private int[] mergeReferenceTable;
    private int[] removeReferenceTable;
    private int[] sublistTable;
    private PointSet source;
    private PointSet geo;
    private double[][] points;
    private double[][] attrVals;
    private double eps;
    private int dim;
    private int maxPointPerBoxCount = 50;
    private int numSubBoxes;
    private int numNewVerts;
    public static final Attribute[] defaultAttrs = new Attribute[]{Attribute.COORDINATES};

    private RemoveDuplicateInfo(PointSet ps, Attribute ... attributes) {
        this.source = ps;
        this.points = this.source.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
    }

    public static PointSet removeDuplicateVertices(PointSet ps, Attribute ... attributes) {
        return RemoveDuplicateInfo.removeDuplicateVertices(ps, 1.0E-7, attributes);
    }

    public static PointSet removeDuplicateVertices(PointSet ps, double eps, Attribute ... attributes) {
        RemoveDuplicateInfo r = new RemoveDuplicateInfo(ps, new Attribute[0]);
        r.geo = ps instanceof IndexedFaceSet ? new IndexedFaceSet() : (ps instanceof IndexedLineSet ? new IndexedLineSet() : new PointSet());
        if (r.points.length == 0) {
            return null;
        }
        if (r.points.length == 1) {
            return null;
        }
        r.eps = Math.max(0.0, eps);
        r.dim = r.points[0].length;
        r.mergeReferenceTable = new int[r.points.length];
        for (int i = 0; i < r.points.length; ++i) {
            r.mergeReferenceTable[i] = i;
        }
        r.numSubBoxes = (int)Math.pow(2.0, r.dim);
        r.readOutAttributes(attributes);
        Box b = r.fillFirstBox();
        r.processBox(b);
        r.postCalulation();
        return r.geo;
    }

    private void readOutAttributes(Attribute ... attributes) {
        LinkedList<double[][]> DAAList = new LinkedList<double[][]>();
        LinkedList<double[]> DAList = new LinkedList<double[]>();
        int dim = 0;
        if (attributes == null) {
            attributes = defaultAttrs;
        }
        for (Attribute at : attributes) {
            DataList currDL;
            if (at.getName().equals(Attribute.COORDINATES.getName()) || (currDL = this.source.getVertexAttributes(at)) == null) continue;
            if (currDL instanceof DoubleArrayArray) {
                if (currDL.item(0) == null) continue;
                DAAList.add(currDL.toDoubleArrayArray(null));
                dim += currDL.item(0).size();
            }
            if (!(currDL instanceof DoubleArray)) continue;
            DAList.add(currDL.toDoubleArray(null));
            ++dim;
        }
        System.err.println("dim = " + dim);
        this.attrVals = new double[this.source.getNumPoints()][dim];
        int dimCount = 0;
        for (double[][] daa : DAAList) {
            int currDim = daa[0].length;
            for (int i = 0; i < daa.length; ++i) {
                System.arraycopy(daa[i], 0, this.attrVals[i], dimCount, currDim);
            }
            dimCount += currDim;
        }
        for (double[] da : DAList) {
            for (int i = 0; i < da.length; ++i) {
                this.attrVals[i][dimCount] = da[i];
            }
            ++dimCount;
        }
    }

    private Box fillFirstBox() {
        int i;
        double[] max = new double[this.dim];
        double[] min = new double[this.dim];
        for (i = 0; i < this.dim; ++i) {
            min[i] = max[i] = this.points[0][i];
        }
        for (i = 1; i < this.points.length; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                double[] p = this.points[i];
                if (p[j] >= max[j]) {
                    max[j] = p[j];
                }
                if (!(p[j] <= min[j])) continue;
                min[j] = p[j];
            }
        }
        Box b = new Box(max, min, this.dim);
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            b.addPointIfPossible(i2);
        }
        return b;
    }

    private void processBox(Box b) {
        if (b.numOfPoints <= 1) {
            return;
        }
        if (b.getSize() <= 3.0 * this.eps) {
            this.compareInBox(b);
            return;
        }
        if (b.numOfPoints > this.maxPointPerBoxCount) {
            Box[] subBoxes = this.createSubBoxes(b);
            for (int i = 0; i < subBoxes.length; ++i) {
                this.processBox(subBoxes[i]);
            }
            return;
        }
        this.compareInBox(b);
    }

    private boolean inBetween(double[] max, double[] min, double eps, double[] val) {
        for (int i = 0; i < val.length; ++i) {
            if (val[i] > max[i] + eps) {
                return false;
            }
            if (!(val[i] < min[i] - eps)) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualByEps(int p1, int p2) {
        double[] c1 = this.points[p1];
        double[] c2 = this.points[p2];
        double[] a1 = this.attrVals[p1];
        double[] a2 = this.attrVals[p2];
        return this.inBetween(c1, c1, this.eps, c2) && this.inBetween(a1, a1, this.eps, a2);
    }

    private void compareInBox(Box b) {
        for (int p1 : b.innerPoints) {
            if (!this.isLegalPoint(p1)) continue;
            for (int p2 : b.innerPoints) {
                if (p1 >= p2 || !this.isLegalPoint(p2) || !this.isEqualByEps(p1, p2)) continue;
                this.mergeReferenceTable[p2] = p1;
            }
        }
    }

    private boolean isLegalPoint(int p) {
        return this.mergeReferenceTable[p] == p;
    }

    private Box[] createSubBoxes(Box b) {
        Box[] result = new Box[this.numSubBoxes];
        for (int i = 0; i < result.length; ++i) {
            double[] min = new double[this.dim];
            double[] max = new double[this.dim];
            int k = i;
            for (int d = 0; d < this.dim; ++d) {
                if (b.realMax[d] - b.realMin[d] <= 2.0 * this.eps) {
                    max[d] = min[d] = (b.realMax[d] + b.realMin[d]) / 2.0;
                }
                if (k % 2 == 0) {
                    max[d] = (b.realMin[d] + b.realMax[d]) / 2.0;
                    min[d] = b.realMin[d] + this.eps;
                } else {
                    min[d] = (b.realMin[d] + b.realMax[d]) / 2.0;
                    max[d] = b.realMax[d] - this.eps;
                }
                k >>= 1;
            }
            result[i] = new Box(max, min, this.dim);
        }
        for (int v : b.innerPoints) {
            if (!this.isLegalPoint(v)) continue;
            for (int i = 0; i < this.numSubBoxes; ++i) {
                result[i].addPointIfPossible(v);
            }
        }
        return result;
    }

    private void postCalulation() {
        this.newTables();
        this.geo.setNumPoints(this.numNewVerts);
        if (this.geo instanceof IndexedFaceSet) {
            IndexedFaceSet ifs = (IndexedFaceSet)this.geo;
            ifs.setNumFaces(((IndexedFaceSet)this.source).getNumFaces());
        }
        if (this.geo instanceof IndexedLineSet) {
            IndexedLineSet ils = (IndexedLineSet)this.geo;
            ils.setNumEdges(((IndexedLineSet)this.source).getNumEdges());
        }
        this.newDatalists();
        this.newIndices();
    }

    private void newTables() {
        int i;
        this.removeReferenceTable = new int[this.points.length];
        int numUsedVerts = 0;
        int pos = 0;
        for (i = 0; i < this.points.length; ++i) {
            this.removeReferenceTable[i] = this.mergeReferenceTable[i] == i ? numUsedVerts++ : -1;
        }
        this.referenceTable = new int[this.points.length];
        for (i = 0; i < this.points.length; ++i) {
            this.referenceTable[i] = this.removeReferenceTable[this.mergeReferenceTable[i]];
        }
        this.numNewVerts = numUsedVerts;
        this.sublistTable = new int[numUsedVerts];
        pos = 0;
        for (i = 0; i < this.points.length; ++i) {
            if (this.removeReferenceTable[i] == -1) continue;
            this.sublistTable[pos] = i;
            ++pos;
        }
    }

    private void newIndices() {
        int i;
        int[][] result;
        DataList data;
        IndexedLineSet sou;
        if (this.geo instanceof IndexedFaceSet) {
            IndexedFaceSet ifs = (IndexedFaceSet)this.geo;
            sou = (IndexedFaceSet)this.source;
            data = ((IndexedFaceSet)sou).getFaceAttributes(Attribute.INDICES);
            if (data != null && data.size() > 0) {
                int[][] fIndis = data.toIntArrayArray(null);
                result = new int[fIndis.length][];
                for (i = 0; i < result.length; ++i) {
                    result[i] = RemoveDuplicateInfo.newIndices(fIndis[i], this.referenceTable);
                }
                ifs.setFaceAttributes(Attribute.INDICES, new IntArrayArray.Array(result));
            }
        }
        if (this.geo instanceof IndexedLineSet) {
            IndexedLineSet ils = (IndexedLineSet)this.geo;
            sou = (IndexedLineSet)this.source;
            data = sou.getEdgeAttributes(Attribute.INDICES);
            if (data != null && data.size() > 0) {
                int[][] eIndis = data.toIntArrayArray(null);
                result = new int[eIndis.length][];
                for (i = 0; i < result.length; ++i) {
                    result[i] = RemoveDuplicateInfo.newIndices(eIndis[i], this.referenceTable);
                }
                ils.setEdgeAttributes(Attribute.INDICES, new IntArrayArray.Array(result));
            }
        }
    }

    private static int[] newIndices(int[] oldReferences, int[] referenceTable) {
        int[] result = new int[oldReferences.length];
        for (int i = 0; i < oldReferences.length; ++i) {
            result[i] = referenceTable[oldReferences[i]];
        }
        return result;
    }

    private void newDatalists() {
        DataListSet datas = this.source.getVertexAttributes();
        Set<Attribute> atts = datas.storedAttributes();
        for (Attribute at : atts) {
            DataList dd;
            DataList dl = datas.getList(at);
            if (dl instanceof DoubleArrayArray) {
                dd = (DoubleArrayArray)dl;
                this.geo.setVertexAttributes(at, RemoveDuplicateInfo.getSublist(dd, this.sublistTable));
            }
            if (dl instanceof DoubleArray) {
                dd = (DoubleArray)dl;
                this.geo.setVertexAttributes(at, RemoveDuplicateInfo.getSublist((DoubleArray)dd, this.sublistTable));
            }
            if (dl instanceof IntArrayArray) {
                dd = (IntArrayArray)dl;
                this.geo.setVertexAttributes(at, RemoveDuplicateInfo.getSublist((IntArrayArray)dd, this.sublistTable));
            }
            if (dl instanceof IntArray) {
                dd = (IntArray)dl;
                this.geo.setVertexAttributes(at, RemoveDuplicateInfo.getSublist((IntArray)dd, this.sublistTable));
            }
            if (dl instanceof StringArrayArray) {
                dd = (StringArrayArray)dl;
                this.geo.setVertexAttributes(at, RemoveDuplicateInfo.getSublist((StringArrayArray)dd, this.sublistTable));
            }
            if (!(dl instanceof StringArray)) continue;
            dd = (StringArray)dl;
            this.geo.setVertexAttributes(at, RemoveDuplicateInfo.getSublist((StringArray)dd, this.sublistTable));
        }
        if (this.geo instanceof IndexedFaceSet) {
            IndexedFaceSet ifs = (IndexedFaceSet)this.geo;
            ifs.setFaceAttributes(((IndexedFaceSet)this.source).getFaceAttributes());
        }
        if (this.geo instanceof IndexedLineSet) {
            IndexedLineSet ils = (IndexedLineSet)this.geo;
            ils.setEdgeAttributes(((IndexedLineSet)this.source).getEdgeAttributes());
        }
        this.geo.setGeometryAttributes(this.source.getGeometryAttributes());
        this.geo.setGeometryAttributes("quadMesh", null);
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public int[] getReferenceTable() {
        return this.referenceTable;
    }

    public static double[][] removeNoFaceVertices(double[][] vertices, int[][] faces) {
        int i;
        int i2;
        int numVOld = vertices.length;
        int numF = faces.length;
        boolean[] usedVertices = new boolean[numVOld];
        for (i2 = 0; i2 < numVOld; ++i2) {
            usedVertices[i2] = false;
        }
        for (i2 = 0; i2 < numF; ++i2) {
            for (int j = 0; j < faces[i2].length; ++j) {
                usedVertices[faces[i2][j]] = true;
            }
        }
        int count = 0;
        int[] referenceTabel = new int[numVOld];
        for (i = 0; i < numVOld; ++i) {
            if (usedVertices[i]) {
                referenceTabel[i] = count;
                vertices[count] = vertices[i];
                ++count;
                continue;
            }
            referenceTabel[i] = -1;
        }
        for (i = 0; i < numF; ++i) {
            for (int j = 0; j < faces[i].length; ++j) {
                faces[i][j] = referenceTabel[faces[i][j]];
            }
        }
        double[][] newVertices = new double[count][];
        System.arraycopy(vertices, 0, newVertices, 0, count);
        return newVertices;
    }

    public static void removeCycleDefinition(int[][] faces) {
        for (int i = 0; i < faces.length; ++i) {
            int len = faces[i].length;
            if (len <= 1 || faces[i][len - 1] != faces[i][0]) continue;
            int[] newIndis = new int[len - 1];
            System.arraycopy(faces[i], 0, newIndis, 0, len - 1);
            faces[i] = newIndis;
        }
    }

    private static DataList getSublist(DoubleArrayArray dd, int[] referenceTable) {
        if (dd.getLength() == 0) {
            return dd;
        }
        return RemoveDuplicateInfo.getSublist(dd.toDoubleArrayArray(null), referenceTable);
    }

    private static DataList getSublist(double[][] dd, int[] referenceTable) {
        if (dd.length == 0) {
            return new DoubleArrayArray.Array(new double[][]{new double[0]});
        }
        int dim = dd[0].length;
        double[][] newList = new double[referenceTable.length][dim];
        for (int i = 0; i < newList.length; ++i) {
            for (int j = 0; j < dim; ++j) {
                newList[i][j] = dd[referenceTable[i]][j];
            }
        }
        return new DoubleArrayArray.Array(newList);
    }

    private static DataList getSublist(DoubleArray d, int[] referenceTable) {
        if (d.getLength() == 0) {
            return d;
        }
        return RemoveDuplicateInfo.getSublist(d.toDoubleArray(null), referenceTable);
    }

    private static DataList getSublist(double[] d, int[] referenceTable) {
        if (d.length == 0) {
            return new DoubleArray(new double[0]);
        }
        double[] newList = new double[referenceTable.length];
        for (int i = 0; i < newList.length; ++i) {
            newList[i] = d[referenceTable[i]];
        }
        return new DoubleArray(newList);
    }

    private static DataList getSublist(IntArrayArray dd, int[] referenceTable) {
        if (dd.getLength() == 0) {
            return dd;
        }
        return RemoveDuplicateInfo.getSublist(dd.toIntArrayArray(null), referenceTable);
    }

    private static DataList getSublist(int[][] dd, int[] referenceTable) {
        if (dd.length == 0) {
            return new IntArrayArray.Array(new int[][]{new int[0]});
        }
        int dim = dd[0].length;
        int[][] newList = new int[referenceTable.length][dim];
        for (int i = 0; i < newList.length; ++i) {
            for (int j = 0; j < dim; ++j) {
                newList[i][j] = dd[referenceTable[i]][j];
            }
        }
        return new IntArrayArray.Array(newList);
    }

    private static DataList getSublist(IntArray d, int[] referenceTable) {
        if (d.getLength() == 0) {
            return d;
        }
        return RemoveDuplicateInfo.getSublist(d.toIntArray(null), referenceTable);
    }

    private static DataList getSublist(int[] d, int[] referenceTable) {
        if (d.length == 0) {
            return new IntArray(new int[0]);
        }
        int[] newList = new int[referenceTable.length];
        for (int i = 0; i < newList.length; ++i) {
            newList[i] = d[referenceTable[i]];
        }
        return new IntArray(newList);
    }

    private static DataList getSublist(StringArrayArray dd, int[] referenceTable) {
        if (dd.getLength() == 0) {
            return dd;
        }
        return RemoveDuplicateInfo.getSublist(dd.toStringArrayArray(null), referenceTable);
    }

    private static DataList getSublist(String[][] dd, int[] referenceTable) {
        if (dd.length == 0) {
            return new StringArrayArray.Array(new String[][]{new String[0]});
        }
        int dim = dd[0].length;
        String[][] newList = new String[referenceTable.length][dim];
        for (int i = 0; i < newList.length; ++i) {
            for (int j = 0; j < dim; ++j) {
                newList[i][j] = dd[referenceTable[i]][j];
            }
        }
        return new StringArrayArray.Array(newList);
    }

    private static DataList getSublist(StringArray d, int[] referenceTable) {
        if (d.getLength() == 0) {
            return d;
        }
        return RemoveDuplicateInfo.getSublist(d.toStringArray(null), referenceTable);
    }

    private static DataList getSublist(String[] d, int[] referenceTable) {
        if (d.length == 0) {
            return new StringArray(new String[0]);
        }
        String[] newList = new String[referenceTable.length];
        for (int i = 0; i < newList.length; ++i) {
            newList[i] = d[referenceTable[i]];
        }
        return new StringArray(newList);
    }

    public static void simplifySceneTree(SceneGraphComponent g) {
        RemoveDuplicateInfo.simplifyLeafs(null, g);
        RemoveDuplicateInfo.simplifyBridges(null, g);
    }

    private static void simplifyBridges(SceneGraphComponent parent, SceneGraphComponent g) {
        if (g == null) {
            return;
        }
        List<SceneGraphComponent> children = RemoveDuplicateInfo.getComponents(g);
        for (SceneGraphComponent c : children) {
            RemoveDuplicateInfo.simplifyBridges(g, c);
        }
        if (parent == null) {
            return;
        }
        boolean possible = true;
        boolean shiftApp = false;
        boolean shiftTrafo = false;
        if (RemoveDuplicateInfo.isBridgeComponent(g)) {
            if (g.getAppearance() != null) {
                if (g.getChildComponent(0).getAppearance() != null) {
                    possible = false;
                } else {
                    shiftApp = true;
                }
            }
            if (g.getTransformation() != null) {
                if (g.getChildComponent(0).getTransformation() != null) {
                    possible = false;
                } else {
                    shiftTrafo = true;
                }
            }
            if (possible) {
                SceneGraphComponent child = g.getChildComponent(0);
                parent.removeChild(g);
                parent.addChild(child);
                if (shiftApp) {
                    child.setAppearance(g.getAppearance());
                }
                if (shiftTrafo) {
                    child.setTransformation(g.getTransformation());
                }
            }
        }
    }

    private static void simplifyLeafs(SceneGraphComponent parent, SceneGraphComponent g) {
        if (g == null) {
            return;
        }
        List<SceneGraphComponent> children = RemoveDuplicateInfo.getComponents(g);
        for (SceneGraphComponent c : children) {
            RemoveDuplicateInfo.simplifyLeafs(g, c);
        }
        if (parent == null) {
            return;
        }
        if (RemoveDuplicateInfo.isEmptyComponent(g)) {
            parent.removeChild(g);
        }
    }

    private static List<SceneGraphComponent> getComponents(SceneGraphComponent g) {
        LinkedList<SceneGraphComponent> list = new LinkedList<SceneGraphComponent>();
        for (SceneGraphNode o : g.getChildNodes()) {
            if (!(o instanceof SceneGraphComponent)) continue;
            list.add((SceneGraphComponent)o);
        }
        SceneGraphComponent[] result = new SceneGraphComponent[list.size()];
        int i = 0;
        Iterator i$ = list.iterator();
        while (i$.hasNext()) {
            SceneGraphComponent c;
            result[i] = c = (SceneGraphComponent)i$.next();
            ++i;
        }
        return list;
    }

    private static boolean isEmptyComponent(SceneGraphComponent g) {
        if (g.getGeometry() != null || g.getChildComponentCount() > 0 || g.getCamera() != null || g.getLight() != null) {
            return false;
        }
        return g.getTools() == null || g.getTools().size() <= 0;
    }

    private static boolean isBridgeComponent(SceneGraphComponent g) {
        if (g.getGeometry() != null || g.getChildComponentCount() != 1 || g.getCamera() != null || g.getLight() != null) {
            return false;
        }
        return g.getTools() == null || g.getTools().size() <= 0;
    }

    private static IndexedFaceSet pointSetToIndexedFaceSet(PointSet p) {
        if (p instanceof IndexedFaceSet) {
            return (IndexedFaceSet)p;
        }
        if (p instanceof IndexedLineSet) {
            return RemoveDuplicateInfo.indexedLineSetToIndexedFaceSet((IndexedLineSet)p);
        }
        IndexedFaceSet f = new IndexedFaceSet(p.getNumPoints(), 0);
        f.setGeometryAttributes(p.getGeometryAttributes());
        f.setVertexAttributes(p.getVertexAttributes());
        return f;
    }

    private static IndexedFaceSet indexedLineSetToIndexedFaceSet(IndexedLineSet l) {
        if (l instanceof IndexedFaceSet) {
            return (IndexedFaceSet)l;
        }
        IndexedFaceSet f = new IndexedFaceSet(l.getNumPoints(), 0);
        f.setGeometryAttributes(l.getGeometryAttributes());
        f.setVertexAttributes(l.getVertexAttributes());
        f.setEdgeCountAndAttributes(l.getEdgeAttributes());
        return f;
    }

    private class Box {
        int numOfPoints = 0;
        double[] originalMax;
        double[] originalMin;
        double[] realMax;
        double[] realMin;
        boolean empty;
        List<Integer> innerPoints = new LinkedList<Integer>();

        private Box(double[] max, double[] min, int dim) {
            this.originalMax = max;
            this.originalMin = min;
            this.realMax = new double[dim];
            this.realMin = new double[dim];
            this.empty = true;
        }

        private boolean addPointIfPossible(int point) {
            double[] p = RemoveDuplicateInfo.this.points[point];
            if (!RemoveDuplicateInfo.this.inBetween(this.originalMax, this.originalMin, RemoveDuplicateInfo.this.eps, p)) {
                return false;
            }
            if (this.empty) {
                for (int i = 0; i < RemoveDuplicateInfo.this.dim; ++i) {
                    this.realMax[i] = this.realMin[i] = p[i];
                }
                this.empty = false;
            } else {
                for (int i = 0; i < RemoveDuplicateInfo.this.dim; ++i) {
                    if (p[i] >= this.realMax[i]) {
                        this.realMax[i] = p[i];
                    }
                    if (!(p[i] <= this.realMin[i])) continue;
                    this.realMin[i] = p[i];
                }
            }
            this.innerPoints.add(point);
            ++this.numOfPoints;
            return true;
        }

        private double getSize() {
            double size = 0.0;
            for (int i = 0; i < RemoveDuplicateInfo.this.dim; ++i) {
                if (!(this.realMax[i] - this.realMin[i] > size)) continue;
                size = this.realMax[i] - this.realMin[i];
            }
            return size;
        }
    }
}

