/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.IndexedLineSetUtility;
import de.jreality.geometry.ParametricSurfaceFactory;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.geometry.SphereUtility;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Sphere;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;

public class Primitives {
    private static double[][] cubeVerts3 = new double[][]{{1.0, 1.0, 1.0}, {1.0, 1.0, -1.0}, {1.0, -1.0, 1.0}, {1.0, -1.0, -1.0}, {-1.0, 1.0, 1.0}, {-1.0, 1.0, -1.0}, {-1.0, -1.0, 1.0}, {-1.0, -1.0, -1.0}};
    private static double[][] cubeVerts4 = new double[][]{{1.0, 1.0, 1.0, 1.0}, {1.0, 1.0, -1.0, 1.0}, {1.0, -1.0, 1.0, 1.0}, {1.0, -1.0, -1.0, 1.0}, {-1.0, 1.0, 1.0, 1.0}, {-1.0, 1.0, -1.0, 1.0}, {-1.0, -1.0, 1.0, 1.0}, {-1.0, -1.0, -1.0, 1.0}};
    private static int[][] cubeIndices = new int[][]{{0, 2, 3, 1}, {1, 5, 4, 0}, {0, 4, 6, 2}, {5, 7, 6, 4}, {2, 6, 7, 3}, {3, 7, 5, 1}};
    private static int[][] openCubeIndices = new int[][]{{0, 2, 3, 1}, {1, 5, 4, 0}, {5, 7, 6, 4}, {2, 6, 7, 3}, {3, 7, 5, 1}};
    private static double[][] cubeColors = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 0.0}, {0.0, 1.0, 1.0}};
    private static double[][] tetrahedronVerts3 = new double[][]{{1.0, 1.0, 1.0}, {1.0, -1.0, -1.0}, {-1.0, 1.0, -1.0}, {-1.0, -1.0, 1.0}};
    private static int[][] tetrahedronIndices = new int[][]{{0, 1, 2}, {2, 1, 3}, {1, 0, 3}, {0, 2, 3}};
    private static double[][] tetrahedronColors = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}, {1.0, 0.0, 1.0}};
    public static double[][] icoVerts3 = new double[][]{{0.850651026, 0.0, 0.525731027}, {0.850651026, 0.0, -0.525731027}, {0.525731027, 0.850651026, 0.0}, {0.525731027, -0.850651026, 0.0}, {0.0, -0.525731027, 0.850651026}, {0.0, 0.525731027, 0.850651026}, {-0.850651026, 0.0, -0.525731027}, {-0.850651026, 0.0, 0.525731027}, {-0.525731027, 0.850651026, 0.0}, {0.0, 0.525731027, -0.850651026}, {0.0, -0.525731027, -0.850651026}, {-0.525731027, -0.850651026, 0.0}};
    private static double[][] icoVerts4 = new double[][]{{0.850651026, 0.0, 0.525731027, 1.0}, {0.850651026, 0.0, -0.525731027, 1.0}, {0.525731027, 0.850651026, 0.0, 1.0}, {0.525731027, -0.850651026, 0.0, 1.0}, {0.0, -0.525731027, 0.850651026, 1.0}, {0.0, 0.525731027, 0.850651026, 1.0}, {-0.850651026, 0.0, -0.525731027, 1.0}, {-0.850651026, 0.0, 0.525731027, 1.0}, {-0.525731027, 0.850651026, 0.0, 1.0}, {0.0, 0.525731027, -0.850651026, 1.0}, {0.0, -0.525731027, -0.850651026, 1.0}, {-0.525731027, -0.850651026, 0.0, 1.0}};
    private static int[][] icoIndices = new int[][]{{0, 1, 2}, {0, 3, 1}, {0, 4, 3}, {0, 5, 4}, {0, 2, 5}, {6, 7, 8}, {6, 8, 9}, {6, 9, 10}, {6, 10, 11}, {6, 11, 7}, {1, 3, 10}, {3, 4, 11}, {4, 5, 7}, {5, 2, 8}, {2, 1, 9}, {7, 11, 4}, {8, 7, 5}, {9, 8, 2}, {10, 9, 1}, {11, 10, 3}};
    public static IndexedFaceSet sharedIcosahedron = null;

    private Primitives() {
    }

    public static IndexedFaceSet cube() {
        return Primitives.cube(false);
    }

    public static IndexedFaceSet coloredCube() {
        return Primitives.cube(true);
    }

    public static IndexedFaceSet openCube() {
        IndexedFaceSet cube = new IndexedFaceSet(8, 5);
        cube.setFaceAttributes(Attribute.INDICES, new IntArrayArray.Array(openCubeIndices));
        cube.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(cubeVerts3));
        IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(cube);
        IndexedFaceSetUtility.calculateAndSetFaceNormals(cube);
        return cube;
    }

    public static IndexedFaceSet cube4(boolean colored) {
        IndexedFaceSet cube = new IndexedFaceSet(8, 6);
        cube.setFaceAttributes(Attribute.INDICES, new IntArrayArray.Array(cubeIndices));
        cube.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(4).createReadOnly(cubeVerts4));
        if (colored) {
            cube.setFaceAttributes(Attribute.COLORS, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(cubeColors));
        }
        IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(cube);
        IndexedFaceSetUtility.calculateAndSetFaceNormals(cube);
        return cube;
    }

    public static IndexedFaceSet cube(boolean colored) {
        IndexedFaceSet cube = new IndexedFaceSet(8, 6);
        cube.setFaceAttributes(Attribute.INDICES, new IntArrayArray.Array(cubeIndices));
        cube.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(cubeVerts3));
        if (colored) {
            cube.setFaceAttributes(Attribute.COLORS, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(cubeColors));
        }
        IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(cube);
        IndexedFaceSetUtility.calculateAndSetFaceNormals(cube);
        return cube;
    }

    public static IndexedFaceSet cube(double width, double height, double depth, boolean colored) {
        return Primitives.box(width, height, depth, colored);
    }

    public static IndexedFaceSet box(double width, double height, double depth, boolean colored) {
        return Primitives.box(width, height, depth, colored, 0);
    }

    public static IndexedFaceSet box(double width, double height, double depth, boolean colored, int metric) {
        double w = width / 2.0;
        double h = height / 2.0;
        double d = depth / 2.0;
        double[][] points = new double[][]{{w, h, d}, {w, h, -d}, {w, -h, d}, {w, -h, -d}, {-w, h, d}, {-w, h, -d}, {-w, -h, d}, {-w, -h, -d}};
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(8);
        ifsf.setVertexCoordinates(points);
        ifsf.setFaceCount(cubeIndices.length);
        ifsf.setFaceIndices(cubeIndices);
        if (colored) {
            ifsf.setFaceColors(cubeColors);
        }
        ifsf.setMetric(metric);
        ifsf.setGenerateFaceNormals(true);
        ifsf.setGenerateEdgesFromFaces(true);
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    public static IndexedFaceSet coloredCube(double width, double height, double depth) {
        return Primitives.box(width, height, depth, true);
    }

    public static IndexedFaceSet cube(double width, double height, double depth) {
        return Primitives.box(width, height, depth, false);
    }

    public static IndexedFaceSet tetrahedron() {
        return Primitives.tetrahedron(false);
    }

    public static IndexedFaceSet coloredTetrahedron() {
        return Primitives.tetrahedron(true);
    }

    public static IndexedFaceSet tetrahedron(boolean colored) {
        IndexedFaceSet tetrahedron = new IndexedFaceSet(4, 4);
        tetrahedron.setFaceAttributes(Attribute.INDICES, new IntArrayArray.Array(tetrahedronIndices));
        tetrahedron.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(tetrahedronVerts3));
        if (colored) {
            tetrahedron.setFaceAttributes(Attribute.COLORS, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(tetrahedronColors));
        }
        IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(tetrahedron);
        IndexedFaceSetUtility.calculateAndSetFaceNormals(tetrahedron);
        return tetrahedron;
    }

    public static IndexedFaceSet icosahedron() {
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(12);
        ifsf.setFaceCount(20);
        ifsf.setVertexCoordinates(icoVerts3);
        ifsf.setFaceIndices(icoIndices);
        ifsf.setGenerateEdgesFromFaces(true);
        ifsf.setGenerateFaceNormals(true);
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    public static PointSet point(double[] center) {
        PointSet ps = new PointSet(1);
        int n = center.length;
        double[][] pts = new double[1][n];
        System.arraycopy(center, 0, pts[0], 0, n);
        double[][] texc = new double[][]{{0.0, 0.0}};
        ps.setVertexCountAndAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(n).createReadOnly(pts));
        ps.setVertexAttributes(Attribute.TEXTURE_COORDINATES, StorageModel.DOUBLE_ARRAY.array(2).createReadOnly(texc));
        return ps;
    }

    public static SceneGraphComponent sphere(double radius, double x, double y, double z) {
        return Primitives.sphere(radius, new double[]{x, y, z}, 0);
    }

    public static SceneGraphComponent sphere(double radius, double[] center) {
        return Primitives.sphere(radius, center, 0);
    }

    public static SceneGraphComponent sphere(double radius, double[] center, int metric) {
        SceneGraphComponent sgc = SceneGraphUtility.createFullSceneGraphComponent("sphere");
        if (center == null) {
            center = P3.originP3;
        }
        MatrixBuilder.init(null, metric).translate(center).scale(radius).assignTo(sgc.getTransformation());
        sgc.setGeometry(new Sphere());
        return sgc;
    }

    public static SceneGraphComponent wireframeSphere() {
        return Primitives.wireframeSphere(40, 20);
    }

    public static SceneGraphComponent wireframeSphere(int w, int h) {
        SceneGraphComponent hypersphere = SceneGraphUtility.createFullSceneGraphComponent("wireframe sphere");
        hypersphere.setGeometry(SphereUtility.sphericalPatch(0.0, 0.0, 360.0, 180.0, w, h, 1.0));
        Appearance ap = hypersphere.getAppearance();
        ap.setAttribute("showFaces", false);
        ap.setAttribute("showLines", true);
        ap.setAttribute("showPoints", false);
        ap.setAttribute("lineShader.tubeDraw", false);
        ap.setAttribute("lineShader.diffuseColor", new Color(200, 200, 200));
        ap.setAttribute("lineShader.lineWidth", 0.5);
        return hypersphere;
    }

    public static IndexedFaceSet cylinder(int n) {
        return Primitives.cylinder(n, 1.0, -1.0, 1.0, Math.PI * 2);
    }

    public static IndexedFaceSet cylinder(int n, double r, double zmin, double zmax, double thetamax) {
        return Primitives.cylinder(n, r, r, zmin, zmax, thetamax);
    }

    public static IndexedFaceSet cylinder(int n, double r, double R, double zmin, double zmax, double thetamax) {
        return Primitives.cylinder(n, r, R, zmin, zmax, thetamax, 2);
    }

    public static IndexedFaceSet cylinder(int n, double r, double R, double zmin, double zmax, double thetamax, int res) {
        int rn = n + 1;
        double[][] verts = new double[res * rn][3];
        double angle = 0.0;
        double delta = thetamax / (double)n;
        for (int j = 0; j < res; ++j) {
            double melta = zmin + (double)j / ((double)res - 1.0) * (zmax - zmin);
            for (int i = 0; i < rn; ++i) {
                angle = (double)i * delta;
                verts[j * rn + i][0] = r * Math.cos(angle);
                verts[j * rn + i][1] = R * Math.sin(angle);
                verts[j * rn + i][2] = melta;
            }
        }
        QuadMeshFactory qmf = new QuadMeshFactory();
        qmf.setULineCount(rn);
        qmf.setVLineCount(res);
        qmf.setClosedInUDirection(Math.abs(Math.PI * 2 - thetamax) < 1.0E-7);
        qmf.setVertexCoordinates(verts);
        qmf.setGenerateEdgesFromFaces(true);
        qmf.setGenerateFaceNormals(true);
        qmf.setGenerateVertexNormals(true);
        qmf.setGenerateTextureCoordinates(true);
        qmf.update();
        IndexedFaceSet ifs = qmf.getIndexedFaceSet();
        ifs.setGeometryAttributes("rendermanProxyCommand", "Cylinder " + r + " " + zmin + " " + zmax + " " + 57.29577951308232 * thetamax);
        return ifs;
    }

    public static SceneGraphComponent closedCylinder(int n, double r, double zmin, double zmax, double thetamax) {
        return Primitives.closedCylinder(n, r, r, zmin, zmax, thetamax);
    }

    public static SceneGraphComponent closedCylinder(int n, double r, double R, double zmin, double zmax, double thetamax) {
        if (Math.abs(thetamax - Math.PI * 2) > 0.001) {
            throw new IllegalArgumentException("Can only do full cylinders");
        }
        SceneGraphComponent result = new SceneGraphComponent("closedCylinder");
        SceneGraphComponent d1 = new SceneGraphComponent("disk1");
        SceneGraphComponent d2 = new SceneGraphComponent("disk2");
        IndexedFaceSet cyl = Primitives.cylinder(n, r, R, zmin, zmax, thetamax);
        result.setGeometry(cyl);
        IndexedFaceSet disk = Primitives.regularPolygon(n, 0.0);
        d1.setGeometry(disk);
        d2.setGeometry(disk);
        result.addChild(d1);
        result.addChild(d2);
        MatrixBuilder.euclidean().translate(0.0, 0.0, zmin).scale(r, R, 1.0).assignTo(d1);
        MatrixBuilder.euclidean().translate(0.0, 0.0, zmax).rotateX(Math.PI).scale(r, R, 1.0).assignTo(d2);
        return result;
    }

    public static IndexedFaceSet cone(int n) {
        return Primitives.cone(n, 1.0);
    }

    public static IndexedFaceSet cone(int n, double h) {
        double[][] verts = new double[n + 1][3];
        double angle = 0.0;
        double delta = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            angle = (double)i * delta;
            verts[i] = new double[]{Math.sin(angle), Math.cos(angle), 0.0};
        }
        verts[n] = new double[]{0.0, 0.0, h};
        int[][] indices = new int[n][];
        for (int i = 0; i < n; ++i) {
            indices[i] = new int[]{i, n, (i + 1) % n};
        }
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(n + 1);
        ifsf.setFaceCount(n);
        ifsf.setVertexCoordinates(verts);
        ifsf.setFaceIndices(indices);
        ifsf.setGenerateEdgesFromFaces(true);
        ifsf.setGenerateFaceNormals(true);
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    public static IndexedFaceSet pyramid(double[][] base, double[] tip) {
        int i;
        int n = base.length;
        int l = base[0].length;
        if (l != tip.length) {
            throw new IllegalArgumentException("Points must have same dimension");
        }
        double[][] newVerts = new double[n + 1][l];
        for (int i2 = 0; i2 < n; ++i2) {
            System.arraycopy(base[i2], 0, newVerts[i2], 0, l);
        }
        System.arraycopy(tip, 0, newVerts[n], 0, l);
        int[][] indices = new int[n + 1][];
        for (i = 0; i < n; ++i) {
            indices[i] = new int[3];
            indices[i][0] = i;
            indices[i][2] = (i + 1) % n;
            indices[i][1] = n;
        }
        indices[n] = new int[n];
        for (i = 0; i < n; ++i) {
            indices[n][i] = i;
        }
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(n + 1);
        ifsf.setFaceCount(n + 1);
        ifsf.setVertexCoordinates(newVerts);
        ifsf.setFaceIndices(indices);
        ifsf.setGenerateEdgesFromFaces(true);
        ifsf.setGenerateFaceNormals(true);
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    public static IndexedLineSet discreteTorusKnot(double R, double r, int n, int m, int nPts) {
        double[][] vertices = new double[nPts][3];
        for (int i = 0; i < nPts; ++i) {
            double angle = (double)i * 2.0 * Math.PI / (double)nPts;
            double a = (double)m * angle;
            double A = (double)n * angle;
            double C = Math.cos(A);
            double S = Math.sin(A);
            double c = r * Math.cos(a);
            double s = r * Math.sin(a);
            vertices[i][0] = C * (R + c);
            vertices[i][1] = s;
            vertices[i][2] = S * (R + c);
        }
        return IndexedLineSetUtility.createCurveFromPoints(vertices, true);
    }

    public static IndexedFaceSet regularPolygon(int order) {
        return Primitives.regularPolygon(order, 0.5);
    }

    public static IndexedFaceSet regularPolygon(int order, double offset) {
        double[][] verts = Primitives.regularPolygonVertices(order, offset);
        return IndexedFaceSetUtility.constructPolygon(verts);
    }

    public static double[][] regularPolygonVertices(int order, double offset) {
        double[][] verts = new double[order][3];
        double start = offset * (Math.PI * 2) / (double)order;
        for (int i = 0; i < order; ++i) {
            double angle = start + (double)i * 2.0 * Math.PI / (double)order;
            verts[i][0] = Math.cos(angle);
            verts[i][1] = Math.sin(angle);
            verts[i][2] = 0.0;
        }
        return verts;
    }

    public static IndexedLineSet arrow(double x0, double y0, double x1, double y1, double tipSize) {
        return Primitives.arrow(x0, y0, x1, y1, tipSize, false);
    }

    public static IndexedLineSet arrow(double x0, double y0, double x1, double y1, double tipSize, boolean halfArrow) {
        IndexedLineSet ifs = new IndexedLineSet(4, 3);
        double[][] verts = new double[4][3];
        verts[0][0] = x0;
        verts[0][1] = y0;
        verts[0][2] = 0.0;
        verts[1][0] = x1;
        verts[1][1] = y1;
        verts[1][2] = 0.0;
        double dx = (x1 - x0) * tipSize;
        double dy = (y1 - y0) * tipSize;
        verts[2][0] = x1 - dx + dy;
        verts[2][1] = y1 - dy - dx;
        verts[2][2] = 0.0;
        verts[3][0] = x1 - dx - dy;
        verts[3][1] = y1 - dy + dx;
        verts[3][2] = 0.0;
        int[][] indices = halfArrow ? new int[2][2] : new int[3][2];
        indices[0][0] = 0;
        indices[0][1] = 1;
        indices[1][0] = 1;
        indices[1][1] = 2;
        if (!halfArrow) {
            indices[2][0] = 1;
            indices[2][1] = 3;
        }
        ifs.setVertexCountAndAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(verts));
        ifs.setEdgeCountAndAttributes(Attribute.INDICES, StorageModel.INT_ARRAY.array(2).createReadOnly(indices));
        return ifs;
    }

    public static SceneGraphComponent clippingPlane(double[] plane) {
        return Primitives.clippingPlane(plane, 0);
    }

    public static SceneGraphComponent clippingPlane(double[] plane, int sig) {
        double[] tform;
        double[] normal = new double[4];
        System.arraycopy(plane, 0, normal, 0, 3);
        double[] rotation = P3.makeRotationMatrix(null, new double[]{0.0, 0.0, 1.0}, normal);
        double l = Rn.euclideanNormSquared(normal);
        if (l != 0.0) {
            double f = -plane[3] / l;
            double[] tlate = new double[4];
            Rn.times(tlate, f, normal);
            tlate[3] = 1.0;
            double[] translation = P3.makeTranslationMatrix(null, tlate, sig);
            tform = Rn.times(null, translation, rotation);
        } else {
            tform = rotation;
        }
        SceneGraphComponent cp = SceneGraphUtility.createFullSceneGraphComponent("clippingPlane");
        cp.getTransformation().setMatrix(tform);
        cp.setGeometry(new ClippingPlane());
        return cp;
    }

    public static IndexedFaceSet torus(final double bR, final double sR, int bDetail, int sDetail) {
        ParametricSurfaceFactory.Immersion immersion = new ParametricSurfaceFactory.Immersion(){

            public int getDimensionOfAmbientSpace() {
                return 3;
            }

            public void evaluate(double x, double y, double[] targetArray, int arrayLocation) {
                double sRMulSinY = sR * Math.sin(y);
                targetArray[arrayLocation] = Math.cos(-x) * (bR + sRMulSinY);
                targetArray[arrayLocation + 1] = sR * Math.cos(y);
                targetArray[arrayLocation + 2] = Math.sin(-x) * (bR + sRMulSinY);
            }

            public boolean isImmutable() {
                return true;
            }
        };
        ParametricSurfaceFactory factory = new ParametricSurfaceFactory(immersion);
        factory.setULineCount(bDetail + 1);
        factory.setVLineCount(sDetail + 1);
        factory.setClosedInUDirection(true);
        factory.setClosedInVDirection(true);
        factory.setUMax(Math.PI * 2);
        factory.setVMax(Math.PI * 2);
        factory.setGenerateFaceNormals(true);
        factory.setGenerateVertexNormals(true);
        factory.setGenerateEdgesFromFaces(true);
        factory.setEdgeFromQuadMesh(true);
        factory.update();
        String rmanproxy = String.format("TransformBegin\nRotate 90 1 0 0\nTorus %f %f 0 360 360\nTransformEnd\n", new Double(bR), new Double(sR));
        factory.getIndexedFaceSet().setGeometryAttributes("rendermanProxyCommand", rmanproxy);
        return factory.getIndexedFaceSet();
    }

    public static IndexedFaceSet sphere(int detail) {
        ParametricSurfaceFactory.Immersion immersion = new ParametricSurfaceFactory.Immersion(){

            public int getDimensionOfAmbientSpace() {
                return 3;
            }

            public void evaluate(double x, double y, double[] targetArray, int arrayLocation) {
                targetArray[arrayLocation] = Math.cos(x) * Math.sin(y);
                targetArray[arrayLocation + 1] = Math.sin(x) * Math.sin(y);
                targetArray[arrayLocation + 2] = Math.cos(y);
            }

            public boolean isImmutable() {
                return true;
            }
        };
        ParametricSurfaceFactory factory = new ParametricSurfaceFactory(immersion);
        factory.setULineCount(detail + 1);
        factory.setVLineCount(detail + 1);
        factory.setClosedInUDirection(true);
        factory.setClosedInVDirection(false);
        factory.setUMax(Math.PI * 2);
        factory.setVMin(1.0E-5);
        factory.setVMax(3.141582653589793);
        factory.setGenerateFaceNormals(true);
        factory.setGenerateVertexNormals(true);
        factory.setGenerateTextureCoordinates(true);
        factory.update();
        return factory.getIndexedFaceSet();
    }

    public static IndexedFaceSet texturedQuadrilateral() {
        return Primitives.texturedQuadrilateral(new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 0.0});
    }

    public static IndexedFaceSet texturedQuadrilateral(double[] points) {
        IndexedFaceSetFactory factory = new IndexedFaceSetFactory();
        factory.setVertexCount(4);
        factory.setFaceCount(1);
        factory.setVertexCoordinates(points);
        factory.setFaceIndices(new int[][]{{0, 1, 2, 3}});
        factory.setVertexTextureCoordinates(new double[]{0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0});
        factory.setGenerateVertexNormals(true);
        factory.setGenerateFaceNormals(true);
        factory.setGenerateEdgesFromFaces(true);
        factory.update();
        return factory.getIndexedFaceSet();
    }

    public static IndexedFaceSet texturedBox(double width, double height, double depth) {
        double x = width / 2.0;
        double y = height / 2.0;
        double z = depth / 2.0;
        double[][] vertexCoordinates = new double[][]{{-x, -y, z}, {x, -y, z}, {x, y, z}, {-x, y, z}, {x, -y, -z}, {x, -y, z}, {x, y, z}, {x, y, -z}, {x, -y, -z}, {-x, -y, -z}, {-x, y, -z}, {x, y, -z}, {-x, -y, -z}, {-x, -y, z}, {-x, y, z}, {-x, y, -z}, {-x, y, z}, {x, y, z}, {x, y, -z}, {-x, y, -z}, {-x, -y, -z}, {x, -y, -z}, {x, -y, z}, {-x, -y, z}};
        int[][] faceIndices = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}, {12, 13, 14, 15}, {16, 17, 18, 19}, {20, 21, 22, 23}};
        double[][] textureCoordinates = new double[][]{{-x, -y}, {x, -y}, {x, y}, {-x, y}, {-y, -z}, {-y, z}, {y, z}, {y, -z}, {x, -y}, {-x, -y}, {-x, y}, {x, y}, {-y, -z}, {-y, z}, {y, z}, {y, -z}, {-x, z}, {x, z}, {x, -z}, {-x, -z}, {-x, -z}, {x, -z}, {x, z}, {-x, z}};
        IndexedFaceSetFactory factory = new IndexedFaceSetFactory();
        factory.setGenerateFaceNormals(true);
        factory.setGenerateEdgesFromFaces(true);
        factory.setVertexCount(24);
        factory.setFaceCount(6);
        factory.setVertexCoordinates(vertexCoordinates);
        factory.setFaceIndices(faceIndices);
        factory.setVertexTextureCoordinates(textureCoordinates);
        factory.update();
        return factory.getIndexedFaceSet();
    }

    static {
        sharedIcosahedron = Primitives.icosahedron();
    }
}

