/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.AbstractIndexedFaceSetFactory;
import de.jreality.geometry.OoNode;
import de.jreality.math.Rn;
import de.jreality.scene.data.Attribute;

public class ParametricTriangularSurfaceFactory
extends AbstractIndexedFaceSetFactory {
    final OoNode immersion = this.node("immersion");
    double[][] uvTriangle = new double[][]{{0.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}};
    final OoNode triangle = this.node(this.uvTriangle, "triangle");
    int subdivision = 10;
    final OoNode subNode = this.node(new Integer(this.subdivision), "subdivision");

    public ParametricTriangularSurfaceFactory() {
        this.setImmersion(new Immersion(){

            public int getDimensionOfAmbientSpace() {
                return 3;
            }

            public void evaluate(double u, double v, double[] xyz, int index) {
                xyz[index + 0] = u;
                xyz[index + 1] = v;
            }

            public boolean isImmutable() {
                return true;
            }
        });
        this.vertexCoordinates.setGenerate(true);
        this.faceIndices.setGenerate(true);
        this.edgeIndices.addIngr(this.faceIndices);
        this.vertexCoordinates.addIngr(this.triangle);
        this.vertexCoordinates.addIngr(this.subNode);
        this.vertexCoordinates.addIngr(this.immersion);
        this.vertexCoordinates.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return ParametricTriangularSurfaceFactory.this.generateVertexCoordinates((double[][])object);
            }
        });
        this.faceIndices.addIngr(this.subNode);
        this.faceIndices.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return ParametricTriangularSurfaceFactory.this.generateFaceIndices((int[][])object);
            }
        });
    }

    public void setSubdivision(int s) {
        this.subdivision = s;
        this.subNode.setObject(this.subdivision);
    }

    public int getSubdivision() {
        return this.subdivision;
    }

    protected Object generateFaceIndices(int[][] is) {
        int[][] indices = is;
        this.log("compute", Attribute.INDICES, "face");
        if (indices == null || indices.length != this.subdivision * (this.subdivision - 1) / 2 || indices[0].length != 3) {
            indices = new int[(this.subdivision - 1) * (this.subdivision - 1)][3];
        }
        int vcount = 0;
        int totalC = 0;
        for (int i = 0; i < this.subdivision - 1; ++i) {
            for (int j = 0; j < this.subdivision - i - 1; ++j) {
                indices[totalC][0] = vcount + j;
                indices[totalC][1] = vcount + j + 1;
                indices[totalC][2] = vcount + j + this.subdivision - i;
                ++totalC;
                if (j == this.subdivision - i - 2) continue;
                indices[totalC][0] = vcount + j + 1;
                indices[totalC][1] = vcount + j + this.subdivision - i + 1;
                indices[totalC][2] = vcount + j + this.subdivision - i;
                ++totalC;
            }
            vcount += this.subdivision - i;
        }
        return indices;
    }

    int nov() {
        return this.subdivision * (this.subdivision + 1) / 2;
    }

    protected int nof() {
        return (this.subdivision - 1) * (this.subdivision - 1);
    }

    double[][] generateVertexCoordinates(double[][] vertexCoordinates) {
        this.log("compute", Attribute.COORDINATES, "vertex ");
        Immersion immersion = this.getImmersion();
        if (vertexCoordinates == null || vertexCoordinates.length != this.nov()) {
            vertexCoordinates = new double[this.nov()][immersion.getDimensionOfAmbientSpace()];
        }
        double[][] domain = this.getDomainVertices(null);
        for (int i = 0; i < domain.length; ++i) {
            immersion.evaluate(domain[i][0], domain[i][1], vertexCoordinates[i], 0);
        }
        return vertexCoordinates;
    }

    public double[][] getDomainVertices(double[][] uvpoints) {
        if (uvpoints == null || uvpoints.length != this.nov() || uvpoints[0].length != 2) {
            uvpoints = new double[this.nov()][2];
        }
        double duv = 1.0 / (double)(this.subdivision - 1);
        int totalC = 0;
        for (int i = 0; i < this.subdivision; ++i) {
            int j = 0;
            while (j < this.subdivision - i) {
                double v = (double)i * duv;
                double u = (double)j * duv;
                double w = 1.0 - u - v;
                Rn.add(uvpoints[totalC], Rn.add(null, Rn.times(null, u, this.uvTriangle[1]), Rn.times(null, v, this.uvTriangle[2])), Rn.times(null, w, this.uvTriangle[0]));
                ++j;
                ++totalC;
            }
        }
        return uvpoints;
    }

    public Immersion getImmersion() {
        return (Immersion)this.immersion.getObject();
    }

    public void setImmersion(Immersion f) {
        if (f == null) {
            throw new IllegalArgumentException("Immersion cannot set to null.");
        }
        this.immersion.setObject(f);
    }

    public double[][] getUVTriangle() {
        return this.uvTriangle;
    }

    public void setUVTriangle(double[][] v) {
        this.uvTriangle = v;
        this.triangle.setObject(v);
    }

    void recompute() {
        if (!this.getImmersion().isImmutable()) {
            this.immersion.outdate();
        }
        super.recompute();
        this.vertexCoordinates.update();
    }

    protected void updateImpl() {
        super.updateImpl();
        this.vertexCoordinates.updateArray();
        this.edgeIndices.updateArray();
        this.faceIndices.updateArray();
    }

    public static interface Immersion {
        public boolean isImmutable();

        public int getDimensionOfAmbientSpace();

        public void evaluate(double var1, double var3, double[] var5, int var6);
    }
}

