/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.QuadMeshFactory;
import de.jreality.math.Rn;
import de.jreality.scene.IndexedFaceSet;

public class BezierPatchMesh {
    double[][][] controlPoints;
    int uDegree;
    int vDegree;
    double[] u0Split;
    double[] u1Split;
    double[] v0Split;
    double[] v1Split;

    public BezierPatchMesh(int uDegree, int vDegree, double[][][] cp) {
        int j;
        int i;
        this.uDegree = uDegree;
        this.vDegree = vDegree;
        int foo = cp.length;
        int bar = cp[0].length;
        if (vDegree > 1 && foo != 2 && cp.length % vDegree != 1 || uDegree > 1 && bar != 2 && cp[0].length % uDegree != 1) {
            throw new IllegalArgumentException("Array length must be for form degree*n + 1");
        }
        this.controlPoints = cp;
        this.u0Split = Rn.identityMatrix(uDegree + 1);
        this.u1Split = Rn.identityMatrix(uDegree + 1);
        this.v0Split = Rn.identityMatrix(vDegree + 1);
        this.v1Split = Rn.identityMatrix(vDegree + 1);
        double[][] ptri = new double[][]{{1.0}, {1.0, 1.0}, {1.0, 2.0, 1.0}, {1.0, 3.0, 3.0, 1.0}, {1.0, 4.0, 6.0, 4.0, 1.0}, {1.0, 5.0, 10.0, 10.0, 5.0, 1.0}};
        double factor = 1.0;
        int size = (uDegree + 1) * (uDegree + 1);
        for (i = 0; i <= uDegree; ++i) {
            for (j = 0; j <= i; ++j) {
                this.u0Split[i * (uDegree + 1) + j] = factor * ptri[i][j];
                this.u1Split[size - i * (uDegree + 1) - j - 1] = factor * ptri[i][j];
            }
            factor *= 0.5;
        }
        factor = 1.0;
        size = (vDegree + 1) * (vDegree + 1);
        for (i = 0; i <= vDegree; ++i) {
            for (j = 0; j <= i; ++j) {
                this.v0Split[i * (vDegree + 1) + j] = factor * ptri[i][j];
                this.v1Split[size - i * (vDegree + 1) - j - 1] = factor * ptri[i][j];
            }
            factor *= 0.5;
        }
    }

    public void refineU() {
        int vDim = this.controlPoints.length;
        int uDim = this.controlPoints[0].length;
        int vectorLength = this.controlPoints[0][0].length;
        double[][][] vals = new double[vDim][2 * uDim - 1][vectorLength];
        double[] icp = new double[this.uDegree + 1];
        double[] ocp = new double[this.uDegree + 1];
        for (int k = 0; k < vDim; ++k) {
            for (int i = 0; i < vectorLength; ++i) {
                int outCount = 0;
                for (int inCount = 0; inCount < uDim - 1; inCount += this.uDegree) {
                    int j;
                    for (j = 0; j <= this.uDegree; ++j) {
                        icp[j] = this.controlPoints[k][inCount + j][i];
                    }
                    Rn.matrixTimesVector(ocp, this.u0Split, icp);
                    for (j = 0; j <= this.uDegree; ++j) {
                        vals[k][outCount + j][i] = ocp[j];
                    }
                    outCount += this.uDegree;
                    Rn.matrixTimesVector(ocp, this.u1Split, icp);
                    for (j = 0; j <= this.uDegree; ++j) {
                        vals[k][outCount + j][i] = ocp[j];
                    }
                    outCount += this.uDegree;
                }
            }
        }
        this.controlPoints = vals;
    }

    public void refineV() {
        int vDim = this.controlPoints.length;
        int uDim = this.controlPoints[0].length;
        int vectorLength = this.controlPoints[0][0].length;
        double[][][] vals = new double[2 * vDim - 1][uDim][vectorLength];
        double[] icp = new double[this.vDegree + 1];
        double[] ocp = new double[this.vDegree + 1];
        for (int k = 0; k < uDim; ++k) {
            for (int i = 0; i < vectorLength; ++i) {
                int outCount = 0;
                for (int inCount = 0; inCount < vDim - 1; inCount += this.vDegree) {
                    int j;
                    for (j = 0; j <= this.vDegree; ++j) {
                        icp[j] = this.controlPoints[inCount + j][k][i];
                    }
                    Rn.matrixTimesVector(ocp, this.v0Split, icp);
                    for (j = 0; j <= this.vDegree; ++j) {
                        vals[outCount + j][k][i] = ocp[j];
                    }
                    outCount += this.vDegree;
                    Rn.matrixTimesVector(ocp, this.v1Split, icp);
                    for (j = 0; j <= this.vDegree; ++j) {
                        vals[outCount + j][k][i] = ocp[j];
                    }
                    outCount += this.vDegree;
                }
            }
        }
        this.controlPoints = vals;
    }

    public void refine() {
        this.refineU();
        this.refineV();
    }

    public double[][][] getControlPoints() {
        return this.controlPoints;
    }

    public int getUDegree() {
        return this.uDegree;
    }

    public int getVDegree() {
        return this.vDegree;
    }

    public static IndexedFaceSet representBezierPatchMeshAsQuadMesh(BezierPatchMesh bpm) {
        return BezierPatchMesh.representBezierPatchMeshAsQuadMesh(null, bpm, 0);
    }

    public static IndexedFaceSet representBezierPatchMeshAsQuadMesh(IndexedFaceSet existing, BezierPatchMesh bpm, int metric) {
        double[][][] thePoints = bpm.getControlPoints();
        QuadMeshFactory qmf = new QuadMeshFactory();
        qmf.setMetric(metric);
        qmf.setULineCount(bpm.uDegree == 1 ? thePoints[0].length : thePoints[0].length / bpm.uDegree + 1);
        qmf.setVLineCount(bpm.vDegree == 1 ? thePoints.length : thePoints.length / bpm.vDegree + 1);
        qmf.setClosedInUDirection(false);
        qmf.setClosedInVDirection(false);
        qmf.setGenerateTextureCoordinates(true);
        double[] verts1d = Rn.convertArray3DToArray1D(thePoints, bpm.uDegree, bpm.vDegree);
        qmf.setVertexCoordinates(verts1d);
        qmf.setGenerateFaceNormals(true);
        qmf.setGenerateVertexNormals(true);
        qmf.update();
        existing = qmf.getIndexedFaceSet();
        return existing;
    }
}

