/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.AbstractPointSetFactory;
import de.jreality.geometry.GeometryAttributeListSet;
import de.jreality.geometry.OoNode;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.data.StringArray;
import java.awt.Color;

public class AbstractIndexedLineSetFactory
extends AbstractPointSetFactory {
    final IndexedLineSet ils;
    GeometryAttributeListSet edge = new GeometryAttributeListSet(this, "EDGE");
    OoNode edgeCount = this.node("edgeCount", Integer.class, 0);
    AbstractPointSetFactory.AttributeGenerator edgeLabels = this.attributeGeneratorNode(this.edge, String[].class, Attribute.LABELS);

    AbstractIndexedLineSetFactory(IndexedLineSet ils, int metric) {
        super(ils, metric);
        this.edgeLabels.addIngr(this.edgeCount);
        this.edgeLabels.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractIndexedLineSetFactory.this.indexString((Integer)AbstractIndexedLineSetFactory.this.edgeCount.getObject());
            }
        });
        this.ils = ils;
    }

    AbstractIndexedLineSetFactory(int metric) {
        this(new IndexedLineSet(0, 0), metric);
    }

    AbstractIndexedLineSetFactory(IndexedLineSet existing) {
        this(existing, 0);
    }

    public AbstractIndexedLineSetFactory() {
        this(new IndexedLineSet(0, 0), 0);
    }

    protected int noe() {
        return (Integer)this.edgeCount.getObject();
    }

    public int getEdgeCount() {
        return this.noe();
    }

    void setEdgeCount(int count) {
        this.edge.setCount(count);
        this.edgeCount.setObject(new Integer(count));
    }

    public int getLineCount() {
        return this.getEdgeCount();
    }

    public void setLineCount(int count) {
        this.setEdgeCount(count);
    }

    protected void setEdgeAttribute(Attribute attr, DataList data) {
        this.edge.setAttribute(attr, data);
    }

    protected void setEdgeAttribute(Attribute attr, double[] data) {
        if (data != null && (this.noe() == 0 && data.length != 0 || data.length % this.noe() != 0)) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setEdgeAttribute(attr, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.nov()));
    }

    protected void setEdgeAttribute(Attribute attr, double[][] data) {
        this.setEdgeAttribute(attr, StorageModel.DOUBLE_ARRAY.array(data[0].length).createReadOnly(data));
    }

    protected void setEdgeAttributes(DataListSet dls) {
        this.edge.setAttributes(dls);
    }

    protected void setEdgeIndices(DataList data) {
        this.setEdgeAttribute(Attribute.INDICES, data);
    }

    protected void setEdgeIndices(int[][] data) {
        this.setEdgeAttribute(Attribute.INDICES, new IntArrayArray.Array(data));
    }

    protected void setEdgeIndices(int[] data, int pointCountPerLine) {
        if (data != null && data.length != pointCountPerLine * this.noe()) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setEdgeAttribute(Attribute.INDICES, data == null ? null : new IntArrayArray.Inlined(data, pointCountPerLine));
    }

    protected void setEdgeIndices(int[] data) {
        this.setEdgeIndices(data, 2);
    }

    protected void setEdgeNormals(DataList data) {
        this.setEdgeAttribute(Attribute.NORMALS, data);
    }

    protected void setEdgeNormals(double[] data) {
        if (data != null && data.length % this.noe() != 0) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setEdgeAttribute(Attribute.NORMALS, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.noe()));
    }

    protected void setEdgeNormals(double[][] data) {
        this.setEdgeAttribute(Attribute.NORMALS, new DoubleArrayArray.Array(data));
    }

    protected void setEdgeColors(DataList data) {
        this.setEdgeAttribute(Attribute.COLORS, data);
    }

    protected void setEdgeColors(double[] data) {
        if (data != null && data.length % this.noe() != 0) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setEdgeAttribute(Attribute.COLORS, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.noe()));
    }

    protected void setEdgeColors(Color[] data) {
        this.setEdgeColors(AbstractIndexedLineSetFactory.toDoubleArray(data));
    }

    protected void setEdgeColors(double[][] data) {
        this.setEdgeAttribute(Attribute.COLORS, new DoubleArrayArray.Array(data));
    }

    protected void setEdgeLabels(DataList data) {
        this.setVertexAttribute(Attribute.LABELS, data);
    }

    protected void setEdgeLabels(String[] data) {
        if (data != null && data.length != this.noe()) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setEdgeAttribute(Attribute.LABELS, data == null ? null : new StringArray(data));
    }

    protected void setEdgeRelativeRadii(DataList data) {
        this.setEdgeAttribute(Attribute.RELATIVE_RADII, data);
    }

    protected void setEdgeRelativeRadii(double[] data) {
        if (data != null && data.length != this.noe()) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setEdgeAttribute(Attribute.RELATIVE_RADII, data == null ? null : new DoubleArray(data));
    }

    void recompute() {
        super.recompute();
        if (this.isGenerateEdgeLabels()) {
            this.edgeLabels.update();
        }
    }

    protected void updateImpl() {
        super.updateImpl();
        if (this.ils.getNumEdges() != this.getEdgeCount()) {
            this.ils.setNumEdges(this.getEdgeCount());
        }
        this.updateGeometryAttributeCathegory(this.edge);
        this.edgeLabels.updateArray();
    }

    public IndexedLineSet getIndexedLineSet() {
        return this.ils;
    }

    public boolean isGenerateEdgeLabels() {
        return this.edgeLabels.isGenerate();
    }

    public void setGenerateEdgeLabels(boolean generateEdgeLabels) {
        this.edgeLabels.setGenerate(generateEdgeLabels);
    }
}

