/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.util;

import java.util.Arrays;

public class PitchShifter {
    private static final double M_PI = Math.PI;
    float[] gInFIFO;
    float[] gOutFIFO;
    float[] gFFTworksp;
    float[] gLastPhase;
    float[] gSumPhase;
    float[] gOutputAccum;
    float[] gAnaFreq;
    float[] gAnaMagn;
    float[] gSynFreq;
    float[] gSynMagn;
    private int MAX_FRAME_LENGTH;
    private float sampleRate = 44100.0f;
    private int fftFrameSize = 1024;
    private int oversampling = 32;
    private float pitchShift = 1.0f;

    public PitchShifter(int maxFrameSize) {
        this.MAX_FRAME_LENGTH = maxFrameSize;
        this.gInFIFO = new float[this.MAX_FRAME_LENGTH];
        this.gOutFIFO = new float[this.MAX_FRAME_LENGTH];
        this.gFFTworksp = new float[2 * this.MAX_FRAME_LENGTH];
        this.gLastPhase = new float[this.MAX_FRAME_LENGTH / 2 + 1];
        this.gSumPhase = new float[this.MAX_FRAME_LENGTH / 2 + 1];
        this.gOutputAccum = new float[2 * this.MAX_FRAME_LENGTH];
        this.gAnaFreq = new float[this.MAX_FRAME_LENGTH];
        this.gAnaMagn = new float[this.MAX_FRAME_LENGTH];
        this.gSynFreq = new float[this.MAX_FRAME_LENGTH];
        this.gSynMagn = new float[this.MAX_FRAME_LENGTH];
    }

    public int getMaxFrameLength() {
        return this.MAX_FRAME_LENGTH;
    }

    public int getSampleRate() {
        return (int)this.sampleRate;
    }

    public synchronized void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getFftFrameSize() {
        return this.fftFrameSize;
    }

    public synchronized void setFftFrameSize(int fftFrameSize) {
        this.fftFrameSize = fftFrameSize;
    }

    public int getOversampling() {
        return this.oversampling;
    }

    public synchronized void setOversampling(int oversampling) {
        this.oversampling = oversampling;
    }

    public double getPitchShift() {
        return this.pitchShift;
    }

    public void setPitchShift(double pitchShift) {
        this.pitchShift = (float)pitchShift;
    }

    public synchronized void smbPitchShift(float[] indata, float[] outdata, int offset, int numSampsToProcess) {
        int gRover = 0;
        int fftFrameSize2 = this.fftFrameSize / 2;
        int stepSize = this.fftFrameSize / this.oversampling;
        double freqPerBin = (double)this.sampleRate / (double)this.fftFrameSize;
        double expct = Math.PI * 2 * (double)stepSize / (double)this.fftFrameSize;
        int inFifoLatency = this.fftFrameSize - stepSize;
        if (gRover == 0) {
            gRover = inFifoLatency;
        }
        for (int i = 0; i < numSampsToProcess; ++i) {
            double tmp;
            double phase;
            double magn;
            double window;
            int k;
            this.gInFIFO[gRover] = indata[i + offset];
            outdata[i + offset] = this.gOutFIFO[gRover - inFifoLatency];
            if (++gRover < this.fftFrameSize) continue;
            gRover = inFifoLatency;
            for (k = 0; k < this.fftFrameSize; ++k) {
                window = -0.5 * Math.cos(Math.PI * 2 * (double)k / (double)this.fftFrameSize) + 0.5;
                this.gFFTworksp[2 * k] = (float)((double)this.gInFIFO[k] * window);
                this.gFFTworksp[2 * k + 1] = 0.0f;
            }
            this.smbFft(this.gFFTworksp, this.fftFrameSize, -1);
            for (k = 0; k <= fftFrameSize2; ++k) {
                double real = this.gFFTworksp[2 * k];
                double imag = this.gFFTworksp[2 * k + 1];
                magn = 2.0 * Math.sqrt(real * real + imag * imag);
                phase = Math.atan2(imag, real);
                tmp = phase - (double)this.gLastPhase[k];
                this.gLastPhase[k] = (float)phase;
                int qpd = (int)((tmp -= (double)k * expct) / Math.PI);
                qpd = qpd >= 0 ? (qpd += qpd & 1) : (qpd -= qpd & 1);
                tmp -= Math.PI * (double)qpd;
                tmp = (double)this.oversampling * tmp / (Math.PI * 2);
                tmp = (double)k * freqPerBin + tmp * freqPerBin;
                this.gAnaMagn[k] = (float)magn;
                this.gAnaFreq[k] = (float)tmp;
            }
            Arrays.fill(this.gSynMagn, 0.0f);
            for (k = 0; k <= fftFrameSize2; ++k) {
                int index = (int)((float)k * this.pitchShift);
                if (index > fftFrameSize2) continue;
                int n = index;
                this.gSynMagn[n] = this.gSynMagn[n] + this.gAnaMagn[k];
                this.gSynFreq[index] = this.gAnaFreq[k] * this.pitchShift;
            }
            for (k = 0; k <= fftFrameSize2; ++k) {
                magn = this.gSynMagn[k];
                tmp = this.gSynFreq[k];
                tmp -= (double)k * freqPerBin;
                tmp /= freqPerBin;
                tmp = Math.PI * 2 * tmp / (double)this.oversampling;
                int n = k;
                this.gSumPhase[n] = (float)((double)this.gSumPhase[n] + (tmp += (double)k * expct));
                phase = this.gSumPhase[k];
                this.gFFTworksp[2 * k] = (float)(magn * Math.cos(phase));
                this.gFFTworksp[2 * k + 1] = (float)(magn * Math.sin(phase));
            }
            for (k = this.fftFrameSize + 2; k < 2 * this.fftFrameSize; ++k) {
                this.gFFTworksp[k] = 0.0f;
            }
            this.smbFft(this.gFFTworksp, this.fftFrameSize, 1);
            for (k = 0; k < this.fftFrameSize; ++k) {
                window = -0.5 * Math.cos(Math.PI * 2 * (double)k / (double)this.fftFrameSize) + 0.5;
                int n = k;
                this.gOutputAccum[n] = (float)((double)this.gOutputAccum[n] + 2.0 * window * (double)this.gFFTworksp[2 * k] / (double)(fftFrameSize2 * this.oversampling));
            }
            for (k = 0; k < stepSize; ++k) {
                this.gOutFIFO[k] = this.gOutputAccum[k];
            }
            System.arraycopy(this.gOutputAccum, stepSize, this.gOutputAccum, 0, this.fftFrameSize);
            for (k = 0; k < inFifoLatency; ++k) {
                this.gInFIFO[k] = this.gInFIFO[k + stepSize];
            }
        }
    }

    void smbFft(float[] fftBuffer, int fftFrameSize, int sign) {
        int j;
        int i;
        for (i = 2; i < 2 * fftFrameSize - 2; i += 2) {
            j = 0;
            for (int bitm = 2; bitm < 2 * fftFrameSize; bitm <<= 1) {
                if ((i & bitm) != 0) {
                    ++j;
                }
                j <<= 1;
            }
            if (i >= j) continue;
            int p1 = i;
            int p2 = j;
            float temp = fftBuffer[p1];
            fftBuffer[p1++] = fftBuffer[p2];
            fftBuffer[p2++] = temp;
            temp = fftBuffer[p1];
            fftBuffer[p1] = fftBuffer[p2];
            fftBuffer[p2] = temp;
        }
        int k = 0;
        int le = 2;
        while ((long)k < (long)(Math.log(fftFrameSize) / Math.log(2.0) + 0.5)) {
            int le2 = (le <<= 1) >> 1;
            float ur = 1.0f;
            float ui = 0.0f;
            float arg = (float)(Math.PI / (double)(le2 >> 1));
            float wr = (float)Math.cos(arg);
            float wi = (float)((double)sign * Math.sin(arg));
            for (j = 0; j < le2; j += 2) {
                float tr;
                int p1r = j;
                int p1i = p1r + 1;
                int p2r = p1r + le2;
                int p2i = p2r + 1;
                for (i = j; i < 2 * fftFrameSize; i += le) {
                    tr = fftBuffer[p2r] * ur - fftBuffer[p2i] * ui;
                    float ti = fftBuffer[p2r] * ui + fftBuffer[p2i] * ur;
                    fftBuffer[p2r] = fftBuffer[p1r] - tr;
                    fftBuffer[p2i] = fftBuffer[p1i] - ti;
                    int n = p1r;
                    fftBuffer[n] = fftBuffer[n] + tr;
                    int n2 = p1i;
                    fftBuffer[n2] = fftBuffer[n2] + ti;
                    p1r += le;
                    p1i += le;
                    p2r += le;
                    p2i += le;
                }
                tr = ur * wr - ui * wi;
                ui = ur * wi + ui * wr;
                ur = tr;
            }
            ++k;
        }
    }

    double smbAtan2(double x, double y) {
        double signx = x > 0.0 ? 1.0 : -1.0;
        if (x == 0.0) {
            return 0.0;
        }
        if (y == 0.0) {
            return signx * Math.PI / 2.0;
        }
        return Math.atan2(x, y);
    }
}

