/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.javasound;

import de.jreality.audio.AmbisonicsSoundEncoder;
import de.jreality.audio.SoundEncoder;
import de.jreality.audio.javasound.AbstractJavaSoundRenderer;
import de.jreality.audio.javasound.JavaSoundUtility;
import de.jreality.audio.util.Limiter;
import javax.sound.sampled.LineUnavailableException;

public class StereoRenderer
extends AbstractJavaSoundRenderer {
    private static final boolean LIMIT = true;
    byte[] buffer;
    float[] fbuffer;
    float[] fbuffer_lookAhead;
    private static final float W_SCALE = (float)Math.sqrt(0.5);
    private static final float Y_SCALE = 0.5f;
    Limiter limiter = new Limiter();

    protected SoundEncoder createSoundEncoder() {
        return new AmbisonicsSoundEncoder(){

            public void finishFrame() {
                StereoRenderer.this.renderAmbisonics(this.bw, this.bx, this.by, this.bz);
            }
        };
    }

    public void launch() throws LineUnavailableException {
        this.channels = 2;
        this.openSourceDataLine();
        this.buffer = new byte[this.bufferLength];
        this.fbuffer = new float[2 * this.frameSize];
        this.fbuffer_lookAhead = new float[2 * this.frameSize];
        super.launch();
    }

    public void renderAmbisonics(float[] wBuf, float[] xBuf, float[] yBuf, float[] zBuf) {
        this.renderAmbisonicsLimited(wBuf, xBuf, yBuf, zBuf);
    }

    public void renderAmbisonicsLimited(float[] wBuf, float[] xBuf, float[] yBuf, float[] zBuf) {
        for (int i = 0; i < this.frameSize; ++i) {
            float w = wBuf[i] * W_SCALE;
            float y = yBuf[i] * 0.5f;
            this.fbuffer_lookAhead[2 * i] = w + y;
            this.fbuffer_lookAhead[2 * i + 1] = w - y;
        }
        this.limiter.limit(this.fbuffer, this.fbuffer_lookAhead);
        JavaSoundUtility.floatToByte(this.buffer, this.fbuffer);
        this.writePCM(this.buffer, 0, this.bufferLength);
        this.swapBuffers();
    }

    protected void swapBuffers() {
        float[] tmpF = this.fbuffer;
        this.fbuffer = this.fbuffer_lookAhead;
        this.fbuffer_lookAhead = tmpF;
    }

    public void renderAmbisonicsPlain(float[] wBuf, float[] xBuf, float[] yBuf, float[] zBuf) {
        for (int i = 0; i < this.frameSize; ++i) {
            float w = wBuf[i] * W_SCALE;
            float y = yBuf[i] * 0.5f;
            this.fbuffer[2 * i] = w + y;
            this.fbuffer[2 * i + 1] = w - y;
        }
        JavaSoundUtility.floatToByte(this.buffer, this.fbuffer);
        this.writePCM(this.buffer, 0, this.bufferLength);
    }
}

