/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.javasound;

import de.jreality.audio.AbstractAudioRenderer;
import de.jreality.audio.AudioBackend;
import de.jreality.audio.SoundEncoder;
import de.jreality.audio.WavFileWriter;
import de.jreality.audio.javasound.JavaSoundUtility;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public abstract class AbstractJavaSoundRenderer
extends AbstractAudioRenderer
implements Runnable {
    private static final boolean WRITE_TO_FILE = false;
    private static final String AUDIO_FILE_NAME = "jraudio.wav";
    private SourceDataLine outputLine;
    private SoundEncoder encoder;
    protected int frameSize = 512;
    protected int sampleRate;
    protected int channels;
    private boolean running;
    Thread soundThread = null;
    protected int bufferLength;
    private WavFileWriter wavFile;

    protected void openSourceDataLine() throws LineUnavailableException {
        AudioFormat af = JavaSoundUtility.outputFormat(this.channels);
        this.outputLine = JavaSoundUtility.createSourceDataLine(af);
        System.out.println(this.outputLine.getFormat());
        this.sampleRate = (int)af.getSampleRate();
        int bytesPerSample = (af.getSampleSizeInBits() + 7) / 8;
        this.bufferLength = this.frameSize * bytesPerSample * this.channels;
        this.outputLine.open(af, 2 * this.bufferLength);
        this.outputLine.start();
    }

    public void launch() throws LineUnavailableException {
        if (this.root == null || this.microphonePath == null) {
            throw new IllegalStateException("need root and microphone path to launch");
        }
        if (this.isRunning()) {
            throw new IllegalStateException("JavaSound renderer already started...");
        }
        this.encoder = this.createSoundEncoder();
        this.backend = new AudioBackend(this.root, this.microphonePath, this.sampleRate, this.interpolationFactory, this.soundPathFactory);
        this.startRenderThread();
    }

    protected abstract SoundEncoder createSoundEncoder();

    private void startRenderThread() {
        this.setRunning(true);
        this.soundThread = new Thread((Runnable)this, "JavaSound render thread");
        this.soundThread.setPriority(10);
        this.soundThread.setDaemon(true);
        this.soundThread.start();
    }

    public synchronized void shutdown() {
        this.setRunning(false);
        while (this.isRunning()) {
            try {
                this.wait(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.soundThread = null;
        if (this.backend != null) {
            this.backend.dispose();
        }
        if (this.outputLine != null) {
            this.outputLine.close();
        }
    }

    public void run() {
        while (this.isRunning()) {
            this.backend.processFrame(this.encoder, this.frameSize);
        }
        System.out.println("JavaSound stopped");
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void setRunning(boolean b) {
        this.running = b;
    }

    public void setFrameSize(int fs) {
        this.frameSize = fs;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    protected void writePCM(byte[] buf, int offset, int len) {
        this.outputLine.write(buf, offset, len);
        if (this.wavFile != null) {
            try {
                this.wavFile.write(buf, offset, len);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

