/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.jack;

import de.gulden.framework.jjack.JJackAudioEvent;
import de.gulden.framework.jjack.JJackAudioProcessor;
import de.gulden.framework.jjack.JJackException;
import de.gulden.framework.jjack.JJackNativeClient;
import de.jreality.audio.RingBuffer;
import de.jreality.audio.RingBufferSource;
import de.jreality.audio.jack.JackManager;
import de.jreality.scene.AudioSource;
import java.nio.FloatBuffer;

public class JackSource
extends RingBufferSource
implements JJackAudioProcessor {
    private long key;

    public JackSource(String name, String target) throws JJackException {
        super(name);
        this.sampleRate = JJackNativeClient.getSampleRate();
        this.ringBuffer = new RingBuffer(this.sampleRate);
        this.key = JackManager.requestInputPorts(1, target);
        JackManager.addInput(this);
    }

    protected void finalize() throws Throwable {
        JackManager.releasePorts(this.key);
        super.finalize();
    }

    public void process(JJackAudioEvent e) {
        if (this.getState() == AudioSource.State.RUNNING) {
            FloatBuffer buffer = e.getInput(JackManager.getPort(this.key));
            buffer.rewind();
            this.ringBuffer.write(buffer);
        }
    }

    protected void writeSamples(int n) {
    }
}

