/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.jack;

import de.gulden.framework.jjack.JJackAudioEvent;
import de.gulden.framework.jjack.JJackAudioProcessor;
import de.gulden.framework.jjack.JJackException;
import de.gulden.framework.jjack.JJackNativeClient;
import de.gulden.framework.jjack.JJackNativeClientEvent;
import de.gulden.framework.jjack.JJackNativeClientListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JackManager
implements JJackAudioProcessor,
JJackNativeClientListener {
    private static String label = "jReality";
    private static int portsIn = 0;
    private static int portsOut = 0;
    private static JackManager manager = new JackManager();
    private static JJackNativeClient nativeClient = null;
    private static long currentKey = 1L;
    private static HashMap<Long, Boolean> isInput = new LinkedHashMap<Long, Boolean>();
    private static HashMap<Long, Integer> ranges = new LinkedHashMap<Long, Integer>();
    private static HashMap<Long, String> targets = new LinkedHashMap<Long, String>();
    private static HashMap<Long, Integer> ports = new LinkedHashMap<Long, Integer>();
    private static boolean ready = false;
    private static int retries = 0;
    private static List<WeakReference<JJackAudioProcessor>> inputs = new CopyOnWriteArrayList<WeakReference<JJackAudioProcessor>>();
    private static List<WeakReference<JJackAudioProcessor>> outputs = new CopyOnWriteArrayList<WeakReference<JJackAudioProcessor>>();

    public static synchronized void launch() throws JJackException {
        JackManager.shutdown();
        nativeClient = new JJackNativeClient(label, portsIn, portsOut, (JJackAudioProcessor)manager);
        nativeClient.addListener((JJackNativeClientListener)manager);
        int in = 0;
        int out = 0;
        for (long key : isInput.keySet()) {
            int r = ranges.get(key);
            String t = targets.get(key);
            if (isInput.get(key).booleanValue()) {
                nativeClient.connectInputPorts(in, r, t);
                ports.put(key, in);
                in += r;
                continue;
            }
            nativeClient.connectOutputPorts(out, r, t);
            ports.put(key, out);
            out += r;
        }
        ready = true;
    }

    public static synchronized void shutdown() {
        if (nativeClient != null) {
            nativeClient.close();
            nativeClient = null;
            ready = false;
        }
    }

    public static void setLabel(String label) {
        JackManager.label = label;
    }

    public static void setRetries(int retries) {
        JackManager.retries = retries;
    }

    public static synchronized void addInput(JJackAudioProcessor proc) {
        JackManager.addProcessor(proc, inputs);
    }

    public static synchronized void removeInput(JJackAudioProcessor proc) {
        inputs.remove(JackManager.findReference(proc, inputs));
    }

    public static synchronized void addOutput(JJackAudioProcessor proc) {
        JackManager.addProcessor(proc, outputs);
    }

    public static synchronized void removeOutput(JJackAudioProcessor proc) {
        outputs.remove(JackManager.findReference(proc, outputs));
    }

    public static synchronized long requestInputPorts(int range, String target) {
        JackManager.checkRange(range, portsIn);
        portsIn += range;
        return JackManager.requestPorts(range, target, true);
    }

    public static synchronized long requestOutputPorts(int range, String target) {
        JackManager.checkRange(range, portsOut);
        portsOut += range;
        return JackManager.requestPorts(range, target, false);
    }

    public static synchronized void releasePorts(long key) {
        if (!ranges.containsKey(key)) {
            return;
        }
        int r = ranges.get(key);
        if (isInput.get(key).booleanValue()) {
            portsIn -= r;
        } else {
            portsOut -= r;
        }
        isInput.remove(key);
        ranges.remove(key);
        targets.remove(key);
        ports.remove(key);
    }

    public static int getPort(long key) {
        return ports.get(key);
    }

    private static void checkRange(int range, int p0) {
        if (range <= 0) {
            throw new IllegalArgumentException("range must be positive");
        }
        if (p0 + range > JJackNativeClient.getMaxPorts()) {
            throw new IllegalStateException("total number of ports too large");
        }
    }

    private static long requestPorts(int range, String target, boolean inp) {
        isInput.put(currentKey, inp);
        ranges.put(currentKey, range);
        targets.put(currentKey, target);
        return currentKey++;
    }

    private static void addProcessor(JJackAudioProcessor proc, List<WeakReference<JJackAudioProcessor>> list) {
        if (JackManager.findReference(proc, list) != null) {
            return;
        }
        list.add(new WeakReference<JJackAudioProcessor>(proc));
    }

    private static WeakReference<JJackAudioProcessor> findReference(JJackAudioProcessor proc, List<WeakReference<JJackAudioProcessor>> list) {
        for (WeakReference<JJackAudioProcessor> ref : list) {
            if (ref.get() != proc) continue;
            return ref;
        }
        return null;
    }

    private JackManager() {
    }

    public void process(JJackAudioEvent e) {
        if (!ready) {
            return;
        }
        this.processList(e, inputs);
        this.processList(e, outputs);
    }

    private void processList(JJackAudioEvent e, List<WeakReference<JJackAudioProcessor>> list) {
        for (WeakReference<JJackAudioProcessor> ref : list) {
            JJackAudioProcessor proc = (JJackAudioProcessor)ref.get();
            if (proc != null) {
                proc.process(e);
                continue;
            }
            list.remove(ref);
        }
    }

    public void handleShutdown(JJackNativeClientEvent e) {
        JackManager.shutdown();
        if (retries > 0) {
            --retries;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            System.err.println("relaunching jack client, " + retries + " attempts left");
            try {
                JackManager.launch();
            }
            catch (JJackException ex) {
                ex.printStackTrace();
            }
        } else {
            System.err.println("jack client zombified; not trying to relaunch");
        }
    }
}

