/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.jack;

import de.gulden.framework.jjack.JJackAudioEvent;
import de.gulden.framework.jjack.JJackAudioProcessor;
import de.gulden.framework.jjack.JJackException;
import de.gulden.framework.jjack.JJackNativeClient;
import java.nio.FloatBuffer;

public class JackAmbisonicsStereoDecoder {
    private static final float wScale = (float)Math.sqrt(0.5);
    private static final float yScale = 0.5f;

    private JackAmbisonicsStereoDecoder() {
    }

    public static void main(String[] args) throws InterruptedException, JJackException {
        JJackNativeClient client = new JJackNativeClient("StereoDecoder", 4, 2, new JJackAudioProcessor(){

            public void process(JJackAudioEvent ev) {
                FloatBuffer bw = ev.getInput(0);
                FloatBuffer by = ev.getInput(2);
                FloatBuffer left = ev.getOutput(0);
                FloatBuffer right = ev.getOutput(1);
                int n = left.capacity();
                for (int i = 0; i < n; ++i) {
                    float w = bw.get() * wScale;
                    float y = by.get() * 0.5f;
                    left.put(w + y);
                    right.put(w - y);
                }
            }
        });
        client.connectOutputPorts("");
        while (true) {
            Thread.sleep(100L);
        }
    }
}

