/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio.jack;

import de.gulden.framework.jjack.JJackAudioEvent;
import de.gulden.framework.jjack.JJackAudioProcessor;
import de.gulden.framework.jjack.JJackException;
import de.gulden.framework.jjack.JJackNativeClient;
import de.jreality.audio.AbstractAudioRenderer;
import de.jreality.audio.AudioBackend;
import de.jreality.audio.SoundEncoder;
import de.jreality.audio.jack.JackManager;

public abstract class AbstractJackRenderer
extends AbstractAudioRenderer
implements JJackAudioProcessor {
    protected JJackAudioEvent currentJJackEvent;
    protected String target = null;
    protected SoundEncoder encoder;
    protected int nPorts;
    protected long key;
    private static boolean singleBackend = true;

    public static void setSingle(boolean single) {
        singleBackend = single;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLabel(String label) {
        JackManager.setLabel(label);
    }

    public synchronized void launch() throws JJackException {
        this.shutdown();
        this.backend = new AudioBackend(this.root, this.microphonePath, JJackNativeClient.getSampleRate(), this.interpolationFactory, this.soundPathFactory);
        this.key = JackManager.requestOutputPorts(this.nPorts, this.target);
        JackManager.addOutput(this);
        if (singleBackend) {
            JackManager.launch();
        }
    }

    public synchronized void shutdown() {
        if (this.backend != null) {
            if (singleBackend) {
                JackManager.shutdown();
            }
            JackManager.removeOutput(this);
            JackManager.releasePorts(this.key);
            this.backend.dispose();
            this.backend = null;
        }
    }

    public void process(JJackAudioEvent ev) {
        this.currentJJackEvent = ev;
        try {
            this.backend.processFrame(this.encoder, ev.getOutput().capacity());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }
}

