/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class WavFileWriter {
    private int channels;
    private int sampleSize;
    private int sampleRate;
    private RandomAccessFile os;
    private boolean closed = false;
    private long dataSize = 0L;

    public WavFileWriter(int channels, int sampleRate, int sampleSize, File outFile) throws IOException {
        this.os = new RandomAccessFile(outFile, "rw");
        this.channels = channels;
        this.sampleRate = sampleRate;
        this.sampleSize = sampleSize;
        this.os.seek(44L);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    WavFileWriter.this.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void writeInt(int arg0) throws IOException {
        this.os.writeByte(arg0 & 0xFF);
        this.os.writeByte(arg0 >> 8 & 0xFF);
        this.os.writeByte(arg0 >> 16 & 0xFF);
        this.os.writeByte(arg0 >> 24 & 0xFF);
    }

    private void writeShort(int arg0) throws IOException {
        this.os.writeByte(arg0 & 0xFF);
        this.os.writeByte(arg0 >> 8 & 0xFF);
    }

    public synchronized void write(byte[] buf, int offset, int len) throws IOException {
        if (this.closed) {
            return;
        }
        this.os.write(buf, offset, len);
        this.dataSize += (long)len;
    }

    public synchronized void close() throws IOException {
        this.os.seek(0L);
        this.os.write("RIFF".getBytes());
        this.writeInt((int)this.dataSize + 36);
        this.os.write("WAVEfmt ".getBytes());
        this.os.write(new byte[]{16, 0, 0, 0});
        this.os.write(new byte[]{1, 0});
        this.writeShort(this.channels);
        this.writeInt(this.sampleRate);
        this.writeInt(this.sampleRate * this.channels * ((this.sampleSize + 7) / 8));
        this.writeShort(this.channels * ((this.sampleSize + 7) / 8));
        this.writeShort(this.sampleSize);
        this.os.write("data".getBytes());
        this.writeInt((int)this.dataSize);
        this.os.close();
        this.closed = true;
    }
}

