/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.RingBuffer;
import de.jreality.scene.AudioSource;
import de.jreality.scene.data.SampleReader;

public abstract class RingBufferSource
extends AudioSource {
    protected RingBuffer ringBuffer = null;
    protected int sampleRate = 0;

    public RingBufferSource(String name) {
        super(name);
    }

    protected abstract void writeSamples(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readSamples(RingBuffer.Reader reader, float[] buffer, int initialIndex, int nSamples) {
        this.startReader();
        try {
            RingBufferSource ringBufferSource = this;
            synchronized (ringBufferSource) {
                int needed = nSamples - reader.valuesLeft();
                if (needed > 0 && this.state == AudioSource.State.RUNNING) {
                    this.writeSamples(needed);
                }
            }
            int n = reader.read(buffer, initialIndex, nSamples);
            return n;
        }
        finally {
            this.writingFinished();
            this.finishReader();
        }
    }

    public SampleReader createReader() {
        return new SampleReader(){
            private final RingBuffer.Reader reader;
            {
                this.reader = RingBufferSource.this.ringBuffer.createReader();
            }

            public void clear() {
                this.reader.clear();
            }

            public int getSampleRate() {
                return RingBufferSource.this.sampleRate;
            }

            public int read(float[] buffer, int initialIndex, int nSamples) {
                return RingBufferSource.this.readSamples(this.reader, buffer, initialIndex, nSamples);
            }
        };
    }
}

