/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.LowPassFilter;
import de.jreality.audio.SampleProcessor;
import de.jreality.scene.data.SampleReader;
import de.jreality.shader.EffectiveAppearance;

public class LowPassProcessor
extends SampleProcessor {
    private LowPassFilter lpf;

    public LowPassProcessor(SampleReader reader) {
        super(reader);
        this.lpf = new LowPassFilter(reader.getSampleRate());
    }

    public void setCutOff(float cutOff) {
        this.lpf.setCutOff(cutOff);
    }

    public float getCutoff() {
        return this.lpf.getCutOff();
    }

    public void clear() {
        super.clear();
        this.lpf.initialize(0.0f);
    }

    public int read(float[] buffer, int initialIndex, int nSamples) {
        int nRead = this.reader.read(buffer, initialIndex, nSamples);
        for (int i = initialIndex; i < nRead; ++i) {
            buffer[i] = this.lpf.nextValue(buffer[i]);
        }
        return nRead;
    }

    public void setProperties(EffectiveAppearance app) {
        super.setProperties(app);
        this.setCutOff(app.getAttribute("lowPassProcessorCutOff", 44000));
    }

    public boolean hasMore() {
        return this.lpf.hasMore() || super.hasMore();
    }
}

