/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

public class LowPassFilter {
    private float sampleRate;
    private float cutOff = 0.0f;
    private float alpha = 1.0f;
    private float value = 0.0f;

    public LowPassFilter() {
    }

    public LowPassFilter(float sampleRate) {
        this.setSampleRate(sampleRate);
    }

    public LowPassFilter(float sampleRate, float cutOff) {
        this.setSampleRate(sampleRate);
        this.setCutOff(cutOff);
    }

    public void setSampleRate(float sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setCutOff(float cutOff) {
        this.cutOff = cutOff;
        float tau = (float)(1.0 / (Math.PI * 2 * (double)cutOff));
        this.alpha = 1.0f / (1.0f + tau * this.sampleRate);
    }

    public float getCutOff() {
        return this.cutOff;
    }

    public float initialize(float v) {
        this.value = v;
        return v;
    }

    public float nextValue(float v) {
        this.value += this.alpha * (v - this.value);
        return this.value;
    }

    public boolean hasMore() {
        return Math.abs(this.value) > 1.0E-16f;
    }
}

