/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.AudioAttributes;
import de.jreality.audio.FDNParameters;
import de.jreality.audio.SampleProcessor;
import de.jreality.scene.data.SampleReader;
import de.jreality.shader.EffectiveAppearance;
import java.util.Arrays;

public class FDNReverb
extends SampleProcessor {
    private FDNParameters parameters;
    private float[][] delayLines;
    private int[] lineIndices;
    private float[] outBuffer;
    private float[] inBuffer;

    public FDNReverb(SampleReader reader) {
        super(reader);
        this.setParameters(AudioAttributes.DEFAULT_FDN_PARAMETERS);
    }

    public void setProperties(EffectiveAppearance app) {
        float reverbTime;
        super.setProperties(app);
        FDNParameters params = (FDNParameters)app.getAttribute("fdnParameters", AudioAttributes.DEFAULT_FDN_PARAMETERS, FDNParameters.class);
        if (params != this.parameters) {
            this.setParameters(params);
        }
        if ((reverbTime = app.getAttribute("reverbTime", 1.5f)) != params.getReverbTime()) {
            params.setReverbTime(reverbTime);
        }
    }

    public synchronized void setParameters(FDNParameters params) {
        int n = params.numberOfLines();
        int sr = this.reader.getSampleRate();
        this.parameters = params;
        this.lineIndices = new int[n];
        this.delayLines = new float[n][];
        this.inBuffer = new float[n];
        this.outBuffer = new float[n];
        for (int i = 0; i < n; ++i) {
            this.delayLines[i] = new float[(int)((double)(params.delayTime(i) * (float)sr) + 0.5)];
        }
    }

    public void clear() {
        super.clear();
        for (float[] line : this.delayLines) {
            Arrays.fill(line, 0.0f);
        }
    }

    public synchronized int read(float[] buffer, int i0, int samples) {
        int nRead = this.reader.read(buffer, i0, samples);
        int n = this.parameters.numberOfLines();
        for (int i = 0; i < nRead; ++i) {
            int j;
            float v = 0.0f;
            for (j = 0; j < n; ++j) {
                this.outBuffer[j] = this.getValue(j);
                v += this.outBuffer[j];
            }
            this.parameters.map(this.inBuffer, this.outBuffer);
            for (j = 0; j < n; ++j) {
                this.setValue(j, buffer[i0] + this.inBuffer[j]);
                this.advanceIndex(j);
            }
            buffer[i0++] = v / (float)n;
        }
        return nRead;
    }

    private float getValue(int j) {
        return this.delayLines[j][this.lineIndices[j]];
    }

    private float setValue(int j, float v) {
        float f = v;
        this.delayLines[j][this.lineIndices[j]] = f;
        return f;
    }

    private void advanceIndex(int j) {
        int i = this.lineIndices[j] + 1;
        this.lineIndices[j] = i < this.delayLines[j].length ? i : i - this.delayLines[j].length;
    }
}

