/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

public interface FDNParameters {
    public static final FDNParameters BUNNY_PARAMETERS = new FDNParameters(){
        private float[] times = new float[]{0.021f, 0.034f, 0.055f, 0.089f, 0.144f, 0.233f, 0.377f, 0.61f};
        private float[] gains = new float[8];
        private float[] tmpBuffer = new float[8];
        private float reverbTime;
        {
            this.setReverbTime(1.5f);
        }

        public float delayTime(int i) {
            return this.times[i];
        }

        public void map(float[] result, float[] argument) {
            this.iterativeStep(result, argument);
            this.iterativeStep(this.tmpBuffer, result);
            this.iterativeStep(result, this.tmpBuffer);
            for (int i = 0; i < 8; ++i) {
                int n = i;
                result[n] = result[n] * this.gains[i];
            }
        }

        private void iterativeStep(float[] result, float[] argument) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 4; ++j) {
                    result[j] = argument[2 * j] + argument[2 * j + 1];
                    result[4 + j] = argument[2 * j] - argument[2 * j + 1];
                }
            }
        }

        public int numberOfLines() {
            return 8;
        }

        public float getReverbTime() {
            return this.reverbTime;
        }

        public void setReverbTime(float t) {
            this.reverbTime = t;
            float q = (float)Math.log(0.001) / this.reverbTime;
            for (int i = 0; i < 8; ++i) {
                this.gains[i] = (float)(Math.exp(q * this.times[i]) / Math.sqrt(8.0));
            }
        }
    };

    public int numberOfLines();

    public float delayTime(int var1);

    public void map(float[] var1, float[] var2);

    public float getReverbTime();

    public void setReverbTime(float var1);
}

