/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.SampleProcessor;
import de.jreality.scene.data.SampleReader;
import java.util.Arrays;

public class EarlyReflections
extends SampleProcessor {
    private static final float[] tapTimes = new float[]{0.0199f, 0.0354f, 0.0389f, 0.0414f, 0.0699f, 0.0796f};
    private static final float[] gains = new float[]{1.02f, 0.818f, 0.635f, 0.719f, 0.267f, 0.242f};
    private static final int nTaps = tapTimes.length;
    private int[] offsets = new int[nTaps];
    private float[] delayLine;
    private long silentCount = 0L;
    private int maxDelay = 0;
    private int index = 0;

    public EarlyReflections(SampleReader reader) {
        super(reader);
        for (int i = 0; i < nTaps; ++i) {
            this.offsets[i] = (int)((double)((float)reader.getSampleRate() * tapTimes[i]) + 0.5);
            int n = this.offsets[i];
            if (n <= this.maxDelay) continue;
            this.maxDelay = n;
        }
        this.delayLine = new float[this.maxDelay];
    }

    public void clear() {
        super.clear();
        Arrays.fill(this.delayLine, 0.0f);
        this.silentCount = 0L;
    }

    public int read(float[] buffer, int initialIndex, int nSamples) {
        int nRead = this.reader.read(buffer, initialIndex, nSamples);
        for (int i = initialIndex; i < initialIndex + nSamples; ++i) {
            float u = buffer[i];
            this.silentCount = Math.abs(u) < 1.0E-16f ? ++this.silentCount : 0L;
            for (int j = 0; j < nTaps; ++j) {
                u += this.delayLine[(this.index + this.offsets[j]) % this.maxDelay] * gains[j];
            }
            this.delayLine[this.index++] = buffer[i];
            if (this.index >= this.maxDelay) {
                this.index -= this.maxDelay;
            }
            buffer[i] = u;
        }
        return nRead;
    }

    public boolean hasMore() {
        return this.silentCount < (long)this.maxDelay || super.hasMore();
    }
}

