/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.Interpolation;
import de.jreality.audio.LowPassProcessor;
import de.jreality.scene.data.SampleReader;

public class ConvertingReader
implements SampleReader {
    private SampleReader reader;
    private float[] inBuf;
    private final int targetRate;
    private final int sourceRate;
    private final int sampleRate;
    private final float ratio;
    private int targetIndex = 0;
    private int sourceIndex = 0;
    private int samplesRead = 0;
    private Interpolation interpolation;

    public static SampleReader createReader(SampleReader reader, int targetRate, Interpolation.Factory factory) {
        return reader.getSampleRate() == targetRate ? reader : new ConvertingReader(reader, targetRate, factory);
    }

    private ConvertingReader(SampleReader reader, int targetRate, Interpolation.Factory factory) {
        int sourceRate = reader.getSampleRate();
        this.sampleRate = targetRate;
        if (targetRate < sourceRate) {
            LowPassProcessor lpf = new LowPassProcessor(reader);
            lpf.setCutOff(targetRate / 2);
            this.reader = lpf;
        } else {
            this.reader = reader;
        }
        int q = this.gcd(targetRate, sourceRate);
        this.sourceRate = sourceRate / q;
        this.targetRate = targetRate / q;
        this.ratio = (float)sourceRate / (float)targetRate;
        this.inBuf = new float[this.sourceRate];
        this.interpolation = factory.newInterpolation();
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void clear() {
        this.reader.clear();
        this.targetIndex = 0;
        this.sourceIndex = 0;
        this.samplesRead = 0;
    }

    public int read(float[] buffer, int initialIndex, int nSamples) {
        int i;
        if (this.samplesRead < this.sourceRate) {
            this.samplesRead += this.reader.read(this.inBuf, this.samplesRead, this.sourceRate - this.samplesRead);
            if (this.samplesRead < this.sourceRate) {
                return 0;
            }
        }
        for (i = 0; i < nSamples; ++i) {
            if (this.targetIndex == this.targetRate) {
                this.sourceIndex = 0;
                this.targetIndex = 0;
                this.samplesRead = this.reader.read(this.inBuf, 0, this.sourceRate);
                if (this.samplesRead < this.sourceRate) break;
            }
            int j = ++this.targetIndex * this.sourceRate / this.targetRate;
            while (this.sourceIndex < j) {
                this.interpolation.put(this.inBuf[this.sourceIndex++]);
            }
            buffer[initialIndex + i] = this.interpolation.get((float)this.targetIndex * this.ratio - (float)j);
        }
        return i;
    }

    private int gcd(int m, int n) {
        while (n != 0) {
            int mm = m;
            m = n;
            n = mm % n;
        }
        return m;
    }
}

