/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.SoundEncoder;
import java.util.Arrays;

public abstract class AmbisonicsSoundEncoder
implements SoundEncoder {
    protected static final float W_SCALE = (float)Math.sqrt(0.5);
    protected float[] bw;
    protected float[] bx;
    protected float[] by;
    protected float[] bz;

    public void startFrame(int framesize) {
        if (this.bw == null || this.bw.length != framesize) {
            this.bw = new float[framesize];
            this.bx = new float[framesize];
            this.by = new float[framesize];
            this.bz = new float[framesize];
        } else {
            Arrays.fill(this.bw, 0.0f);
            Arrays.fill(this.bx, 0.0f);
            Arrays.fill(this.by, 0.0f);
            Arrays.fill(this.bz, 0.0f);
        }
    }

    public void encodeSample(float v, int idx, float r, float x, float y, float z) {
        this.encodeAmbiSample(v, idx, -z, -x, y);
    }

    public void encodeSample(float v, int idx) {
        int n = idx;
        this.bw[n] = this.bw[n] + v * W_SCALE;
    }

    protected void encodeAmbiSample(float v, int idx, float x, float y, float z) {
        this.encodeSample(v, idx);
        int n = idx;
        this.bx[n] = this.bx[n] + v * x;
        int n2 = idx;
        this.by[n2] = this.by[n2] + v * y;
        int n3 = idx;
        this.bz[n3] = this.bz[n3] + v * z;
    }

    public abstract void finishFrame();
}

