/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.audio;

import de.jreality.audio.SoundEncoder;
import java.util.Arrays;

public abstract class AmbisonicsPlanar2ndOrderSoundEncoder
implements SoundEncoder {
    protected static final float W_SCALE = (float)Math.sqrt(0.5);
    protected float[] bw;
    protected float[] bx;
    protected float[] by;
    protected float[] bu;
    protected float[] bv;

    public void startFrame(int framesize) {
        if (this.bw == null || this.bw.length != framesize) {
            this.bw = new float[framesize];
            this.bx = new float[framesize];
            this.by = new float[framesize];
            this.bu = new float[framesize];
            this.bv = new float[framesize];
        } else {
            Arrays.fill(this.bw, 0.0f);
            Arrays.fill(this.bx, 0.0f);
            Arrays.fill(this.by, 0.0f);
            Arrays.fill(this.bu, 0.0f);
            Arrays.fill(this.bv, 0.0f);
        }
    }

    public abstract void finishFrame();

    public void encodeSample(float v, int idx, float r, float x, float y, float z) {
        float rp = (float)Math.sqrt(z * z + x * x);
        if (rp > 1.0E-6f) {
            this.encodeAmbiSample(v, idx, -z / rp, -x / rp);
        } else {
            this.encodeSample(v, idx);
        }
    }

    public void encodeSample(float v, int idx) {
        int n = idx;
        this.bw[n] = this.bw[n] + v * W_SCALE;
    }

    protected void encodeAmbiSample(float v, int idx, float x, float y) {
        this.encodeSample(v, idx);
        int n = idx;
        this.bx[n] = this.bx[n] + v * x;
        int n2 = idx;
        this.by[n2] = this.by[n2] + v * y;
        int n3 = idx;
        this.bu[n3] = this.bu[n3] + v * (x * x - y * y);
        int n4 = idx;
        this.bv[n4] = this.bv[n4] + v * (2.0f * x * y);
    }
}

