/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpart;

import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.AbstractNodeEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DiagramEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpolicy.ActorEditPolicy;
import com.isencia.passerelle.workbench.model.editor.ui.editpolicy.ComponentNodeDeletePolicy;
import com.isencia.passerelle.workbench.model.editor.ui.figure.VertexFigure;
import com.isencia.passerelle.workbench.model.editor.ui.properties.CommentPropertySource;
import com.isencia.passerelle.workbench.model.editor.ui.properties.EntityPropertySource;
import com.isencia.passerelle.workbench.model.ui.VertexRelation;
import com.isencia.passerelle.workbench.model.ui.command.ChangeActorPropertyCommand;
import com.isencia.passerelle.workbench.model.ui.command.CreateConnectionCommand;
import com.isencia.passerelle.workbench.model.ui.command.DeleteComponentCommand;
import com.isencia.passerelle.workbench.model.ui.command.DeleteConnectionCommand;
import com.isencia.passerelle.workbench.model.ui.command.DeleteVertexConnectionCommand;
import com.isencia.passerelle.workbench.model.utils.ModelChangeRequest;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;

public class VertexEditPart
extends AbstractNodeEditPart {
    public static Map<Vertex, Map<NamedObj, VertexRelation>> vertexRelationMap = new HashMap<Vertex, Map<NamedObj, VertexRelation>>();
    public static Set<Vertex> vertexRelationSources = new HashSet<Vertex>();
    public static Set<Vertex> vertexRelationTargets = new HashSet<Vertex>();
    public static final ImageDescriptor IMAGE_COMMENT = Activator.getImageDescriptor("com.isencia.passerelle.actor", "icons/vertex.gif");

    public static boolean isSource(Vertex vertex) {
        if (!vertexRelationSources.contains(vertex) && !vertexRelationTargets.contains(vertex)) {
            vertexRelationSources.add(vertex);
            return true;
        }
        return vertexRelationSources.contains(vertex);
    }

    public static boolean isTarget(Vertex vertex) {
        if (!vertexRelationSources.contains(vertex)) {
            vertexRelationTargets.add(vertex);
            return true;
        }
        return vertexRelationTargets.contains(vertex);
    }

    protected IFigure createFigure() {
        return new VertexFigure(((Vertex)this.getModel()).getName(), null);
    }

    protected List getModelSourceConnections() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TypedIORelation typedIORelation = (TypedIORelation)((Vertex)this.getModel()).getContainer();
        List list = typedIORelation.linkedObjectsList();
        for (Object e : typedIORelation.linkedDestinationPortList()) {
            if (!list.contains(e)) continue;
            arrayList.add(VertexEditPart.getRelation(typedIORelation, e, (Vertex)this.getModel(), true));
        }
        for (Object e : typedIORelation.linkedObjectsList()) {
            Object object;
            if (!(e instanceof TypedIORelation) || (object = VertexEditPart.getRelation(typedIORelation, ModelUtils.getVertex((Relation)((Relation)e)), (Vertex)this.getModel(), true)) == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    protected List getModelTargetConnections() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TypedIORelation typedIORelation = (TypedIORelation)((Vertex)this.getModel()).getContainer();
        List list = typedIORelation.linkedObjectsList();
        for (Object e : typedIORelation.linkedSourcePortList()) {
            if (!list.contains(e)) continue;
            arrayList.add(VertexEditPart.getRelation(typedIORelation, e, (Vertex)this.getModel(), false));
        }
        for (Object e : typedIORelation.linkedObjectsList()) {
            Object object;
            if (!(e instanceof TypedIORelation) || (object = VertexEditPart.getRelation(typedIORelation, (Vertex)this.getModel(), ModelUtils.getVertex((Relation)((Relation)e)), false)) == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public static Object getRelation(TypedIORelation typedIORelation, Object object, Vertex vertex, boolean bl) {
        VertexRelation vertexRelation = null;
        Map<NamedObj, VertexRelation> map = vertexRelationMap.get(vertex);
        if (map == null) {
            map = new HashMap<NamedObj, VertexRelation>();
            vertexRelationMap.put(vertex, map);
        }
        if (map.containsKey(object)) {
            vertexRelation = map.get(object);
        } else {
            if (object instanceof IOPort) {
                vertexRelation = new VertexRelation((IOPort)object, vertex, bl);
            } else if (bl && VertexEditPart.isSource((Vertex)object) || !bl && VertexEditPart.isTarget(vertex)) {
                vertexRelation = new VertexRelation((Vertex)object, vertex, bl);
            }
            map.put((NamedObj)object, vertexRelation);
        }
        return vertexRelation;
    }

    public VertexFigure getVertexFigure() {
        return (VertexFigure)this.getFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connectionEditPart) {
        this.getLogger().debug("Get SourceConnectionAnchor based on ConnectionEditPart");
        return this.getVertexFigure().getInputAnchor(this.getLocation(connectionEditPart, true), ModelUtils.getLocation((NamedObj)((Vertex)this.getModel())));
    }

    private double[] getLocation(ConnectionEditPart connectionEditPart, boolean bl) {
        Object object = connectionEditPart.getModel();
        double[] dArray = new double[]{0.0, 0.0};
        if (object instanceof VertexRelation) {
            VertexRelation vertexRelation = (VertexRelation)object;
            if (vertexRelation.getPort() != null) {
                dArray = ModelUtils.getLocation((NamedObj)((VertexRelation)object).getPort().getContainer());
            } else if (!bl && vertexRelation.getTargetVertex() != null) {
                dArray = ModelUtils.getLocation((NamedObj)((VertexRelation)object).getTargetVertex());
            } else if (bl && vertexRelation.getSourceVertex() != null) {
                dArray = ModelUtils.getLocation((NamedObj)((VertexRelation)object).getSourceVertex());
            }
        }
        return dArray;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connectionEditPart) {
        this.getLogger().debug("Get TargetConnectionAnchor based on ConnectionEditPart");
        return this.getVertexFigure().getOutputAnchor(this.getLocation(connectionEditPart, false), ModelUtils.getLocation((NamedObj)((Vertex)this.getModel())));
    }

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = "hello";
            }

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = "1";
            }
        };
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentNodeDeletePolicy());
        if (this.getParent() instanceof DiagramEditPart) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActorEditPolicy(((DiagramEditPart)this.getParent()).getMultiPageEditorPart()));
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point point = new Point(((DropRequest)request).getLocation());
        return this.getVertexFigure().getSourceConnectionAnchorAt(point);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point point = new Point(((DropRequest)request).getLocation());
        return this.getVertexFigure().getTargetConnectionAnchorAt(point);
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz == AccessibleAnchorProvider.class) {
            return new AbstractGraphicalEditPart.DefaultAccessibleAnchorProvider(this){

                public List<Point> getSourceAnchorLocations() {
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    List<ConnectionAnchor> list = VertexEditPart.this.getVertexFigure().getInputAnchors();
                    for (ConnectionAnchor connectionAnchor : list) {
                        arrayList.add(connectionAnchor.getReferencePoint().getTranslated(0, -3));
                    }
                    return arrayList;
                }

                public List<Point> getTargetAnchorLocations() {
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    List<ConnectionAnchor> list = VertexEditPart.this.getVertexFigure().getOutputAnchors();
                    for (ConnectionAnchor connectionAnchor : list) {
                        arrayList.add(connectionAnchor.getReferencePoint().getTranslated(0, 3));
                    }
                    return arrayList;
                }
            };
        }
        return super.getAdapter(clazz);
    }

    @Override
    public void changeExecuted(ChangeRequest changeRequest) {
        super.changeExecuted(changeRequest);
        Object object = changeRequest.getSource();
        if (changeRequest instanceof ModelChangeRequest) {
            Class clazz = ((ModelChangeRequest)changeRequest).getType();
            if (EntityPropertySource.class.equals((Object)clazz) || CommentPropertySource.class.equals((Object)clazz)) {
                if (object == this.getModel()) {
                    this.getViewer().getEditDomain().getCommandStack().execute((Command)new ChangeActorPropertyCommand());
                }
            } else if (DeleteConnectionCommand.class.equals((Object)clazz) || DeleteVertexConnectionCommand.class.equals((Object)clazz) || DeleteComponentCommand.class.equals((Object)clazz) || CreateConnectionCommand.class.equals((Object)clazz)) {
                try {
                    this.refreshSourceConnections();
                    this.refreshTargetConnections();
                }
                catch (Exception exception) {}
            }
        }
    }
}

